/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.hickory.testing.internal.ramfilesystem;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import javax.tools.JavaFileManager;

public class RAMFileSystemRegistry {
    static RAMFileSystemRegistry singleton;
    private String protocolName;
    private Map<String, WeakReference<JavaFileManager>> prefix2jfm = new WeakHashMap<String, WeakReference<JavaFileManager>>();
    private Map<JavaFileManager, String> jfm2prefix = new WeakHashMap<JavaFileManager, String>();
    private int sequence = 0;

    private RAMFileSystemRegistry() {
        String pkgName = RAMFileSystemRegistry.class.getPackage().getName();
        this.protocolName = pkgName.substring(pkgName.lastIndexOf(".") + 1);
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        String parentPackage = pkgName.substring(0, pkgName.lastIndexOf("."));
        pkgs = pkgs == null ? parentPackage : pkgs + "|" + parentPackage;
        System.setProperty("java.protocol.handler.pkgs", pkgs);
    }

    public static synchronized RAMFileSystemRegistry getInstance() {
        if (singleton == null) {
            singleton = new RAMFileSystemRegistry();
        }
        return singleton;
    }

    public String getUrlPrefix(JavaFileManager jfm) {
        if (this.jfm2prefix.containsKey(jfm)) {
            return this.jfm2prefix.get(jfm);
        }
        String result = this.protocolName + "://jfm" + this.sequence++ + "/";
        this.jfm2prefix.put(jfm, result);
        this.prefix2jfm.put(result, new WeakReference<JavaFileManager>(jfm));
        return result;
    }

    public JavaFileManager getFileSystem(URL url) {
        String prefix = url.getProtocol() + "://" + url.getHost() + "/";
        if (this.prefix2jfm.containsKey(prefix)) {
            return (JavaFileManager)this.prefix2jfm.get(prefix).get();
        }
        return null;
    }
}

