/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;

public final class InactivityTimer {
    private static final String TAG = InactivityTimer.class.getSimpleName();
    private static final long INACTIVITY_DELAY_MS = 300000L;
    private final Context context;
    private final BroadcastReceiver powerStatusReceiver;
    private boolean registered = false;
    private Handler handler;
    private Runnable callback;
    private boolean onBattery;

    public InactivityTimer(Context context, Runnable callback) {
        this.context = context;
        this.callback = callback;
        this.powerStatusReceiver = new PowerStatusReceiver();
        this.handler = new Handler();
    }

    public void activity() {
        this.cancelCallback();
        if (this.onBattery) {
            this.handler.postDelayed(this.callback, 300000L);
        }
    }

    public void start() {
        this.registerReceiver();
        this.activity();
    }

    public void cancel() {
        this.cancelCallback();
        this.unregisterReceiver();
    }

    private void unregisterReceiver() {
        if (this.registered) {
            this.context.unregisterReceiver(this.powerStatusReceiver);
            this.registered = false;
        }
    }

    private void registerReceiver() {
        if (!this.registered) {
            this.context.registerReceiver(this.powerStatusReceiver, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
            this.registered = true;
        }
    }

    private void cancelCallback() {
        this.handler.removeCallbacksAndMessages(null);
    }

    private void onBattery(boolean onBattery) {
        this.onBattery = onBattery;
        if (this.registered) {
            this.activity();
        }
    }

    private final class PowerStatusReceiver
    extends BroadcastReceiver {
        private PowerStatusReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                boolean onBatteryNow = intent.getIntExtra("plugged", -1) <= 0;
                InactivityTimer.this.handler.post(() -> InactivityTimer.this.onBattery(onBatteryNow));
            }
        }
    }
}

