/*
 * Decompiled with CFR 0.152.
 */
package com.journeyapps.barcodescanner;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.google.zxing.client.android.R;
import com.journeyapps.barcodescanner.RotationCallback;
import com.journeyapps.barcodescanner.RotationListener;
import com.journeyapps.barcodescanner.Size;
import com.journeyapps.barcodescanner.Util;
import com.journeyapps.barcodescanner.camera.CameraInstance;
import com.journeyapps.barcodescanner.camera.CameraParametersCallback;
import com.journeyapps.barcodescanner.camera.CameraSettings;
import com.journeyapps.barcodescanner.camera.CameraSurface;
import com.journeyapps.barcodescanner.camera.CenterCropStrategy;
import com.journeyapps.barcodescanner.camera.DisplayConfiguration;
import com.journeyapps.barcodescanner.camera.FitCenterStrategy;
import com.journeyapps.barcodescanner.camera.FitXYStrategy;
import com.journeyapps.barcodescanner.camera.PreviewScalingStrategy;
import java.util.ArrayList;
import java.util.List;

public class CameraPreview
extends ViewGroup {
    private static final String TAG = CameraPreview.class.getSimpleName();
    private CameraInstance cameraInstance;
    private WindowManager windowManager;
    private Handler stateHandler;
    private boolean useTextureView = false;
    private SurfaceView surfaceView;
    private TextureView textureView;
    private boolean previewActive = false;
    private RotationListener rotationListener;
    private int openedOrientation = -1;
    private static final int ROTATION_LISTENER_DELAY_MS = 250;
    private List<StateListener> stateListeners = new ArrayList<StateListener>();
    private DisplayConfiguration displayConfiguration;
    private CameraSettings cameraSettings = new CameraSettings();
    private Size containerSize;
    private Size previewSize;
    private Rect surfaceRect;
    private Size currentSurfaceSize;
    private Rect framingRect = null;
    private Rect previewFramingRect = null;
    private Size framingRectSize = null;
    private double marginFraction = 0.1;
    private PreviewScalingStrategy previewScalingStrategy = null;
    private boolean torchOn = false;
    private final SurfaceHolder.Callback surfaceCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder holder) {
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            CameraPreview.this.currentSurfaceSize = null;
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (holder == null) {
                Log.e((String)TAG, (String)"*** WARNING *** surfaceChanged() gave us a null surface!");
                return;
            }
            CameraPreview.this.currentSurfaceSize = new Size(width, height);
            CameraPreview.this.startPreviewIfReady();
        }
    };
    private final Handler.Callback stateCallback = new Handler.Callback(){

        public boolean handleMessage(Message message) {
            if (message.what == R.id.zxing_prewiew_size_ready) {
                CameraPreview.this.previewSized((Size)message.obj);
                return true;
            }
            if (message.what == R.id.zxing_camera_error) {
                Exception error = (Exception)message.obj;
                if (CameraPreview.this.isActive()) {
                    CameraPreview.this.pause();
                    CameraPreview.this.fireState.cameraError(error);
                }
            } else if (message.what == R.id.zxing_camera_closed) {
                CameraPreview.this.fireState.cameraClosed();
            }
            return false;
        }
    };
    private RotationCallback rotationCallback = new RotationCallback(){

        @Override
        public void onRotationChanged(int rotation) {
            CameraPreview.this.stateHandler.postDelayed(() -> CameraPreview.this.rotationChanged(), 250L);
        }
    };
    private final StateListener fireState = new StateListener(){

        @Override
        public void previewSized() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.previewSized();
            }
        }

        @Override
        public void previewStarted() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.previewStarted();
            }
        }

        @Override
        public void previewStopped() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.previewStopped();
            }
        }

        @Override
        public void cameraError(Exception error) {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.cameraError(error);
            }
        }

        @Override
        public void cameraClosed() {
            for (StateListener listener : CameraPreview.this.stateListeners) {
                listener.cameraClosed();
            }
        }
    };

    @TargetApi(value=14)
    private TextureView.SurfaceTextureListener surfaceTextureListener() {
        return new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                this.onSurfaceTextureSizeChanged(surface, width, height);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                CameraPreview.this.currentSurfaceSize = new Size(width, height);
                CameraPreview.this.startPreviewIfReady();
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        };
    }

    public CameraPreview(Context context) {
        super(context);
        this.initialize(context, null, 0, 0);
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs, 0, 0);
    }

    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs, defStyleAttr, 0);
    }

    private void initialize(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.getBackground() == null) {
            this.setBackgroundColor(-16777216);
        }
        this.initializeAttributes(attrs);
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.stateHandler = new Handler(this.stateCallback);
        this.rotationListener = new RotationListener();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setupSurfaceView();
    }

    protected void initializeAttributes(AttributeSet attrs) {
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attrs, R.styleable.zxing_camera_preview);
        int framingRectWidth = (int)styledAttributes.getDimension(R.styleable.zxing_camera_preview_zxing_framing_rect_width, -1.0f);
        int framingRectHeight = (int)styledAttributes.getDimension(R.styleable.zxing_camera_preview_zxing_framing_rect_height, -1.0f);
        if (framingRectWidth > 0 && framingRectHeight > 0) {
            this.framingRectSize = new Size(framingRectWidth, framingRectHeight);
        }
        this.useTextureView = styledAttributes.getBoolean(R.styleable.zxing_camera_preview_zxing_use_texture_view, true);
        int scalingStrategyNumber = styledAttributes.getInteger(R.styleable.zxing_camera_preview_zxing_preview_scaling_strategy, -1);
        if (scalingStrategyNumber == 1) {
            this.previewScalingStrategy = new CenterCropStrategy();
        } else if (scalingStrategyNumber == 2) {
            this.previewScalingStrategy = new FitCenterStrategy();
        } else if (scalingStrategyNumber == 3) {
            this.previewScalingStrategy = new FitXYStrategy();
        }
        styledAttributes.recycle();
    }

    private void rotationChanged() {
        if (this.isActive() && this.getDisplayRotation() != this.openedOrientation) {
            this.pause();
            this.resume();
        }
    }

    private void setupSurfaceView() {
        if (this.useTextureView) {
            this.textureView = new TextureView(this.getContext());
            this.textureView.setSurfaceTextureListener(this.surfaceTextureListener());
            this.addView((View)this.textureView);
        } else {
            this.surfaceView = new SurfaceView(this.getContext());
            this.surfaceView.getHolder().addCallback(this.surfaceCallback);
            this.addView((View)this.surfaceView);
        }
    }

    public void addStateListener(StateListener listener) {
        this.stateListeners.add(listener);
    }

    private void calculateFrames() {
        if (this.containerSize == null || this.previewSize == null || this.displayConfiguration == null) {
            this.previewFramingRect = null;
            this.framingRect = null;
            this.surfaceRect = null;
            throw new IllegalStateException("containerSize or previewSize is not set yet");
        }
        int previewWidth = this.previewSize.width;
        int previewHeight = this.previewSize.height;
        int width = this.containerSize.width;
        int height = this.containerSize.height;
        Rect scaledPreview = this.displayConfiguration.scalePreview(this.previewSize);
        if (scaledPreview.width() <= 0 || scaledPreview.height() <= 0) {
            return;
        }
        this.surfaceRect = scaledPreview;
        Rect container = new Rect(0, 0, width, height);
        this.framingRect = this.calculateFramingRect(container, this.surfaceRect);
        Rect frameInPreview = new Rect(this.framingRect);
        frameInPreview.offset(-this.surfaceRect.left, -this.surfaceRect.top);
        this.previewFramingRect = new Rect(frameInPreview.left * previewWidth / this.surfaceRect.width(), frameInPreview.top * previewHeight / this.surfaceRect.height(), frameInPreview.right * previewWidth / this.surfaceRect.width(), frameInPreview.bottom * previewHeight / this.surfaceRect.height());
        if (this.previewFramingRect == null || this.previewFramingRect.width() <= 0 || this.previewFramingRect.height() <= 0) {
            this.previewFramingRect = null;
            this.framingRect = null;
            Log.w((String)TAG, (String)"Preview frame is too small");
        } else {
            this.fireState.previewSized();
        }
    }

    public void setTorch(boolean on) {
        this.torchOn = on;
        if (this.cameraInstance != null) {
            this.cameraInstance.setTorch(on);
        }
    }

    public void changeCameraParameters(CameraParametersCallback callback) {
        if (this.cameraInstance != null) {
            this.cameraInstance.changeCameraParameters(callback);
        }
    }

    private void containerSized(Size containerSize) {
        this.containerSize = containerSize;
        if (this.cameraInstance != null && this.cameraInstance.getDisplayConfiguration() == null) {
            this.displayConfiguration = new DisplayConfiguration(this.getDisplayRotation(), containerSize);
            this.displayConfiguration.setPreviewScalingStrategy(this.getPreviewScalingStrategy());
            this.cameraInstance.setDisplayConfiguration(this.displayConfiguration);
            this.cameraInstance.configureCamera();
            if (this.torchOn) {
                this.cameraInstance.setTorch(this.torchOn);
            }
        }
    }

    public void setPreviewScalingStrategy(PreviewScalingStrategy previewScalingStrategy) {
        this.previewScalingStrategy = previewScalingStrategy;
    }

    public PreviewScalingStrategy getPreviewScalingStrategy() {
        if (this.previewScalingStrategy != null) {
            return this.previewScalingStrategy;
        }
        if (this.textureView != null) {
            return new CenterCropStrategy();
        }
        return new FitCenterStrategy();
    }

    private void previewSized(Size size) {
        this.previewSize = size;
        if (this.containerSize != null) {
            this.calculateFrames();
            this.requestLayout();
            this.startPreviewIfReady();
        }
    }

    protected Matrix calculateTextureTransform(Size textureSize, Size previewSize) {
        float scaleY;
        float scaleX;
        float ratioTexture = (float)textureSize.width / (float)textureSize.height;
        float ratioPreview = (float)previewSize.width / (float)previewSize.height;
        if (ratioTexture < ratioPreview) {
            scaleX = ratioPreview / ratioTexture;
            scaleY = 1.0f;
        } else {
            scaleX = 1.0f;
            scaleY = ratioTexture / ratioPreview;
        }
        Matrix matrix = new Matrix();
        matrix.setScale(scaleX, scaleY);
        float scaledWidth = (float)textureSize.width * scaleX;
        float scaledHeight = (float)textureSize.height * scaleY;
        float dx = ((float)textureSize.width - scaledWidth) / 2.0f;
        float dy = ((float)textureSize.height - scaledHeight) / 2.0f;
        matrix.postTranslate(dx, dy);
        return matrix;
    }

    private void startPreviewIfReady() {
        if (this.currentSurfaceSize != null && this.previewSize != null && this.surfaceRect != null) {
            if (this.surfaceView != null && this.currentSurfaceSize.equals(new Size(this.surfaceRect.width(), this.surfaceRect.height()))) {
                this.startCameraPreview(new CameraSurface(this.surfaceView.getHolder()));
            } else if (this.textureView != null && this.textureView.getSurfaceTexture() != null) {
                if (this.previewSize != null) {
                    Matrix transform = this.calculateTextureTransform(new Size(this.textureView.getWidth(), this.textureView.getHeight()), this.previewSize);
                    this.textureView.setTransform(transform);
                }
                this.startCameraPreview(new CameraSurface(this.textureView.getSurfaceTexture()));
            }
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.containerSized(new Size(r - l, b - t));
        if (this.surfaceView != null) {
            if (this.surfaceRect == null) {
                this.surfaceView.layout(0, 0, this.getWidth(), this.getHeight());
            } else {
                this.surfaceView.layout(this.surfaceRect.left, this.surfaceRect.top, this.surfaceRect.right, this.surfaceRect.bottom);
            }
        } else if (this.textureView != null) {
            this.textureView.layout(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public Rect getFramingRect() {
        return this.framingRect;
    }

    public Rect getPreviewFramingRect() {
        return this.previewFramingRect;
    }

    public Size getPreviewSize() {
        return this.previewSize;
    }

    public CameraSettings getCameraSettings() {
        return this.cameraSettings;
    }

    public void setCameraSettings(CameraSettings cameraSettings) {
        this.cameraSettings = cameraSettings;
    }

    public void resume() {
        Util.validateMainThread();
        Log.d((String)TAG, (String)"resume()");
        this.initCamera();
        if (this.currentSurfaceSize != null) {
            this.startPreviewIfReady();
        } else if (this.surfaceView != null) {
            this.surfaceView.getHolder().addCallback(this.surfaceCallback);
        } else if (this.textureView != null) {
            if (this.textureView.isAvailable()) {
                this.surfaceTextureListener().onSurfaceTextureAvailable(this.textureView.getSurfaceTexture(), this.textureView.getWidth(), this.textureView.getHeight());
            } else {
                this.textureView.setSurfaceTextureListener(this.surfaceTextureListener());
            }
        }
        this.requestLayout();
        this.rotationListener.listen(this.getContext(), this.rotationCallback);
    }

    public void pause() {
        Util.validateMainThread();
        Log.d((String)TAG, (String)"pause()");
        this.openedOrientation = -1;
        if (this.cameraInstance != null) {
            this.cameraInstance.close();
            this.cameraInstance = null;
            this.previewActive = false;
        } else {
            this.stateHandler.sendEmptyMessage(R.id.zxing_camera_closed);
        }
        if (this.currentSurfaceSize == null && this.surfaceView != null) {
            SurfaceHolder surfaceHolder = this.surfaceView.getHolder();
            surfaceHolder.removeCallback(this.surfaceCallback);
        }
        if (this.currentSurfaceSize == null && this.textureView != null) {
            this.textureView.setSurfaceTextureListener(null);
        }
        this.containerSize = null;
        this.previewSize = null;
        this.previewFramingRect = null;
        this.rotationListener.stop();
        this.fireState.previewStopped();
    }

    public void pauseAndWait() {
        CameraInstance instance = this.getCameraInstance();
        this.pause();
        long startTime = System.nanoTime();
        while (instance != null && !instance.isCameraClosed() && System.nanoTime() - startTime <= 2000000000L) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public Size getFramingRectSize() {
        return this.framingRectSize;
    }

    public void setFramingRectSize(Size framingRectSize) {
        this.framingRectSize = framingRectSize;
    }

    public double getMarginFraction() {
        return this.marginFraction;
    }

    public void setMarginFraction(double marginFraction) {
        if (marginFraction >= 0.5) {
            throw new IllegalArgumentException("The margin fraction must be less than 0.5");
        }
        this.marginFraction = marginFraction;
    }

    public boolean isUseTextureView() {
        return this.useTextureView;
    }

    public void setUseTextureView(boolean useTextureView) {
        this.useTextureView = useTextureView;
    }

    protected boolean isActive() {
        return this.cameraInstance != null;
    }

    private int getDisplayRotation() {
        return this.windowManager.getDefaultDisplay().getRotation();
    }

    private void initCamera() {
        if (this.cameraInstance != null) {
            Log.w((String)TAG, (String)"initCamera called twice");
            return;
        }
        this.cameraInstance = this.createCameraInstance();
        this.cameraInstance.setReadyHandler(this.stateHandler);
        this.cameraInstance.open();
        this.openedOrientation = this.getDisplayRotation();
    }

    protected CameraInstance createCameraInstance() {
        CameraInstance cameraInstance = new CameraInstance(this.getContext());
        cameraInstance.setCameraSettings(this.cameraSettings);
        return cameraInstance;
    }

    private void startCameraPreview(CameraSurface surface) {
        if (!this.previewActive && this.cameraInstance != null) {
            Log.i((String)TAG, (String)"Starting preview");
            this.cameraInstance.setSurface(surface);
            this.cameraInstance.startPreview();
            this.previewActive = true;
            this.previewStarted();
            this.fireState.previewStarted();
        }
    }

    protected void previewStarted() {
    }

    public CameraInstance getCameraInstance() {
        return this.cameraInstance;
    }

    public boolean isPreviewActive() {
        return this.previewActive;
    }

    protected Rect calculateFramingRect(Rect container, Rect surface) {
        Rect intersection = new Rect(container);
        boolean intersects = intersection.intersect(surface);
        if (this.framingRectSize != null) {
            int horizontalMargin = Math.max(0, (intersection.width() - this.framingRectSize.width) / 2);
            int verticalMargin = Math.max(0, (intersection.height() - this.framingRectSize.height) / 2);
            intersection.inset(horizontalMargin, verticalMargin);
            return intersection;
        }
        int margin = (int)Math.min((double)intersection.width() * this.marginFraction, (double)intersection.height() * this.marginFraction);
        intersection.inset(margin, margin);
        if (intersection.height() > intersection.width()) {
            intersection.inset(0, (intersection.height() - intersection.width()) / 2);
        }
        return intersection;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle myState = new Bundle();
        myState.putParcelable("super", superState);
        myState.putBoolean("torch", this.torchOn);
        return myState;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof Bundle)) {
            super.onRestoreInstanceState(state);
            return;
        }
        Bundle myState = (Bundle)state;
        Parcelable superState = myState.getParcelable("super");
        super.onRestoreInstanceState(superState);
        boolean torch = myState.getBoolean("torch");
        this.setTorch(torch);
    }

    public boolean isCameraClosed() {
        return this.cameraInstance == null || this.cameraInstance.isCameraClosed();
    }

    public static interface StateListener {
        public void previewSized();

        public void previewStarted();

        public void previewStopped();

        public void cameraError(Exception var1);

        public void cameraClosed();
    }
}

