/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.junit;

import com.karuslabs.elementary.junit.DefaultGeneration;
import com.karuslabs.elementary.junit.annotations.Generation;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;

class Generations {
    static final String TEMP_DIRECTORY = "TEMP_DIRECTORY";
    static final String GENERATED_CLASSES = "GENERATED_CLASSES";
    static final String GENERATED_SOURCES = "GENERATED_SOURCES";

    Generations() {
    }

    static Map.Entry<File, File> initialize(ExtensionContext context) {
        try {
            Class type = context.getRequiredTestClass();
            Generation output = type.getAnnotation(Generation.class) == null ? new DefaultGeneration() : type.getAnnotation(Generation.class);
            Path directory = Files.createTempDirectory(type.getCanonicalName(), new FileAttribute[0]);
            File classes = output.classes().equals("${DEFAULT_OUTPUT}") ? directory.resolve("generated-classes").toFile() : new File(output.classes());
            classes.mkdirs();
            File sources = output.sources().equals("${DEFAULT_OUTPUT}") ? directory.resolve("generated-sources").toFile() : new File(output.sources());
            sources.mkdirs();
            ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{Generations.class});
            context.getStore(namespace).put((Object)TEMP_DIRECTORY, (Object)directory.toFile());
            context.getStore(namespace).put((Object)GENERATED_CLASSES, (Object)classes);
            context.getStore(namespace).put((Object)GENERATED_SOURCES, (Object)sources);
            return new AbstractMap.SimpleEntry<File, File>(classes, sources);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static void teardown(ExtensionContext context) {
        Class type = context.getRequiredTestClass();
        Generation output = type.getAnnotation(Generation.class) == null ? new DefaultGeneration() : type.getAnnotation(Generation.class);
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{Generations.class});
        File classes = (File)context.getStore(namespace).remove((Object)GENERATED_CLASSES, File.class);
        File sources = (File)context.getStore(namespace).remove((Object)GENERATED_SOURCES, File.class);
        File directory = (File)context.getStore(namespace).remove((Object)TEMP_DIRECTORY, File.class);
        if (output.retain()) {
            return;
        }
        Generations.delete(classes);
        Generations.delete(sources);
        Generations.delete(directory);
    }

    static void delete(@Nullable File file) {
        if (file == null) {
            return;
        }
        try (Stream<Path> f = Files.walk(file.toPath(), new FileVisitOption[0]);){
            f.map(Path::toFile).sorted(Comparator.reverseOrder()).forEach(File::delete);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

