/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.snippet;

import com.karuslabs.utilitary.snippet.AnnotationsSnippet;
import com.karuslabs.utilitary.snippet.Line;
import com.karuslabs.utilitary.snippet.Part;
import com.karuslabs.utilitary.snippet.Snippet;
import com.karuslabs.utilitary.snippet.VariableLine;
import com.karuslabs.utilitary.type.TypePrinter;
import java.util.TreeMap;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

public class MethodSnippet
extends Snippet {
    public final AnnotationsSnippet annotations;
    public final Part<Modifier, Line> modifiers;
    public final Part<TypeParameterElement, Line> typeParameters;
    public final Line type;
    public final Line name;
    public final Part<VariableElement, VariableLine> parameters;
    public final Part<TypeMirror, Line> exceptions;

    public static MethodSnippet of(ExecutableElement method, int column) {
        TreeMap<Integer, Line> lines = new TreeMap<Integer, Line>();
        AnnotationsSnippet annotations = AnnotationsSnippet.of(method.getAnnotationMirrors(), column);
        lines.putAll(annotations.lines);
        StringBuilder builder = new StringBuilder();
        column = annotations.last + 1;
        Part<Modifier, Line> modifiers = Part.modifiers(method.getModifiers(), column, builder.length());
        builder.append(modifiers);
        Part<TypeParameterElement, Line> typeParameters = Part.typeParameters(method.getTypeParameters(), column, builder.length());
        builder.append(typeParameters).append(" ");
        Line type = new Line(TypePrinter.simple(method.getReturnType()), column, builder.length());
        builder.append(type).append(" ");
        Line name = new Line(method.getSimpleName().toString(), column, builder.length());
        builder.append(name);
        Part<VariableElement, VariableLine> parameters = Part.parameters(method.getParameters(), column, builder.length());
        builder.append(parameters);
        Part<TypeMirror, Line> exceptions = Part.exceptions(method.getThrownTypes(), column, builder.length());
        builder.append(exceptions);
        lines.put(column, new Line(builder.toString(), column, 0));
        return new MethodSnippet(annotations, modifiers, typeParameters, type, name, parameters, exceptions, lines);
    }

    MethodSnippet(AnnotationsSnippet annotations, Part<Modifier, Line> modifiers, Part<TypeParameterElement, Line> typeParameters, Line type, Line name, Part<VariableElement, VariableLine> parameters, Part<TypeMirror, Line> exceptions, TreeMap<Integer, Line> lines) {
        super(lines);
        this.annotations = annotations;
        this.modifiers = modifiers;
        this.typeParameters = typeParameters;
        this.type = type;
        this.name = name;
        this.parameters = parameters;
        this.exceptions = exceptions;
    }
}

