/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.bg;

import com.kennycason.kumo.bg.Background;
import com.kennycason.kumo.collide.RectanglePixelCollidable;
import com.kennycason.kumo.image.CollisionRaster;
import java.awt.Dimension;
import java.awt.Point;

public class CircleBackground
implements Background {
    private final int radius;
    private final Point position;

    public CircleBackground(int radius) {
        this.radius = radius;
        this.position = new Point(0, 0);
    }

    @Override
    public void mask(RectanglePixelCollidable background) {
        Dimension dimensionOfBackground = background.getDimension();
        CollisionRaster rasterOfBackground = background.getCollisionRaster();
        for (int y = 0; y < dimensionOfBackground.height; ++y) {
            for (int x = 0; x < dimensionOfBackground.width; ++x) {
                if (this.inCircle(x, y)) continue;
                rasterOfBackground.setPixelIsNotTransparent(this.position.x + x, this.position.y + y);
            }
        }
    }

    private boolean inCircle(int x, int y) {
        int centerX = this.position.x + x - this.radius;
        int centerY = this.position.y + y - this.radius;
        return centerX * centerX + centerY * centerY <= this.radius * this.radius;
    }
}

