/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.font;

import com.kennycason.kumo.exception.KumoException;
import com.kennycason.kumo.font.FontWeight;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class KumoFont {
    private static final int DEFAULT_WEIGHT = 10;
    private final Font font;

    public KumoFont(String type, FontWeight weight) {
        this.font = new Font(type, weight.getWeight(), 10);
    }

    public KumoFont(Font font) {
        this.font = font;
    }

    public KumoFont(File file) {
        this(KumoFont.buildAndRegisterFont(file));
    }

    public KumoFont(InputStream inputStream) {
        this(KumoFont.buildAndRegisterFont(inputStream));
    }

    private static Font buildAndRegisterFont(File file) {
        try {
            Font font = Font.createFont(0, file);
            KumoFont.registerFont(font);
            return font;
        }
        catch (FontFormatException | IOException e) {
            throw new KumoException(e.getMessage(), e);
        }
    }

    private static Font buildAndRegisterFont(InputStream inputStream) {
        try {
            Font font = Font.createFont(0, inputStream);
            KumoFont.registerFont(font);
            return font;
        }
        catch (FontFormatException | IOException e) {
            throw new KumoException(e.getMessage(), e);
        }
    }

    private static void registerFont(Font font) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        graphicsEnvironment.registerFont(font);
    }

    public Font getFont() {
        return this.font;
    }
}

