/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.image;

import com.kennycason.kumo.Word;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ImageRotation {
    private ImageRotation() {
    }

    public static BufferedImage rotate90(BufferedImage bufferedImage) {
        return ImageRotation.rotate(bufferedImage, Math.toRadians(90.0));
    }

    public static BufferedImage rotateMinus90(BufferedImage bufferedImage) {
        return ImageRotation.rotate(bufferedImage, Math.toRadians(-90.0));
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, double theta) {
        if (theta == 0.0) {
            return bufferedImage;
        }
        double sin = Math.abs(Math.sin(theta));
        double cos = Math.abs(Math.cos(theta));
        int weight = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int newWeight = (int)Math.floor((double)weight * cos + (double)height * sin);
        int newHeight = (int)Math.floor((double)height * cos + (double)weight * sin);
        BufferedImage result = new BufferedImage(newWeight, newHeight, bufferedImage.getType());
        Graphics2D graphics = result.createGraphics();
        graphics.setRenderingHints(Word.getRenderingHints());
        graphics.translate((newWeight - weight) / 2, (newHeight - height) / 2);
        graphics.rotate(theta, weight / 2, height / 2);
        graphics.drawRenderedImage(bufferedImage, null);
        graphics.dispose();
        return result;
    }
}

