/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.palette;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ColorPalette {
    private static final Random RANDOM = new Random();
    private final List<Color> colors;
    private int next;

    public ColorPalette(Color ... colors) {
        this.colors = new ArrayList<Color>();
        for (Color color : colors) {
            this.colors.add(color);
        }
    }

    public ColorPalette(int ... colors) {
        this.colors = new ArrayList<Color>();
        for (int color : colors) {
            this.colors.add(new Color(color));
        }
    }

    public ColorPalette(List<Color> colors) {
        this.colors = colors;
    }

    public Color next() {
        return this.colors.get(this.next++ % this.colors.size());
    }

    public Color randomNext() {
        return this.colors.get(RANDOM.nextInt(this.colors.size()));
    }

    public List<Color> getColors() {
        return this.colors;
    }
}

