/*
 * Decompiled with CFR 0.152.
 */
package com.kennycason.kumo.palette;

import com.kennycason.kumo.palette.ColorPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class LinearGradientColorPalette
extends ColorPalette {
    public LinearGradientColorPalette(Color color1, Color color2, int gradientSteps) {
        super(LinearGradientColorPalette.createLinearGradient(color1, color2, gradientSteps));
    }

    public LinearGradientColorPalette(Color color1, Color color2, Color color3, int gradientStepsC1AndC2, int gradientStepsC2AndC3) {
        super(LinearGradientColorPalette.createTwoLinearGradients(color1, color2, color3, gradientStepsC1AndC2, gradientStepsC2AndC3));
    }

    private static List<Color> createTwoLinearGradients(Color color1, Color color2, Color color3, int gradientStepsC1AndC2, int gradientStepsC2AndC3) {
        ArrayList<Color> colors = new ArrayList<Color>();
        List<Color> gradient1 = LinearGradientColorPalette.createLinearGradient(color1, color2, gradientStepsC1AndC2);
        List<Color> gradient2 = LinearGradientColorPalette.createLinearGradient(color2, color3, gradientStepsC2AndC3);
        colors.addAll(gradient1);
        colors.addAll(gradient2.subList(1, gradient2.size()));
        return colors;
    }

    private static List<Color> createLinearGradient(Color color1, Color color2, int gradientSteps) {
        ArrayList<Color> colors = new ArrayList<Color>(gradientSteps + 1);
        colors.add(color1);
        for (int i = 1; i < gradientSteps; ++i) {
            float ratio = (float)i / (float)gradientSteps;
            float red = (float)color2.getRed() * ratio + (float)color1.getRed() * (1.0f - ratio);
            float green = (float)color2.getGreen() * ratio + (float)color1.getGreen() * (1.0f - ratio);
            float blue = (float)color2.getBlue() * ratio + (float)color1.getBlue() * (1.0f - ratio);
            colors.add(new Color(Math.round(red), Math.round(green), Math.round(blue)));
        }
        colors.add(color2);
        return colors;
    }
}

