/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.apache;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import kong.unirest.Config;
import kong.unirest.UnirestConfigException;
import unirest.shaded.org.apache.http.config.Registry;
import unirest.shaded.org.apache.http.config.RegistryBuilder;
import unirest.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import unirest.shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import unirest.shaded.org.apache.http.conn.ssl.NoopHostnameVerifier;
import unirest.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import unirest.shaded.org.apache.http.impl.client.HttpClientBuilder;
import unirest.shaded.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import unirest.shaded.org.apache.http.ssl.SSLContextBuilder;
import unirest.shaded.org.apache.http.ssl.SSLContexts;

class SecurityConfig {
    private final Config config;
    private SSLContext sslContext;
    private SSLConnectionSocketFactory sslSocketFactory;

    public SecurityConfig(Config config) {
        this.config = config;
    }

    public PoolingHttpClientConnectionManager createManager() {
        PoolingHttpClientConnectionManager manager = this.buildSocketFactory().map(PoolingHttpClientConnectionManager::new).orElseGet(PoolingHttpClientConnectionManager::new);
        manager.setMaxTotal(this.config.getMaxConnections());
        manager.setDefaultMaxPerRoute(this.config.getMaxPerRoutes());
        return manager;
    }

    private Optional<Registry<ConnectionSocketFactory>> buildSocketFactory() {
        try {
            if (!this.config.isVerifySsl()) {
                return Optional.of(this.createDisabledSSLContext());
            }
            if (this.config.getKeystore() != null) {
                return Optional.of(this.createCustomSslContext());
            }
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
        return Optional.empty();
    }

    private Registry<ConnectionSocketFactory> createCustomSslContext() {
        SSLConnectionSocketFactory socketFactory = this.getSocketFactory();
        return RegistryBuilder.create().register("https", socketFactory).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.INSTANCE)).build();
    }

    private SSLConnectionSocketFactory getSocketFactory() {
        if (this.sslSocketFactory == null) {
            this.sslSocketFactory = new SSLConnectionSocketFactory(this.createSslContext(), (HostnameVerifier)new NoopHostnameVerifier());
        }
        return this.sslSocketFactory;
    }

    private Registry<ConnectionSocketFactory> createDisabledSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        return RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE))).build();
    }

    private SSLContext createSslContext() {
        if (this.sslContext == null) {
            try {
                char[] pass = Optional.ofNullable(this.config.getKeyStorePassword()).map(String::toCharArray).orElse(null);
                this.sslContext = SSLContexts.custom().loadKeyMaterial(this.config.getKeystore(), pass).build();
            }
            catch (Exception e) {
                throw new UnirestConfigException(e);
            }
        }
        return this.sslContext;
    }

    public void configureSecurity(HttpClientBuilder cb) {
        if (this.config.getKeystore() != null) {
            cb.setSSLContext(this.createSslContext());
            cb.setSSLSocketFactory(this.getSocketFactory());
        }
        if (!this.config.isVerifySsl()) {
            this.disableSsl(cb);
        }
    }

    private void disableSsl(HttpClientBuilder cb) {
        try {
            cb.setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE);
            cb.setSSLContext(new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build());
        }
        catch (Exception e) {
            throw new UnirestConfigException(e);
        }
    }
}

