/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.spring;

import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Annotation;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import aQute.bnd.osgi.WriteResource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.io.IO;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SpringDependencyAnalyzerPlugin
implements AnalyzerPlugin {
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        String property = analyzer.getProperty("-liferay-spring-dependency");
        Parameters parameters = analyzer.parseHeader(property);
        if (parameters.isEmpty()) {
            return false;
        }
        Jar jar = analyzer.getJar();
        Collection classes = analyzer.getClasses(new String[0]);
        TreeSet<String> serviceReferences = new TreeSet<String>();
        for (String key : parameters.keySet()) {
            ServiceReferenceCollector serviceReferenceCollector = new ServiceReferenceCollector(key);
            for (Clazz clazz : classes) {
                clazz.parseClassFileWithCollector((ClassDataCollector)serviceReferenceCollector);
            }
            serviceReferences.addAll(serviceReferenceCollector.getServiceReferences());
        }
        String releaseInfo = this.getReleaseInfo(analyzer);
        if (!releaseInfo.equals("")) {
            serviceReferences.add(releaseInfo);
        }
        jar.putResource("OSGI-INF/context/context.dependencies", (Resource)new ContextDependencyWriter(analyzer, serviceReferences));
        return false;
    }

    protected String getReleaseInfo(Analyzer analyzer) {
        String property = analyzer.getProperty("Liferay-Require-SchemaVersion");
        if (property == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(6);
        sb.append("com.liferay.portal.kernel.model.Release ");
        sb.append("(&(release.bundle.symbolic.name=");
        Map.Entry entry = analyzer.getBundleSymbolicName();
        sb.append((String)entry.getKey());
        sb.append(")(release.schema.version=");
        sb.append(property);
        sb.append("))");
        return sb.toString();
    }

    private static class ServiceReferenceCollector
    extends ClassDataCollector {
        private final String _annotationFQN;
        private Clazz.FieldDef _fieldDef;
        private final Set<String> _serviceReferences = new HashSet<String>();

        public ServiceReferenceCollector(String annotationFQN) {
            this._annotationFQN = annotationFQN;
        }

        public void annotation(Annotation annotation) throws Exception {
            Descriptors.TypeRef typeRef = annotation.getName();
            String fqn = typeRef.getFQN();
            if (!this._annotationFQN.equals(fqn)) {
                return;
            }
            Descriptors.Descriptor descriptor = this._fieldDef.getDescriptor();
            typeRef = descriptor.getType();
            fqn = typeRef.getFQN();
            Object filterString = annotation.get("filterString");
            if (filterString != null) {
                fqn = fqn + " " + filterString;
            }
            this._serviceReferences.add(fqn);
        }

        public void field(Clazz.FieldDef fieldDef) {
            this._fieldDef = fieldDef;
        }

        public Set<String> getServiceReferences() {
            return this._serviceReferences;
        }
    }

    private static class ContextDependencyWriter
    extends WriteResource {
        private final Resource _resource;
        private final Set<String> _serviceReferences;

        public ContextDependencyWriter(Analyzer analyzer, Set<String> serviceReferences) {
            this._serviceReferences = serviceReferences;
            Jar jar = analyzer.getJar();
            this._resource = jar.getResource("META-INF/spring/context.dependencies");
        }

        public long lastModified() {
            return 0L;
        }

        public void write(OutputStream outputStream) throws Exception {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            String contextDependencies = "";
            if (this._resource != null) {
                contextDependencies = IO.collect((InputStream)this._resource.openInputStream(), (String)"UTF-8");
            }
            if (!contextDependencies.equals("")) {
                printWriter.println(contextDependencies);
            }
            for (String serviceReference : this._serviceReferences) {
                printWriter.println(serviceReference);
            }
            printWriter.flush();
        }
    }
}

