/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.kernel.store;

import com.liferay.document.library.kernel.store.DLStore;
import com.liferay.document.library.kernel.store.DLStoreRequest;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.module.service.Snapshot;
import java.io.File;
import java.io.InputStream;

public class DLStoreUtil {
    private static DLStore _dlStore;
    private static volatile Snapshot<DLStore> _storeSnapshot;

    public static void addFile(DLStoreRequest dlStoreRequest, byte[] bytes) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.addFile(dlStoreRequest, bytes);
    }

    public static void addFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.addFile(dlStoreRequest, file);
    }

    public static void addFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.addFile(dlStoreRequest, inputStream);
    }

    public static void copyFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.copyFileVersion(companyId, repositoryId, fileName, fromVersionLabel, toVersionLabel);
    }

    public static void deleteDirectory(long companyId, long repositoryId, String dirName) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.deleteDirectory(companyId, repositoryId, dirName);
    }

    public static void deleteFile(long companyId, long repositoryId, String fileName) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.deleteFile(companyId, repositoryId, fileName);
    }

    public static void deleteFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.deleteFile(companyId, repositoryId, fileName, versionLabel);
    }

    public static InputStream getFileAsStream(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        return dlStore.getFileAsStream(companyId, repositoryId, fileName, versionLabel);
    }

    public static String[] getFileNames(long companyId, long repositoryId, String dirName) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        return dlStore.getFileNames(companyId, repositoryId, dirName);
    }

    public static long getFileSize(long companyId, long repositoryId, String fileName) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        return dlStore.getFileSize(companyId, repositoryId, fileName);
    }

    public static DLStore getStore() {
        return DLStoreUtil._getDLStore();
    }

    public static boolean hasFile(long companyId, long repositoryId, String fileName, String versionLabel) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        return dlStore.hasFile(companyId, repositoryId, fileName, versionLabel);
    }

    public static void updateFile(DLStoreRequest dlStoreRequest, File file) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.updateFile(dlStoreRequest, file);
    }

    public static void updateFile(DLStoreRequest dlStoreRequest, InputStream inputStream) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.updateFile(dlStoreRequest, inputStream);
    }

    public static void updateFile(long companyId, long repositoryId, long newRepositoryId, String fileName) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.updateFile(companyId, repositoryId, newRepositoryId, fileName);
    }

    public static void updateFileVersion(long companyId, long repositoryId, String fileName, String fromVersionLabel, String toVersionLabel) throws PortalException {
        DLStore dlStore = DLStoreUtil._getDLStore();
        dlStore.updateFileVersion(companyId, repositoryId, fileName, fromVersionLabel, toVersionLabel);
    }

    public void setDLStore(DLStore dlStore) {
        _dlStore = dlStore;
    }

    private static DLStore _getDLStore() {
        DLStore dlStore = _storeSnapshot.get();
        if (dlStore != null) {
            return dlStore;
        }
        return _dlStore;
    }

    static {
        _storeSnapshot = new Snapshot<DLStore>(DLStoreUtil.class, DLStore.class, null, true);
    }
}

