/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.exportimport.kernel.staging;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.petra.lang.HashUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MergeLayoutPrototypesThreadLocal {
    private static final ThreadLocal<Boolean> _inProgress = new CentralizedThreadLocal(MergeLayoutPrototypesThreadLocal.class + "._inProgress", () -> Boolean.FALSE);
    private static final ThreadLocal<Set<MethodKey>> _mergeComplete = new CentralizedThreadLocal(MergeLayoutPrototypesThreadLocal.class + "._mergeComplete", HashSet::new);
    private static final ThreadLocal<Boolean> _skipMerge = new CentralizedThreadLocal(MergeLayoutPrototypesThreadLocal.class + "._skipMerge", () -> Boolean.FALSE);

    public static void clearMergeComplete() {
        _mergeComplete.remove();
    }

    public static boolean isInProgress() {
        return _inProgress.get();
    }

    public static boolean isMergeComplete(String methodName, Object ... arguments) {
        Set<MethodKey> methodKeys = _mergeComplete.get();
        return methodKeys.contains(new MethodKey(methodName, arguments));
    }

    public static boolean isSkipMerge() {
        return _skipMerge.get();
    }

    public static void setInProgress(boolean inProgress) {
        _inProgress.set(inProgress);
    }

    public static void setMergeComplete(String methodName, Object ... arguments) {
        Set<MethodKey> methodKeys = _mergeComplete.get();
        methodKeys.add(new MethodKey(methodName, arguments));
        MergeLayoutPrototypesThreadLocal.setInProgress(false);
    }

    public static void setSkipMerge(boolean skipMerge) {
        _skipMerge.set(skipMerge);
    }

    private static class MethodKey {
        private final Object[] _arguments;
        private final String _methodName;

        public MethodKey(String methodName, Object[] arguments) {
            this._methodName = methodName;
            this._arguments = arguments;
        }

        public boolean equals(Object object) {
            MethodKey methodKey = (MethodKey)object;
            return Objects.equals(this._methodName, methodKey._methodName) && Arrays.equals(this._arguments, methodKey._arguments);
        }

        public int hashCode() {
            int hashCode = this._methodName.hashCode();
            if (this._arguments != null) {
                for (Object object : this._arguments) {
                    hashCode = object == null ? HashUtil.hash((int)hashCode, (int)0) : HashUtil.hash((int)hashCode, (int)object.hashCode());
                }
            }
            return hashCode;
        }
    }
}

