/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.cache.CacheRegistryItem;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import org.osgi.framework.BundleContext;

public class CacheRegistryUtil {
    private static final Log _log = LogFactoryUtil.getLog(CacheRegistryUtil.class);
    private static volatile boolean _active = true;
    private static final BundleContext _bundleContext = SystemBundleUtil.getBundleContext();
    private static final ServiceTrackerMap<String, CacheRegistryItem> _cacheRegistryItems = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)_bundleContext, CacheRegistryItem.class, null, (serviceReference, emitter) -> {
        CacheRegistryItem cacheRegistryItem = (CacheRegistryItem)_bundleContext.getService(serviceReference);
        emitter.emit((Object)cacheRegistryItem.getRegistryName());
        _bundleContext.ungetService(serviceReference);
    });

    public static void clear() {
        for (CacheRegistryItem cacheRegistryItem : _cacheRegistryItems.values()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Invalidating " + cacheRegistryItem.getRegistryName());
            }
            cacheRegistryItem.invalidate();
        }
    }

    public static void clear(String name) {
        CacheRegistryItem cacheRegistryItem = (CacheRegistryItem)_cacheRegistryItems.getService((Object)name);
        if (cacheRegistryItem == null) {
            _log.error("No cache registry found with name " + name);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug("Invalidating " + name);
            }
            cacheRegistryItem.invalidate();
        }
    }

    public static boolean isActive() {
        return _active;
    }

    public static void setActive(boolean active) {
        _active = active;
        if (!active) {
            CacheRegistryUtil.clear();
        }
    }

    private CacheRegistryUtil() {
    }
}

