/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultNoticeableFuture<T>
extends FutureTask<T>
implements NoticeableFuture<T> {
    private static final Callable<Object> _emptyCallable = new Callable<Object>(){

        @Override
        public Object call() {
            return null;
        }
    };
    private final Set<FutureListener<T>> _futureListeners = new CopyOnWriteArraySet<FutureListener<T>>();

    public DefaultNoticeableFuture() {
        super(_emptyCallable);
    }

    public DefaultNoticeableFuture(Callable<T> callable) {
        super(callable);
    }

    public DefaultNoticeableFuture(Runnable runnable, T result) {
        super(runnable, result);
    }

    @Override
    public boolean addFutureListener(FutureListener<T> futureListener) {
        if (futureListener == null) {
            throw new NullPointerException("Future listener is null");
        }
        if (this._futureListeners.add(futureListener = new OnceFutureListener<T>(futureListener))) {
            if (this.isDone()) {
                futureListener.complete(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFutureListener(FutureListener<T> futureListener) {
        if (futureListener == null) {
            throw new NullPointerException("Future listener is null");
        }
        return this._futureListeners.remove(new OnceFutureListener<T>(futureListener));
    }

    @Override
    public void set(T t) {
        super.set(t);
    }

    @Override
    public void setException(Throwable throwable) {
        super.setException(throwable);
    }

    @Override
    protected void done() {
        for (FutureListener<T> futureListener : this._futureListeners) {
            futureListener.complete(this);
        }
    }

    private static class OnceFutureListener<V>
    implements FutureListener<V> {
        private final FutureListener<V> _futureListener;
        private final AtomicBoolean _ran = new AtomicBoolean();

        public OnceFutureListener(FutureListener<V> futureListener) {
            this._futureListener = futureListener;
        }

        @Override
        public void complete(Future<V> future) {
            if (this._ran.compareAndSet(false, true)) {
                this._futureListener.complete(future);
            }
        }

        public boolean equals(Object object) {
            OnceFutureListener onceFutureListener = (OnceFutureListener)object;
            return this._futureListener.equals(onceFutureListener._futureListener);
        }

        public int hashCode() {
            return this._futureListener.hashCode();
        }
    }
}

