/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.jdbc;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class AutoBatchPreparedStatementUtil {
    private static final int _HIBERNATE_JDBC_BATCH_SIZE = GetterUtil.getInteger(PropsUtil.get("hibernate.jdbc.batch_size"));
    private static final Class<?>[] _INTERFACES = new Class[]{PreparedStatement.class};
    private static final Method _addBatchMethod;
    private static final Method _closeMethod;
    private static final Method _executeBatchMethod;
    private static final Method _getConnectionMethod;
    private static final Snapshot<PortalExecutorManager> _portalExecutorManagerSnapshot;

    public static PreparedStatement autoBatch(Connection connection, String sql) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.supportsBatchUpdates()) {
            return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new BatchInvocationHandler(connection, sql));
        }
        return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new NoBatchInvocationHandler(connection, sql));
    }

    public static PreparedStatement concurrentAutoBatch(Connection connection, String sql) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData.supportsBatchUpdates()) {
            return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new ConcurrentBatchInvocationHandler(connection, sql));
        }
        return (PreparedStatement)ProxyUtil.newProxyInstance(ClassLoader.getSystemClassLoader(), _INTERFACES, new ConcurrentNoBatchInvocationHandler(connection, sql));
    }

    static /* synthetic */ Snapshot access$500() {
        return _portalExecutorManagerSnapshot;
    }

    static {
        _portalExecutorManagerSnapshot = new Snapshot<PortalExecutorManager>(AutoBatchPreparedStatementUtil.class, PortalExecutorManager.class);
        try {
            _addBatchMethod = PreparedStatement.class.getMethod("addBatch", new Class[0]);
            _closeMethod = PreparedStatement.class.getMethod("close", new Class[0]);
            _executeBatchMethod = PreparedStatement.class.getMethod("executeBatch", new Class[0]);
            _getConnectionMethod = PreparedStatement.class.getMethod("getConnection", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ExceptionInInitializerError(noSuchMethodException);
        }
    }

    private static abstract class PreparedStatementInvocationHandler
    implements InvocationHandler {
        protected PreparedStatement preparedStatement;
        private final Connection _connection;
        private final String _sql;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.equals(_getConnectionMethod)) {
                return this._connection;
            }
            if (method.equals(_closeMethod)) {
                this.doClose();
                return null;
            }
            if (method.equals(_addBatchMethod)) {
                this.doAddBatch();
                return null;
            }
            if (method.equals(_executeBatchMethod)) {
                return this.doExecuteBatch();
            }
            return method.invoke((Object)this.getPreparedStatement(), args);
        }

        protected PreparedStatementInvocationHandler(Connection connection, String sql) {
            this._connection = connection;
            this._sql = sql;
        }

        protected abstract void doAddBatch() throws SQLException;

        protected abstract void doClose() throws Throwable;

        protected abstract int[] doExecuteBatch() throws SQLException;

        protected PreparedStatement getPreparedStatement() throws SQLException {
            if (this.preparedStatement == null) {
                this.preparedStatement = this._connection.prepareStatement(this._sql);
            }
            return this.preparedStatement;
        }
    }

    private static class NoBatchInvocationHandler
    extends PreparedStatementInvocationHandler {
        @Override
        protected void doAddBatch() throws SQLException {
            PreparedStatement localPreparedStatement = this.getPreparedStatement();
            localPreparedStatement.executeUpdate();
        }

        @Override
        protected void doClose() throws Throwable {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
        }

        @Override
        protected int[] doExecuteBatch() throws SQLException {
            return new int[0];
        }

        private NoBatchInvocationHandler(Connection connection, String sql) {
            super(connection, sql);
        }
    }

    private static class ConcurrentNoBatchInvocationHandler
    extends PreparedStatementInvocationHandler {
        private final Set<Future<Void>> _futures = Collections.newSetFromMap(new ConcurrentHashMap());
        private final PortalExecutorManager _portalExecutorManager = (PortalExecutorManager)AutoBatchPreparedStatementUtil.access$500().get();

        @Override
        protected void doAddBatch() throws SQLException {
            this.executeAsync((UnsafeConsumer<PreparedStatement, SQLException>)((UnsafeConsumer)PreparedStatement::executeUpdate));
        }

        @Override
        protected void doClose() throws Throwable {
            Throwable throwable1 = null;
            for (Future<Void> future : this._futures) {
                try {
                    future.get();
                }
                catch (Throwable throwable2) {
                    if (throwable2 instanceof ExecutionException) {
                        throwable2 = throwable2.getCause();
                    }
                    if (throwable1 == null) {
                        throwable1 = throwable2;
                        continue;
                    }
                    throwable1.addSuppressed(throwable2);
                }
            }
            if (throwable1 != null) {
                throw throwable1;
            }
        }

        @Override
        protected int[] doExecuteBatch() throws SQLException {
            return new int[0];
        }

        protected void executeAsync(UnsafeConsumer<PreparedStatement, SQLException> actionUnsafeConsumer) throws SQLException {
            NoticeableExecutorService noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(ConcurrentNoBatchInvocationHandler.class.getName());
            PreparedStatement localPreparedStatement = this.getPreparedStatement();
            NoticeableFuture noticeableFuture = noticeableExecutorService.submit(() -> {
                try {
                    actionUnsafeConsumer.accept((Object)localPreparedStatement);
                }
                finally {
                    localPreparedStatement.close();
                }
                return null;
            });
            this._futures.add((Future<Void>)noticeableFuture);
            noticeableFuture.addFutureListener(future -> {
                try {
                    future.get();
                    this._futures.remove(future);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.preparedStatement = null;
        }

        private ConcurrentNoBatchInvocationHandler(Connection connection, String sql) {
            super(connection, sql);
        }
    }

    private static class ConcurrentBatchInvocationHandler
    extends ConcurrentNoBatchInvocationHandler {
        private int _count;

        @Override
        protected void doAddBatch() throws SQLException {
            PreparedStatement localPreparedStatement = this.getPreparedStatement();
            localPreparedStatement.addBatch();
            if (++this._count >= _HIBERNATE_JDBC_BATCH_SIZE) {
                this._count = 0;
                this.executeAsync((UnsafeConsumer<PreparedStatement, SQLException>)((UnsafeConsumer)Statement::executeBatch));
            }
        }

        @Override
        protected int[] doExecuteBatch() throws SQLException {
            if (this._count > 0) {
                this._count = 0;
                this.executeAsync((UnsafeConsumer<PreparedStatement, SQLException>)((UnsafeConsumer)Statement::executeBatch));
            }
            return new int[0];
        }

        private ConcurrentBatchInvocationHandler(Connection connection, String sql) {
            super(connection, sql);
        }
    }

    private static class BatchInvocationHandler
    extends NoBatchInvocationHandler {
        private int _count;

        @Override
        protected void doAddBatch() throws SQLException {
            PreparedStatement localPreparedStatement = this.getPreparedStatement();
            localPreparedStatement.addBatch();
            if (++this._count >= _HIBERNATE_JDBC_BATCH_SIZE) {
                this._count = 0;
                localPreparedStatement.executeBatch();
            }
        }

        @Override
        protected int[] doExecuteBatch() throws SQLException {
            if (this._count > 0) {
                this._count = 0;
                PreparedStatement localPreparedStatement = this.getPreparedStatement();
                return localPreparedStatement.executeBatch();
            }
            return new int[0];
        }

        private BatchInvocationHandler(Connection connection, String sql) {
            super(connection, sql);
        }
    }
}

