/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.util.ProxyFactory;

public class FinderCacheUtil {
    private static final Snapshot<FinderCache> _finderCacheSnapshot = new Snapshot<FinderCache>(FinderCacheUtil.class, FinderCache.class);

    public static void clearCache() {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.clearCache();
    }

    public static void clearCache(Class<?> clazz) {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.clearCache(clazz);
    }

    public static void clearDSLQueryCache(String tableName) {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.clearDSLQueryCache(tableName);
    }

    public static void clearLocalCache() {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.clearLocalCache();
    }

    public static FinderCache getFinderCache() {
        FinderCache finderCache = _finderCacheSnapshot.get();
        if (finderCache == null) {
            return DummyFinderCacheHolder._dummyFinderCache;
        }
        return finderCache;
    }

    public static Object getResult(FinderPath finderPath, Object[] args, BasePersistence<?> basePersistence) {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        return finderCache.getResult(finderPath, args, basePersistence);
    }

    public static void invalidate() {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.invalidate();
    }

    public static void putResult(FinderPath finderPath, Object[] args, Object result) {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.putResult(finderPath, args, result);
    }

    public static void removeCache(String className) {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.removeCache(className);
    }

    public static void removeResult(FinderPath finderPath, Object[] args) {
        FinderCache finderCache = FinderCacheUtil.getFinderCache();
        finderCache.removeResult(finderPath, args);
    }

    private static class DummyFinderCacheHolder {
        private static final FinderCache _dummyFinderCache = ProxyFactory.newDummyInstance(FinderCache.class);

        private DummyFinderCacheHolder() {
        }
    }
}

