/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.security.permission.resource;

import com.liferay.portal.kernel.internal.security.permission.resource.PermissionCacheKey;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermissionLogic;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import java.util.Map;
import java.util.Objects;

public class DefaultPortletResourcePermission
implements PortletResourcePermission {
    private final PortletResourcePermissionLogic[] _portletResourcePermissionLogics;
    private final String _resourceName;

    public DefaultPortletResourcePermission(String resourceName, PortletResourcePermissionLogic ... portletResourcePermissionLogics) {
        this._resourceName = Objects.requireNonNull(resourceName);
        this._portletResourcePermissionLogics = Objects.requireNonNull(portletResourcePermissionLogics);
    }

    @Override
    public void check(PermissionChecker permissionChecker, Group group, String actionId) throws PrincipalException {
        if (group == null) {
            this.check(permissionChecker, 0L, actionId);
        } else if (!this.contains(permissionChecker, group, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker.getUserId(), this._resourceName, group.getGroupId(), actionId);
        }
    }

    @Override
    public void check(PermissionChecker permissionChecker, long groupId, String actionId) throws PrincipalException {
        if (!this.contains(permissionChecker, groupId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker.getUserId(), this._resourceName, groupId, actionId);
        }
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, Group group, String actionId) {
        Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
        long groupId = 0L;
        if (group != null) {
            groupId = group.getGroupId();
        }
        PermissionCacheKey permissionCacheKey = new PermissionCacheKey(this._resourceName, groupId, actionId);
        long finalGroupId = groupId;
        return (Boolean)permissionChecksMap.computeIfAbsent(permissionCacheKey, key -> this._contains(permissionChecker, group, finalGroupId, actionId));
    }

    @Override
    public boolean contains(PermissionChecker permissionChecker, long groupId, String actionId) {
        Map<Object, Object> permissionChecksMap = permissionChecker.getPermissionChecksMap();
        PermissionCacheKey permissionCacheKey = new PermissionCacheKey(this._resourceName, groupId, actionId);
        return (Boolean)permissionChecksMap.computeIfAbsent(permissionCacheKey, key -> {
            Group group = null;
            if (groupId > 0L) {
                group = GroupLocalServiceUtil.fetchGroup(groupId);
            }
            return this._contains(permissionChecker, group, groupId, actionId);
        });
    }

    @Override
    public String getResourceName() {
        return this._resourceName;
    }

    private boolean _contains(PermissionChecker permissionChecker, Group group, long groupId, String actionId) {
        for (PortletResourcePermissionLogic portletResourcePermissionLogic : this._portletResourcePermissionLogics) {
            Boolean contains = portletResourcePermissionLogic.contains(permissionChecker, this._resourceName, group, actionId);
            if (contains == null) continue;
            return contains;
        }
        if (group != null && group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        return permissionChecker.hasPermission(group, this._resourceName, groupId, actionId);
    }
}

