/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.internal.service.persistence;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQuery;
import com.liferay.portal.kernel.dao.jdbc.MappingSqlQueryFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.RowMapper;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.internal.cache.DummyPortalCache;
import com.liferay.portal.kernel.internal.dao.orm.TableMapperArgumentResolver;
import com.liferay.portal.kernel.internal.service.persistence.ReverseTableMapper;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.model.ModelListenerRegistrationUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.TableMapper;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class TableMapperImpl<L extends BaseModel<L>, R extends BaseModel<R>>
implements TableMapper<L, R> {
    protected SqlUpdate addTableMappingSqlUpdate;
    protected final boolean cacheless;
    protected MappingSqlQuery<Integer> containsTableMappingSQL;
    protected SqlUpdate deleteLeftPrimaryKeyTableMappingsSqlUpdate;
    protected SqlUpdate deleteRightPrimaryKeyTableMappingsSqlUpdate;
    protected SqlUpdate deleteTableMappingSqlUpdate;
    protected MappingSqlQuery<Long> getLeftPrimaryKeysSqlQuery;
    protected MappingSqlQuery<Long> getRightPrimaryKeysSqlQuery;
    protected final BasePersistence<L> leftBasePersistence;
    protected final String leftColumnName;
    protected final Class<L> leftModelClass;
    protected final PortalCache<Long, long[]> leftToRightPortalCache;
    protected TableMapper<R, L> reverseTableMapper;
    protected final BasePersistence<R> rightBasePersistence;
    protected final String rightColumnName;
    protected final Class<R> rightModelClass;
    protected final PortalCache<Long, long[]> rightToLeftPortalCache;
    private final ServiceRegistration<?> _serviceRegistration;
    private final String _tableName;

    public TableMapperImpl(String tableName, String companyColumnName, String leftColumnName, String rightColumnName, Class<L> leftModelClass, Class<R> rightModelClass, BasePersistence<L> leftBasePersistence, BasePersistence<R> rightBasePersistence, boolean cacheless) {
        this._tableName = tableName;
        this.leftColumnName = leftColumnName;
        this.rightColumnName = rightColumnName;
        this.leftModelClass = leftModelClass;
        this.rightModelClass = rightModelClass;
        this.leftBasePersistence = leftBasePersistence;
        this.rightBasePersistence = rightBasePersistence;
        this.cacheless = cacheless;
        String leftToRightPortalCacheName = StringBundler.concat((String[])new String[]{TableMapper.class.getName(), "-", tableName, "-", leftColumnName, "-To-", rightColumnName});
        String rightToLeftPortalCacheName = StringBundler.concat((String[])new String[]{TableMapper.class.getName(), "-", tableName, "-", rightColumnName, "-To-", leftColumnName});
        if (cacheless) {
            this.leftToRightPortalCache = new DummyPortalCache<Long, long[]>("MULTI_VM_PORTAL_CACHE_MANAGER", leftToRightPortalCacheName);
            this.rightToLeftPortalCache = new DummyPortalCache<Long, long[]>("MULTI_VM_PORTAL_CACHE_MANAGER", rightToLeftPortalCacheName);
        } else {
            this.leftToRightPortalCache = PortalCacheHelperUtil.getPortalCache("MULTI_VM_PORTAL_CACHE_MANAGER", leftToRightPortalCacheName);
            this.rightToLeftPortalCache = PortalCacheHelperUtil.getPortalCache("MULTI_VM_PORTAL_CACHE_MANAGER", rightToLeftPortalCacheName);
        }
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        this._serviceRegistration = bundleContext.registerService(ArgumentsResolver.class, (Object)new TableMapperArgumentResolver(tableName), HashMapDictionaryBuilder.put("class.name", tableName).put("table.name", tableName).build());
        this.init(tableName, companyColumnName, leftColumnName, rightColumnName);
    }

    @Override
    public boolean addTableMapping(long companyId, long leftPrimaryKey, long rightPrimaryKey) {
        if (this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, false)) {
            return false;
        }
        this.leftToRightPortalCache.remove(leftPrimaryKey);
        this.rightToLeftPortalCache.remove(rightPrimaryKey);
        FinderCacheUtil.clearDSLQueryCache(this._tableName);
        this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey);
        return true;
    }

    @Override
    public long[] addTableMappings(long companyId, long leftPrimaryKey, long[] rightPrimaryKeys) {
        ArrayList<Long> addedRightPrimaryKeys = new ArrayList<Long>();
        long[] currentRightPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, false);
        for (long rightPrimaryKey : rightPrimaryKeys) {
            if (Arrays.binarySearch(currentRightPrimaryKeys, rightPrimaryKey) >= 0) continue;
            addedRightPrimaryKeys.add(rightPrimaryKey);
            this.rightToLeftPortalCache.remove(rightPrimaryKey);
            this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey);
        }
        if (!addedRightPrimaryKeys.isEmpty()) {
            this.leftToRightPortalCache.remove(leftPrimaryKey);
            FinderCacheUtil.clearDSLQueryCache(this._tableName);
        }
        return ArrayUtil.toLongArray(addedRightPrimaryKeys);
    }

    @Override
    public long[] addTableMappings(long companyId, long[] leftPrimaryKeys, long rightPrimaryKey) {
        ArrayList<Long> addedLeftPrimaryKeys = new ArrayList<Long>();
        long[] currentLeftPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, false);
        for (long leftPrimaryKey : leftPrimaryKeys) {
            if (Arrays.binarySearch(currentLeftPrimaryKeys, leftPrimaryKey) >= 0) continue;
            addedLeftPrimaryKeys.add(leftPrimaryKey);
            this.leftToRightPortalCache.remove(leftPrimaryKey);
            this._addTableMapping(companyId, leftPrimaryKey, rightPrimaryKey);
        }
        if (!addedLeftPrimaryKeys.isEmpty()) {
            this.rightToLeftPortalCache.remove(rightPrimaryKey);
            FinderCacheUtil.clearDSLQueryCache(this._tableName);
        }
        return ArrayUtil.toLongArray(addedLeftPrimaryKeys);
    }

    @Override
    public boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey) {
        return this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, true);
    }

    @Override
    public int deleteLeftPrimaryKeyTableMappings(long leftPrimaryKey) {
        int count = TableMapperImpl.deleteTableMappings(this.leftModelClass, this.rightModelClass, this.leftToRightPortalCache, this.rightToLeftPortalCache, this.getRightPrimaryKeysSqlQuery, this.deleteLeftPrimaryKeyTableMappingsSqlUpdate, leftPrimaryKey);
        if (count > 0) {
            FinderCacheUtil.clearDSLQueryCache(this._tableName);
        }
        return count;
    }

    @Override
    public int deleteRightPrimaryKeyTableMappings(long rightPrimaryKey) {
        int count = TableMapperImpl.deleteTableMappings(this.rightModelClass, this.leftModelClass, this.rightToLeftPortalCache, this.leftToRightPortalCache, this.getLeftPrimaryKeysSqlQuery, this.deleteRightPrimaryKeyTableMappingsSqlUpdate, rightPrimaryKey);
        if (count > 0) {
            FinderCacheUtil.clearDSLQueryCache(this._tableName);
        }
        return count;
    }

    @Override
    public boolean deleteTableMapping(long leftPrimaryKey, long rightPrimaryKey) {
        if (!this.containsTableMapping(leftPrimaryKey, rightPrimaryKey, false)) {
            return false;
        }
        this.leftToRightPortalCache.remove(leftPrimaryKey);
        this.rightToLeftPortalCache.remove(rightPrimaryKey);
        FinderCacheUtil.clearDSLQueryCache(this._tableName);
        return this._deleteTableMapping(leftPrimaryKey, rightPrimaryKey);
    }

    @Override
    public long[] deleteTableMappings(long leftPrimaryKey, long[] rightPrimaryKeys) {
        boolean clearCache = false;
        long[] currentRightPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, false);
        ArrayList<Long> deletedRightPrimaryKeys = new ArrayList<Long>();
        for (long rightPrimaryKey : rightPrimaryKeys) {
            if (Arrays.binarySearch(currentRightPrimaryKeys, rightPrimaryKey) < 0) continue;
            clearCache = true;
            this.rightToLeftPortalCache.remove(rightPrimaryKey);
            if (!this._deleteTableMapping(leftPrimaryKey, rightPrimaryKey)) continue;
            deletedRightPrimaryKeys.add(rightPrimaryKey);
        }
        if (clearCache) {
            this.leftToRightPortalCache.remove(leftPrimaryKey);
            FinderCacheUtil.clearDSLQueryCache(this._tableName);
        }
        return ArrayUtil.toLongArray(deletedRightPrimaryKeys);
    }

    @Override
    public long[] deleteTableMappings(long[] leftPrimaryKeys, long rightPrimaryKey) {
        boolean clearCache = false;
        long[] currentLeftPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, false);
        ArrayList<Long> deletedLeftPrimaryKeys = new ArrayList<Long>();
        for (long leftPrimaryKey : leftPrimaryKeys) {
            if (Arrays.binarySearch(currentLeftPrimaryKeys, leftPrimaryKey) < 0) continue;
            this.leftToRightPortalCache.remove(leftPrimaryKey);
            clearCache = true;
            if (!this._deleteTableMapping(leftPrimaryKey, rightPrimaryKey)) continue;
            deletedLeftPrimaryKeys.add(leftPrimaryKey);
        }
        if (clearCache) {
            this.rightToLeftPortalCache.remove(rightPrimaryKey);
            FinderCacheUtil.clearDSLQueryCache(this._tableName);
        }
        return ArrayUtil.toLongArray(deletedLeftPrimaryKeys);
    }

    @Override
    public void destroy() {
        PortalCacheHelperUtil.removePortalCache("MULTI_VM_PORTAL_CACHE_MANAGER", this.leftToRightPortalCache.getPortalCacheName());
        PortalCacheHelperUtil.removePortalCache("MULTI_VM_PORTAL_CACHE_MANAGER", this.rightToLeftPortalCache.getPortalCacheName());
        this._serviceRegistration.unregister();
    }

    @Override
    public List<L> getLeftBaseModels(long rightPrimaryKey, int start, int end, OrderByComparator<L> orderByComparator) {
        return TableMapperImpl.getBaseModels(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, this.leftBasePersistence, start, end, orderByComparator);
    }

    @Override
    public long[] getLeftPrimaryKeys(long rightPrimaryKey) {
        return TableMapperImpl.getPrimaryKeys(this.rightToLeftPortalCache, this.getLeftPrimaryKeysSqlQuery, rightPrimaryKey, true);
    }

    @Override
    public TableMapper<R, L> getReverseTableMapper() {
        return this.reverseTableMapper;
    }

    @Override
    public List<R> getRightBaseModels(long leftPrimaryKey, int start, int end, OrderByComparator<R> orderByComparator) {
        return TableMapperImpl.getBaseModels(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, this.rightBasePersistence, start, end, orderByComparator);
    }

    @Override
    public long[] getRightPrimaryKeys(long leftPrimaryKey) {
        return TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, true);
    }

    @Override
    public boolean matches(String leftColumnName, String rightColumnName) {
        return this.leftColumnName.equals(leftColumnName) && this.rightColumnName.equals(rightColumnName);
    }

    protected static <M extends BaseModel<M>, S extends BaseModel<S>> int deleteTableMappings(Class<M> masterModelClass, Class<S> slaveModelClass, PortalCache<Long, long[]> masterToSlavePortalCache, PortalCache<Long, long[]> slaveToMasterPortalCache, MappingSqlQuery<Long> mappingSqlQuery, SqlUpdate deleteSqlUpdate, long masterPrimaryKey) {
        ModelListener<M>[] masterModelListeners = ModelListenerRegistrationUtil.getModelListeners(masterModelClass);
        ModelListener<S>[] slaveModelListeners = ModelListenerRegistrationUtil.getModelListeners(slaveModelClass);
        long[] slavePrimaryKeys = TableMapperImpl.getPrimaryKeys(masterToSlavePortalCache, mappingSqlQuery, masterPrimaryKey, false);
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                for (ModelListener<M> modelListener : masterModelListeners) {
                    modelListener.onBeforeRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                }
                for (ModelListener<Object> modelListener : slaveModelListeners) {
                    modelListener.onBeforeRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                }
            }
        }
        masterToSlavePortalCache.remove(masterPrimaryKey);
        for (long slavePrimaryKey : slavePrimaryKeys) {
            slaveToMasterPortalCache.remove(slavePrimaryKey);
        }
        int rowCount = 0;
        if (slavePrimaryKeys.length > 0) {
            try {
                rowCount = deleteSqlUpdate.update(masterPrimaryKey);
            }
            catch (Exception exception) {
                throw new SystemException(exception);
            }
        }
        if (masterModelListeners.length > 0 || slaveModelListeners.length > 0) {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                for (ModelListener<M> modelListener : masterModelListeners) {
                    modelListener.onAfterRemoveAssociation(masterPrimaryKey, slaveModelClass.getName(), slavePrimaryKey);
                }
                for (ModelListener<Object> modelListener : slaveModelListeners) {
                    modelListener.onAfterRemoveAssociation(slavePrimaryKey, masterModelClass.getName(), masterPrimaryKey);
                }
            }
        }
        return rowCount;
    }

    protected static <T extends BaseModel<T>> List<T> getBaseModels(PortalCache<Long, long[]> portalCache, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, BasePersistence<T> slaveBasePersistence, int start, int end, OrderByComparator<T> orderByComparator) {
        long[] slavePrimaryKeys = TableMapperImpl.getPrimaryKeys(portalCache, mappingSqlQuery, masterPrimaryKey, true);
        if (slavePrimaryKeys.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> slaveBaseModels = new ArrayList<T>(slavePrimaryKeys.length);
        try {
            for (long slavePrimaryKey : slavePrimaryKeys) {
                slaveBaseModels.add(slaveBasePersistence.findByPrimaryKey(Long.valueOf(slavePrimaryKey)));
            }
        }
        catch (NoSuchModelException noSuchModelException) {
            throw new SystemException(noSuchModelException);
        }
        if (orderByComparator != null) {
            Collections.sort(slaveBaseModels, orderByComparator);
        }
        return ListUtil.subList(slaveBaseModels, start, end);
    }

    protected static long[] getPrimaryKeys(PortalCache<Long, long[]> portalCache, MappingSqlQuery<Long> mappingSqlQuery, long masterPrimaryKey, boolean updateCache) {
        long[] primaryKeys = portalCache.get(masterPrimaryKey);
        if (primaryKeys == null) {
            List<Long> primaryKeysList = null;
            try {
                primaryKeysList = mappingSqlQuery.execute(masterPrimaryKey);
            }
            catch (Exception exception) {
                throw new SystemException(exception);
            }
            primaryKeys = new long[primaryKeysList.size()];
            for (int i = 0; i < primaryKeys.length; ++i) {
                primaryKeys[i] = primaryKeysList.get(i);
            }
            Arrays.sort(primaryKeys);
            if (updateCache) {
                PortalCacheHelperUtil.putWithoutReplicator(portalCache, masterPrimaryKey, primaryKeys);
            }
        }
        return primaryKeys;
    }

    protected boolean containsTableMapping(long leftPrimaryKey, long rightPrimaryKey, boolean updateCache) {
        if (this.cacheless) {
            List<Integer> counts = null;
            try {
                counts = this.containsTableMappingSQL.execute(leftPrimaryKey, rightPrimaryKey);
            }
            catch (Exception exception) {
                throw new SystemException(exception);
            }
            if (counts.isEmpty()) {
                return false;
            }
            int count = counts.get(0);
            return count != 0;
        }
        long[] rightPrimaryKeys = TableMapperImpl.getPrimaryKeys(this.leftToRightPortalCache, this.getRightPrimaryKeysSqlQuery, leftPrimaryKey, updateCache);
        return Arrays.binarySearch(rightPrimaryKeys, rightPrimaryKey) >= 0;
    }

    protected void init(String tableName, String companyColumnName, String leftColumnName, String rightColumnName) {
        DataSource dataSource = this.leftBasePersistence.getDataSource();
        this.addTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"INSERT INTO ", tableName, " (", companyColumnName, ", ", leftColumnName, ", ", rightColumnName, ") VALUES (?, ?, ?)"}), ParamSetter.BIGINT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        if (this.cacheless) {
            this.containsTableMappingSQL = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT * FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ?"}), RowMapper.COUNT, ParamSetter.BIGINT, ParamSetter.BIGINT);
        }
        this.deleteLeftPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"DELETE FROM ", tableName, " WHERE ", leftColumnName, " = ?"}), ParamSetter.BIGINT);
        this.deleteRightPrimaryKeyTableMappingsSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"DELETE FROM ", tableName, " WHERE ", rightColumnName, " = ?"}), ParamSetter.BIGINT);
        this.deleteTableMappingSqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate(dataSource, StringBundler.concat((String[])new String[]{"DELETE FROM ", tableName, " WHERE ", leftColumnName, " = ? AND ", rightColumnName, " = ?"}), ParamSetter.BIGINT, ParamSetter.BIGINT);
        this.getLeftPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT ", leftColumnName, " FROM ", tableName, " WHERE ", rightColumnName, " = ?"}), RowMapper.PRIMARY_KEY, ParamSetter.BIGINT);
        this.getRightPrimaryKeysSqlQuery = MappingSqlQueryFactoryUtil.getMappingSqlQuery(dataSource, StringBundler.concat((String[])new String[]{"SELECT ", rightColumnName, " FROM ", tableName, " WHERE ", leftColumnName, " = ?"}), RowMapper.PRIMARY_KEY, ParamSetter.BIGINT);
        this.reverseTableMapper = new ReverseTableMapper<R, L>(this);
    }

    private void _addTableMapping(long companyId, long leftPrimaryKey, long rightPrimaryKey) {
        ModelListener<L>[] leftModelListeners;
        for (ModelListener<L> leftModelListener : leftModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.leftModelClass)) {
            leftModelListener.onBeforeAddAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        ModelListener<R>[] rightModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.rightModelClass);
        for (ModelListener<R> modelListener : rightModelListeners) {
            modelListener.onBeforeAddAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
        try {
            this.addTableMappingSqlUpdate.update(companyId, leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception exception) {
            throw new SystemException(exception);
        }
        for (ModelListener<Object> modelListener : leftModelListeners) {
            modelListener.onAfterAddAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener<Object> modelListener : rightModelListeners) {
            modelListener.onAfterAddAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
    }

    private boolean _deleteTableMapping(long leftPrimaryKey, long rightPrimaryKey) {
        ModelListener<R>[] rightModelListeners;
        ModelListener<L>[] leftModelListeners;
        for (ModelListener<L> leftModelListener : leftModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.leftModelClass)) {
            leftModelListener.onBeforeRemoveAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
        }
        for (ModelListener<R> rightModelListener : rightModelListeners = ModelListenerRegistrationUtil.getModelListeners(this.rightModelClass)) {
            rightModelListener.onBeforeRemoveAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
        }
        int rowCount = 0;
        try {
            rowCount = this.deleteTableMappingSqlUpdate.update(leftPrimaryKey, rightPrimaryKey);
        }
        catch (Exception exception) {
            throw new SystemException(exception);
        }
        if (rowCount > 0) {
            for (ModelListener<L> modelListener : leftModelListeners) {
                modelListener.onAfterRemoveAssociation(leftPrimaryKey, this.rightModelClass.getName(), rightPrimaryKey);
            }
            for (ModelListener<Object> modelListener : rightModelListeners) {
                modelListener.onAfterRemoveAssociation(rightPrimaryKey, this.leftModelClass.getName(), leftPrimaryKey);
            }
            return true;
        }
        return false;
    }
}

