/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.proxy;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.proxy.FileEntryProxyBean;
import com.liferay.portal.kernel.repository.proxy.FileShortcutProxyBean;
import com.liferay.portal.kernel.repository.proxy.FileVersionProxyBean;
import com.liferay.portal.kernel.repository.proxy.FolderProxyBean;
import com.liferay.portal.kernel.repository.proxy.LocalRepositoryProxyBean;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public abstract class RepositoryModelProxyBean {
    private static final Function<InvocationHandler, FileEntry> _fileEntryProxyProviderFunction = ProxyUtil.getProxyProviderFunction(FileEntry.class);
    private static final Function<InvocationHandler, FileShortcut> _fileShortcutProxyProviderFunction = ProxyUtil.getProxyProviderFunction(FileShortcut.class);
    private static final Function<InvocationHandler, FileVersion> _fileVersionProxyProviderFunction = ProxyUtil.getProxyProviderFunction(FileVersion.class);
    private static final Function<InvocationHandler, Folder> _folderProxyProviderFunction = ProxyUtil.getProxyProviderFunction(Folder.class);
    private static final Function<InvocationHandler, LocalRepository> _localRepositoryProxyProviderFunction = ProxyUtil.getProxyProviderFunction(LocalRepository.class);
    private final ClassLoader _classLoader;

    public RepositoryModelProxyBean(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    protected FileEntryProxyBean newFileEntryProxyBean(FileEntry fileEntry) {
        if (fileEntry == null) {
            return null;
        }
        FileEntry fileEntryProxy = this.newProxyInstance(fileEntry, _fileEntryProxyProviderFunction);
        return new FileEntryProxyBean(fileEntryProxy, this._classLoader);
    }

    protected FileShortcutProxyBean newFileShortcutProxyBean(FileShortcut fileShortcut) {
        if (fileShortcut == null) {
            return null;
        }
        FileShortcut fileShortcutProxy = this.newProxyInstance(fileShortcut, _fileShortcutProxyProviderFunction);
        return new FileShortcutProxyBean(fileShortcutProxy, this._classLoader);
    }

    protected FileVersionProxyBean newFileVersionProxyBean(FileVersion fileVersion) {
        if (fileVersion == null) {
            return null;
        }
        FileVersion fileVersionProxy = this.newProxyInstance(fileVersion, _fileVersionProxyProviderFunction);
        return new FileVersionProxyBean(fileVersionProxy, this._classLoader);
    }

    protected FolderProxyBean newFolderProxyBean(Folder folder) {
        if (folder == null) {
            return null;
        }
        Folder folderProxy = this.newProxyInstance(folder, _folderProxyProviderFunction);
        return new FolderProxyBean(folderProxy, this._classLoader);
    }

    protected LocalRepositoryProxyBean newLocalRepositoryProxyBean(LocalRepository localRepository) {
        LocalRepository localRepositoryProxy = this.newProxyInstance(localRepository, _localRepositoryProxyProviderFunction);
        return new LocalRepositoryProxyBean(localRepositoryProxy, this._classLoader);
    }

    protected Object newProxyBean(Object bean) {
        if (bean instanceof FileEntry) {
            return this.newFileEntryProxyBean((FileEntry)bean);
        }
        if (bean instanceof FileVersion) {
            return this.newFileVersionProxyBean((FileVersion)bean);
        }
        if (bean instanceof Folder) {
            return this.newFolderProxyBean((Folder)bean);
        }
        return bean;
    }

    protected <T> T newProxyInstance(Object bean, Function<InvocationHandler, T> proxyProviderFunction) {
        if (bean == null) {
            return null;
        }
        return proxyProviderFunction.apply(new ClassLoaderBeanHandler(bean, this._classLoader));
    }

    protected List<FileEntry> toFileEntryProxyBeans(List<FileEntry> fileEntries) {
        if (ListUtil.isEmpty(fileEntries)) {
            return fileEntries;
        }
        ArrayList<FileEntry> fileEntryProxyBeans = new ArrayList<FileEntry>(fileEntries.size());
        for (FileEntry fileEntry : fileEntries) {
            fileEntryProxyBeans.add(this.newFileEntryProxyBean(fileEntry));
        }
        if (ListUtil.isUnmodifiableList(fileEntries)) {
            return Collections.unmodifiableList(fileEntryProxyBeans);
        }
        return fileEntryProxyBeans;
    }

    protected List<FileVersion> toFileVersionProxyBeans(List<FileVersion> fileVersions) {
        if (ListUtil.isEmpty(fileVersions)) {
            return fileVersions;
        }
        ArrayList<FileVersion> fileVersionProxyBeans = new ArrayList<FileVersion>(fileVersions.size());
        for (FileVersion fileVersion : fileVersions) {
            fileVersionProxyBeans.add(this.newFileVersionProxyBean(fileVersion));
        }
        if (ListUtil.isUnmodifiableList(fileVersions)) {
            return Collections.unmodifiableList(fileVersionProxyBeans);
        }
        return fileVersionProxyBeans;
    }

    protected List<Folder> toFolderProxyBeans(List<Folder> folders) {
        if (ListUtil.isEmpty(folders)) {
            return folders;
        }
        ArrayList<Folder> folderProxyBeans = new ArrayList<Folder>(folders.size());
        for (Folder folder : folders) {
            folderProxyBeans.add(this.newFolderProxyBean(folder));
        }
        if (ListUtil.isUnmodifiableList(folders)) {
            return Collections.unmodifiableList(folderProxyBeans);
        }
        return folderProxyBeans;
    }

    protected List<RepositoryEntry> toObjectProxyBeans(List<RepositoryEntry> repositoryEntries) {
        if (ListUtil.isEmpty(repositoryEntries)) {
            return repositoryEntries;
        }
        ArrayList<RepositoryEntry> objectProxyBeans = new ArrayList<RepositoryEntry>();
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            objectProxyBeans.add((RepositoryEntry)this.newProxyBean(repositoryEntry));
        }
        if (ListUtil.isUnmodifiableList(repositoryEntries)) {
            return Collections.unmodifiableList(objectProxyBeans);
        }
        return objectProxyBeans;
    }
}

