/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resource.bundle;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import org.osgi.framework.BundleContext;

public class ResourceBundleLoaderUtil {
    private static final ServiceTrackerMap<String, ResourceBundleLoader> _bundleSymbolicNameServiceTrackerMap;
    private static ResourceBundleLoader _portalResourceBundleLoader;
    private static final ServiceTrackerMap<String, ResourceBundleLoader> _servletContextNameServiceTrackerMap;

    public static ResourceBundleLoader getPortalResourceBundleLoader() {
        return _portalResourceBundleLoader;
    }

    public static ResourceBundleLoader getResourceBundleLoaderByBundleSymbolicName(String bundleSymbolicName) {
        return (ResourceBundleLoader)_bundleSymbolicNameServiceTrackerMap.getService((Object)bundleSymbolicName);
    }

    public static ResourceBundleLoader getResourceBundleLoaderByServletContextName(String servletContextName) {
        return (ResourceBundleLoader)_servletContextNameServiceTrackerMap.getService((Object)servletContextName);
    }

    public static void setPortalResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        _portalResourceBundleLoader = resourceBundleLoader;
    }

    private ResourceBundleLoaderUtil() {
    }

    static {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        _bundleSymbolicNameServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ResourceBundleLoader.class, (String)"bundle.symbolic.name");
        _servletContextNameServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ResourceBundleLoader.class, (String)"servlet.context.name");
    }
}

