/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.membershippolicy;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.security.membershippolicy.SiteMembershipPolicy;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class BaseSiteMembershipPolicy
implements SiteMembershipPolicy {
    private static final Log _log = LogFactoryUtil.getLog(BaseSiteMembershipPolicy.class);

    @Override
    public void checkRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) throws PortalException {
    }

    @Override
    public boolean isMembershipAllowed(long userId, long groupId) throws PortalException {
        try {
            this.checkMembership(new long[]{userId}, new long[]{groupId}, null);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isMembershipProtected(PermissionChecker permissionChecker, long userId, long groupId) throws PortalException {
        if (permissionChecker.isGroupOwner(groupId)) {
            return false;
        }
        Role siteAdministratorRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Site Administrator");
        if (UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, groupId, siteAdministratorRole.getRoleId())) {
            return true;
        }
        Role siteOwnerRole = RoleLocalServiceUtil.getRole(permissionChecker.getCompanyId(), "Site Owner");
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, groupId, siteOwnerRole.getRoleId());
    }

    @Override
    public boolean isMembershipRequired(long userId, long groupId) throws PortalException {
        try {
            this.checkMembership(new long[]{userId}, null, new long[]{groupId});
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRoleAllowed(long userId, long groupId, long roleId) throws PortalException {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(0L);
        userGroupRole.setUserId(userId);
        userGroupRole.setGroupId(groupId);
        userGroupRole.setRoleId(roleId);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(userGroupRoles, null);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isRoleProtected(PermissionChecker permissionChecker, long userId, long groupId, long roleId) throws PortalException {
        if (permissionChecker.isGroupOwner(groupId)) {
            return false;
        }
        Role role = RoleLocalServiceUtil.getRole(roleId);
        String roleName = role.getName();
        if (!roleName.equals("Site Administrator") && !roleName.equals("Site Owner")) {
            return false;
        }
        return UserGroupRoleLocalServiceUtil.hasUserGroupRole(userId, groupId, roleId);
    }

    @Override
    public boolean isRoleRequired(long userId, long groupId, long roleId) {
        ArrayList<UserGroupRole> userGroupRoles = new ArrayList<UserGroupRole>();
        UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole(0L);
        userGroupRole.setUserId(userId);
        userGroupRole.setGroupId(groupId);
        userGroupRole.setRoleId(roleId);
        userGroupRoles.add(userGroupRole);
        try {
            this.checkRoles(null, userGroupRoles);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return true;
        }
        return false;
    }

    @Override
    public void propagateRoles(List<UserGroupRole> addUserGroupRoles, List<UserGroupRole> removeUserGroupRoles) throws PortalException {
    }

    @Override
    public void verifyPolicy() throws PortalException {
        ActionableDynamicQuery groupActionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        groupActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property property = PropertyFactoryUtil.forName("site");
            dynamicQuery.add(property.eq(true));
        });
        groupActionableDynamicQuery.setPerformActionMethod(group -> {
            this.verifyPolicy((Group)group);
            ActionableDynamicQuery userGroupRoleActionableDynamicQuery = UserGroupRoleLocalServiceUtil.getActionableDynamicQuery();
            userGroupRoleActionableDynamicQuery.setGroupId(group.getGroupId());
            userGroupRoleActionableDynamicQuery.setPerformActionMethod(userGroupRole -> this.verifyPolicy(userGroupRole.getRole()));
            userGroupRoleActionableDynamicQuery.performActions();
        });
        groupActionableDynamicQuery.performActions();
    }

    @Override
    public void verifyPolicy(Group group) throws PortalException {
        this.verifyPolicy(group, null, null, null, null, null);
    }

    @Override
    public void verifyPolicy(Role role) {
    }

    @Override
    public void verifyPolicy(Role role, Role oldRole, Map<String, Serializable> oldExpandoAttributes) {
    }
}

