/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class PermissionThreadLocal {
    private static final ThreadLocal<Boolean> _addResource = new CentralizedThreadLocal(PermissionThreadLocal.class + "._addResource", () -> Boolean.TRUE);
    private static final ThreadLocal<Set<String>> _flushResourcePermissionEnabled = new CentralizedThreadLocal(PermissionThreadLocal.class + "._flushResourcePermissionEnabled", HashSet::new);
    private static final ThreadLocal<PermissionChecker> _permissionChecker = new CentralizedThreadLocal(PermissionThreadLocal.class + "._permissionChecker", null, Function.identity(), true);

    public static PermissionChecker getPermissionChecker() {
        return _permissionChecker.get();
    }

    public static PermissionChecker getPermissionChecker(User user, boolean setThreadLocal) {
        PermissionChecker permissionChecker = _permissionChecker.get();
        if (permissionChecker == null || permissionChecker.getUserId() != user.getUserId()) {
            permissionChecker = PermissionCheckerFactoryUtil.create(user);
            if (setThreadLocal) {
                _permissionChecker.set(permissionChecker);
            }
        }
        return permissionChecker;
    }

    public static boolean isAddResource() {
        return _addResource.get();
    }

    public static boolean isFlushResourcePermissionEnabled(String resourceName, String primKey) {
        Set<String> set = _flushResourcePermissionEnabled.get();
        return !set.contains(resourceName + "_" + primKey);
    }

    public static void setAddResource(boolean addResource) {
        _addResource.set(addResource);
    }

    public static void setFlushResourcePermissionEnabled(String resourceName, String primKey, boolean enabled) {
        Set<String> set = _flushResourcePermissionEnabled.get();
        if (enabled) {
            set.remove(resourceName + "_" + primKey);
        } else {
            set.add(resourceName + "_" + primKey);
        }
    }

    public static void setPermissionChecker(PermissionChecker permissionChecker) {
        _permissionChecker.set(permissionChecker);
    }
}

