/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission.resource;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionRegistryUtil;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

public class ModelResourcePermissionUtil {
    private static final long _DEFAULT_PARENT_PRIMARY_KEY = 0L;
    private static final Log _log = LogFactoryUtil.getLog(ModelResourcePermissionUtil.class);

    public static void check(ModelResourcePermission<?> modelResourcePermission, PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        if (primaryKey == 0L) {
            PortletResourcePermission portletResourcePermission = modelResourcePermission.getPortletResourcePermission();
            portletResourcePermission.check(permissionChecker, groupId, actionId);
        } else {
            modelResourcePermission.check(permissionChecker, primaryKey, actionId);
        }
    }

    public static boolean contains(ModelResourcePermission<?> modelResourcePermission, PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        if (primaryKey == 0L) {
            PortletResourcePermission portletResourcePermission = modelResourcePermission.getPortletResourcePermission();
            return portletResourcePermission.contains(permissionChecker, groupId, actionId);
        }
        return modelResourcePermission.contains(permissionChecker, primaryKey, actionId);
    }

    public static Boolean contains(PermissionChecker permissionChecker, long groupId, String className, long classPK, String actionId) {
        ModelResourcePermission modelResourcePermission = ModelResourcePermissionRegistryUtil.getModelResourcePermission(className);
        if (modelResourcePermission == null) {
            return null;
        }
        try {
            PortletResourcePermission portletResourcePermission = modelResourcePermission.getPortletResourcePermission();
            if (portletResourcePermission == null) {
                return modelResourcePermission.contains(permissionChecker, classPK, actionId);
            }
            return ModelResourcePermissionUtil.contains(modelResourcePermission, permissionChecker, groupId, classPK, actionId);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn(portalException);
            }
            return false;
        }
    }
}

