/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.service;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamService;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;

public class TeamServiceUtil {
    private static volatile TeamService _service;

    public static Team addTeam(long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return TeamServiceUtil.getService().addTeam(groupId, name, description, serviceContext);
    }

    public static void deleteTeam(long teamId) throws PortalException {
        TeamServiceUtil.getService().deleteTeam(teamId);
    }

    public static List<Team> getGroupTeams(long groupId) throws PortalException {
        return TeamServiceUtil.getService().getGroupTeams(groupId);
    }

    public static String getOSGiServiceIdentifier() {
        return TeamServiceUtil.getService().getOSGiServiceIdentifier();
    }

    public static Team getTeam(long teamId) throws PortalException {
        return TeamServiceUtil.getService().getTeam(teamId);
    }

    public static Team getTeam(long groupId, String name) throws PortalException {
        return TeamServiceUtil.getService().getTeam(groupId, name);
    }

    public static List<Team> getUserTeams(long userId) throws PortalException {
        return TeamServiceUtil.getService().getUserTeams(userId);
    }

    public static List<Team> getUserTeams(long userId, long groupId) throws PortalException {
        return TeamServiceUtil.getService().getUserTeams(userId, groupId);
    }

    public static boolean hasUserTeam(long userId, long teamId) throws PortalException {
        return TeamServiceUtil.getService().hasUserTeam(userId, teamId);
    }

    public static List<Team> search(long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> orderByComparator) {
        return TeamServiceUtil.getService().search(groupId, name, description, params, start, end, orderByComparator);
    }

    public static int searchCount(long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        return TeamServiceUtil.getService().searchCount(groupId, name, description, params);
    }

    public static Team updateTeam(long teamId, String name, String description) throws PortalException {
        return TeamServiceUtil.getService().updateTeam(teamId, name, description);
    }

    public static TeamService getService() {
        return _service;
    }

    public static void setService(TeamService service) {
        _service = service;
    }
}

