/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.lang.ThreadContextClassLoaderUtil;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.servlet.LiferayFilter;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilterChain;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.util.function.Function;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PortalClassLoaderFilter
implements LiferayFilter {
    private static final Function<InvocationHandler, FilterChain> _filterChainProxyProviderFunction = ProxyUtil.getProxyProviderFunction(FilterChain.class);
    private Filter _filter;
    private FilterConfig _filterConfig;
    private LiferayFilter _liferayFilter;

    public void destroy() {
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
            this._filter.destroy();
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try (SafeCloseable safeCloseable = ThreadContextClassLoaderUtil.swap((ClassLoader)PortalClassLoaderUtil.getClassLoader());){
            FilterChain contextClassLoaderFilterChain = _filterChainProxyProviderFunction.apply(new ClassLoaderBeanHandler(filterChain, contextClassLoader));
            InvokerFilterChain invokerFilterChain = new InvokerFilterChain(contextClassLoaderFilterChain);
            invokerFilterChain.setContextClassLoader(contextClassLoader);
            invokerFilterChain.addFilter(this._filter);
            invokerFilterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this._filterConfig = filterConfig;
        String filterClassName = this._filterConfig.getInitParameter("filter-class");
        if (filterClassName.startsWith("com.liferay.filters.")) {
            filterClassName = StringUtil.replace(filterClassName, "com.liferay.filters.", "com.liferay.portal.servlet.filters.");
        }
        try {
            this._filter = (Filter)InstanceFactory.newInstance(PortalClassLoaderUtil.getClassLoader(), filterClassName);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        this._filter.init(this._filterConfig);
        if (this._filter instanceof LiferayFilter) {
            this._liferayFilter = (LiferayFilter)this._filter;
        }
    }

    @Override
    public boolean isFilterEnabled() {
        if (this._liferayFilter != null) {
            return this._liferayFilter.isFilterEnabled();
        }
        return true;
    }

    @Override
    public boolean isFilterEnabled(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (this._liferayFilter != null) {
            return this._liferayFilter.isFilterEnabled(httpServletRequest, httpServletResponse);
        }
        return true;
    }

    @Override
    public void setFilterEnabled(boolean filterEnabled) {
        if (this._liferayFilter != null) {
            this._liferayFilter.setFilterEnabled(filterEnabled);
        }
    }
}

