/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.settings.BaseSettings;
import com.liferay.portal.kernel.settings.FallbackKeys;
import com.liferay.portal.kernel.settings.Settings;

public class FallbackSettings
extends BaseSettings {
    private final FallbackKeys _fallbackKeys;

    public FallbackSettings(Settings parentSettings, FallbackKeys fallbackKeys) {
        super(parentSettings);
        this._fallbackKeys = fallbackKeys;
    }

    @Override
    protected String doGetValue(String key) {
        String value = this.parentSettings.getValue(key, null);
        if (value != null) {
            return value;
        }
        String[] fallbackKeysArray = this._fallbackKeys.get(key);
        if (fallbackKeysArray == null) {
            return null;
        }
        for (String fallbackKey : fallbackKeysArray) {
            value = this.parentSettings.getValue(fallbackKey, null);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    protected String[] doGetValues(String key) {
        String[] values = this.parentSettings.getValues(key, null);
        if (values != null) {
            return values;
        }
        String[] fallbackKeysArray = this._fallbackKeys.get(key);
        if (fallbackKeysArray == null) {
            return null;
        }
        for (String fallbackKey : fallbackKeysArray) {
            values = this.parentSettings.getValues(fallbackKey, null);
            if (values == null) continue;
            return values;
        }
        return null;
    }
}

