/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.social;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.social.SocialActivityManager;
import com.liferay.social.kernel.model.SocialActivity;
import com.liferay.social.kernel.service.SocialActivityLocalService;
import java.util.Date;

public abstract class BaseSocialActivityManager<T extends ClassedModel & GroupedModel>
implements SocialActivityManager<T> {
    @Override
    public void addActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        String className = this.getClassName(model);
        long primaryKey = this.getPrimaryKey(model);
        if (type == 10002) {
            if (primaryKey != ((GroupedModel)model).getGroupId()) {
                this.getSocialActivityLocalService().addActivity(userId, ((GroupedModel)model).getGroupId(), className, primaryKey, 10002, extraData, 0L);
            }
        } else {
            this.getSocialActivityLocalService().addActivity(userId, ((GroupedModel)model).getGroupId(), className, primaryKey, type, extraData, receiverUserId);
        }
    }

    @Override
    public void addUniqueActivity(long userId, Date createDate, T model, int type, String extraData, long receiverUserId) throws PortalException {
        this.getSocialActivityLocalService().addUniqueActivity(userId, ((GroupedModel)model).getGroupId(), createDate, this.getClassName(model), this.getPrimaryKey(model), type, extraData, receiverUserId);
    }

    @Override
    public void addUniqueActivity(long userId, T model, int type, String extraData, long receiverUserId) throws PortalException {
        this.getSocialActivityLocalService().addUniqueActivity(userId, ((GroupedModel)model).getGroupId(), this.getClassName(model), this.getPrimaryKey(model), type, extraData, receiverUserId);
    }

    @Override
    public void deleteActivities(T model) throws PortalException {
        this.getSocialActivityLocalService().deleteActivities(this.getClassName(model), this.getPrimaryKey(model));
    }

    @Override
    public void updateLastSocialActivity(long userId, T model, int type, Date createDate) {
        SocialActivity lastSocialActivity = this.getSocialActivityLocalService().fetchFirstActivity(this.getClassName(model), this.getPrimaryKey(model), type);
        if (lastSocialActivity != null) {
            lastSocialActivity.setUserId(userId);
            lastSocialActivity.setCreateDate(createDate.getTime());
            this.getSocialActivityLocalService().updateSocialActivity(lastSocialActivity);
        }
    }

    protected String getClassName(T classedModel) {
        return classedModel.getModelClassName();
    }

    protected long getPrimaryKey(T classedModel) {
        if (!(classedModel.getPrimaryKeyObj() instanceof Long)) {
            throw new IllegalArgumentException("Only models with a primary key of type Long can make use of SocialActivityManagers");
        }
        return (Long)classedModel.getPrimaryKeyObj();
    }

    protected abstract SocialActivityLocalService getSocialActivityLocalService();
}

