/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.template;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class TemplateManagerUtil {
    private static final ServiceTrackerMap<String, TemplateManager> _templateManagers = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)SystemBundleUtil.getBundleContext(), TemplateManager.class, (String)"language.type");

    public static Template getTemplate(String templateManagerName, TemplateResource templateResource, boolean restricted) throws TemplateException {
        TemplateManager templateManager = TemplateManagerUtil._getTemplateManagerChecked(templateManagerName);
        return templateManager.getTemplate(templateResource, restricted);
    }

    public static TemplateManager getTemplateManager(String templateManagerName) {
        return (TemplateManager)_templateManagers.getService((Object)templateManagerName);
    }

    public static Set<String> getTemplateManagerNames() {
        return _templateManagers.keySet();
    }

    public static boolean hasTemplateManager(String templateManagerName) {
        return _templateManagers.containsKey((Object)templateManagerName);
    }

    private static TemplateManager _getTemplateManagerChecked(String templateManagerName) throws TemplateException {
        TemplateManager templateManager = (TemplateManager)_templateManagers.getService((Object)templateManagerName);
        if (templateManager == null) {
            throw new TemplateException("Unsupported template manager " + templateManagerName);
        }
        return templateManager;
    }

    private TemplateManagerUtil() {
    }
}

