/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.upgrade.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.dao.ReleaseDAO;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class UpgradeModules
extends UpgradeProcess {
    public abstract String[] getBundleSymbolicNames();

    public abstract String[][] getConvertedLegacyModules();

    public abstract String[][] getLegacyServiceModules();

    protected void addRelease(String ... bundleSymbolicNames) throws SQLException {
        ReleaseDAO releaseDAO = new ReleaseDAO();
        for (String bundleSymbolicName : bundleSymbolicNames) {
            releaseDAO.addRelease(this.connection, bundleSymbolicName);
        }
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.updateExtractedModules();
        this.updateConvertedLegacyModules();
        this.updateLegacyServiceModules();
    }

    protected boolean hasServiceComponent(String buildNamespace) throws SQLException {
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select serviceComponentId from ServiceComponent where buildNamespace = ?");){
            preparedStatement.setString(1, buildNamespace);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void updateConvertedLegacyModules() throws IOException, SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (String[] convertedLegacyModule : this.getConvertedLegacyModules()) {
                String oldServletContextName = convertedLegacyModule[0];
                String newServletContextName = convertedLegacyModule[1];
                try (PreparedStatement preparedStatement = this.connection.prepareStatement("select servletContextName, buildNumber from Release_ where servletContextName = ?");){
                    preparedStatement.setString(1, oldServletContextName);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        if (!resultSet.next()) {
                            String buildNamespace = convertedLegacyModule[2];
                            if (this.hasServiceComponent(buildNamespace)) {
                                this.addRelease(newServletContextName);
                            }
                            continue;
                        }
                        this.updateServletContextName(oldServletContextName, newServletContextName);
                    }
                }
            }
        }
    }

    protected void updateExtractedModules() throws SQLException {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.addRelease(this.getBundleSymbolicNames());
        }
    }

    protected void updateLegacyServiceModules() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            for (String[] legacyServiceModule : this.getLegacyServiceModules()) {
                if (!this.hasTable(legacyServiceModule[1])) continue;
                this.addRelease(legacyServiceModule[0]);
            }
        }
    }

    protected void updateServletContextName(String oldServletContextName, String newServletContextName) throws IOException, SQLException {
        this.runSQL(StringBundler.concat((String[])new String[]{"update Release_ set servletContextName = '", newServletContextName, "' where servletContextName = '", oldServletContextName, "'"}));
    }
}

