/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.bookmarks.model.impl;

import com.liferay.portal.kernel.exception.SystemException;

import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.service.BookmarksEntryLocalServiceUtil;

/**
 * The extended model base implementation for the BookmarksEntry service. Represents a row in the &quot;BookmarksEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link BookmarksEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see BookmarksEntryImpl
 * @see com.liferay.portlet.bookmarks.model.BookmarksEntry
 * @generated
 */
public abstract class BookmarksEntryBaseImpl extends BookmarksEntryModelImpl
	implements BookmarksEntry {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a bookmarks entry model instance should use the {@link BookmarksEntry} interface instead.
	 */
	@Override
	public void persist() throws SystemException {
		if (this.isNew()) {
			BookmarksEntryLocalServiceUtil.addBookmarksEntry(this);
		}
		else {
			BookmarksEntryLocalServiceUtil.updateBookmarksEntry(this);
		}
	}

	@Override
	public void updateTreePath(String treePath) throws SystemException {
		BookmarksEntry bookmarksEntry = this;

		bookmarksEntry.setTreePath(treePath);

		BookmarksEntryLocalServiceUtil.updateBookmarksEntry(bookmarksEntry);
	}
}