/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.shopping.model.ShoppingItem;
import com.liferay.portlet.shopping.model.ShoppingItemModel;
import com.liferay.portlet.shopping.model.ShoppingItemSoap;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the ShoppingItem service. Represents a row in the &quot;ShoppingItem&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link com.liferay.portlet.shopping.model.ShoppingItemModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ShoppingItemImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ShoppingItemImpl
 * @see com.liferay.portlet.shopping.model.ShoppingItem
 * @see com.liferay.portlet.shopping.model.ShoppingItemModel
 * @generated
 */
@JSON(strict = true)
public class ShoppingItemModelImpl extends BaseModelImpl<ShoppingItem>
	implements ShoppingItemModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a shopping item model instance should use the {@link com.liferay.portlet.shopping.model.ShoppingItem} interface instead.
	 */
	public static final String TABLE_NAME = "ShoppingItem";
	public static final Object[][] TABLE_COLUMNS = {
			{ "itemId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "categoryId", Types.BIGINT },
			{ "sku", Types.VARCHAR },
			{ "name", Types.VARCHAR },
			{ "description", Types.VARCHAR },
			{ "properties", Types.VARCHAR },
			{ "fields_", Types.BOOLEAN },
			{ "fieldsQuantities", Types.VARCHAR },
			{ "minQuantity", Types.INTEGER },
			{ "maxQuantity", Types.INTEGER },
			{ "price", Types.DOUBLE },
			{ "discount", Types.DOUBLE },
			{ "taxable", Types.BOOLEAN },
			{ "shipping", Types.DOUBLE },
			{ "useShippingFormula", Types.BOOLEAN },
			{ "requiresShipping", Types.BOOLEAN },
			{ "stockQuantity", Types.INTEGER },
			{ "featured_", Types.BOOLEAN },
			{ "sale_", Types.BOOLEAN },
			{ "smallImage", Types.BOOLEAN },
			{ "smallImageId", Types.BIGINT },
			{ "smallImageURL", Types.VARCHAR },
			{ "mediumImage", Types.BOOLEAN },
			{ "mediumImageId", Types.BIGINT },
			{ "mediumImageURL", Types.VARCHAR },
			{ "largeImage", Types.BOOLEAN },
			{ "largeImageId", Types.BIGINT },
			{ "largeImageURL", Types.VARCHAR }
		};
	public static final String TABLE_SQL_CREATE = "create table ShoppingItem (itemId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,categoryId LONG,sku VARCHAR(75) null,name VARCHAR(200) null,description STRING null,properties STRING null,fields_ BOOLEAN,fieldsQuantities STRING null,minQuantity INTEGER,maxQuantity INTEGER,price DOUBLE,discount DOUBLE,taxable BOOLEAN,shipping DOUBLE,useShippingFormula BOOLEAN,requiresShipping BOOLEAN,stockQuantity INTEGER,featured_ BOOLEAN,sale_ BOOLEAN,smallImage BOOLEAN,smallImageId LONG,smallImageURL STRING null,mediumImage BOOLEAN,mediumImageId LONG,mediumImageURL STRING null,largeImage BOOLEAN,largeImageId LONG,largeImageURL STRING null)";
	public static final String TABLE_SQL_DROP = "drop table ShoppingItem";
	public static final String ORDER_BY_JPQL = " ORDER BY shoppingItem.itemId ASC";
	public static final String ORDER_BY_SQL = " ORDER BY ShoppingItem.itemId ASC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.entity.cache.enabled.com.liferay.portlet.shopping.model.ShoppingItem"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.com.liferay.portlet.shopping.model.ShoppingItem"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.column.bitmask.enabled.com.liferay.portlet.shopping.model.ShoppingItem"),
			true);
	public static long CATEGORYID_COLUMN_BITMASK = 1L;
	public static long COMPANYID_COLUMN_BITMASK = 2L;
	public static long GROUPID_COLUMN_BITMASK = 4L;
	public static long LARGEIMAGEID_COLUMN_BITMASK = 8L;
	public static long MEDIUMIMAGEID_COLUMN_BITMASK = 16L;
	public static long SKU_COLUMN_BITMASK = 32L;
	public static long SMALLIMAGEID_COLUMN_BITMASK = 64L;
	public static long ITEMID_COLUMN_BITMASK = 128L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static ShoppingItem toModel(ShoppingItemSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		ShoppingItem model = new ShoppingItemImpl();

		model.setItemId(soapModel.getItemId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCategoryId(soapModel.getCategoryId());
		model.setSku(soapModel.getSku());
		model.setName(soapModel.getName());
		model.setDescription(soapModel.getDescription());
		model.setProperties(soapModel.getProperties());
		model.setFields(soapModel.getFields());
		model.setFieldsQuantities(soapModel.getFieldsQuantities());
		model.setMinQuantity(soapModel.getMinQuantity());
		model.setMaxQuantity(soapModel.getMaxQuantity());
		model.setPrice(soapModel.getPrice());
		model.setDiscount(soapModel.getDiscount());
		model.setTaxable(soapModel.getTaxable());
		model.setShipping(soapModel.getShipping());
		model.setUseShippingFormula(soapModel.getUseShippingFormula());
		model.setRequiresShipping(soapModel.getRequiresShipping());
		model.setStockQuantity(soapModel.getStockQuantity());
		model.setFeatured(soapModel.getFeatured());
		model.setSale(soapModel.getSale());
		model.setSmallImage(soapModel.getSmallImage());
		model.setSmallImageId(soapModel.getSmallImageId());
		model.setSmallImageURL(soapModel.getSmallImageURL());
		model.setMediumImage(soapModel.getMediumImage());
		model.setMediumImageId(soapModel.getMediumImageId());
		model.setMediumImageURL(soapModel.getMediumImageURL());
		model.setLargeImage(soapModel.getLargeImage());
		model.setLargeImageId(soapModel.getLargeImageId());
		model.setLargeImageURL(soapModel.getLargeImageURL());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<ShoppingItem> toModels(ShoppingItemSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<ShoppingItem> models = new ArrayList<ShoppingItem>(soapModels.length);

		for (ShoppingItemSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.portal.util.PropsUtil.get(
				"lock.expiration.time.com.liferay.portlet.shopping.model.ShoppingItem"));

	public ShoppingItemModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _itemId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setItemId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _itemId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ShoppingItem.class;
	}

	@Override
	public String getModelClassName() {
		return ShoppingItem.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("itemId", getItemId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("categoryId", getCategoryId());
		attributes.put("sku", getSku());
		attributes.put("name", getName());
		attributes.put("description", getDescription());
		attributes.put("properties", getProperties());
		attributes.put("fields", getFields());
		attributes.put("fieldsQuantities", getFieldsQuantities());
		attributes.put("minQuantity", getMinQuantity());
		attributes.put("maxQuantity", getMaxQuantity());
		attributes.put("price", getPrice());
		attributes.put("discount", getDiscount());
		attributes.put("taxable", getTaxable());
		attributes.put("shipping", getShipping());
		attributes.put("useShippingFormula", getUseShippingFormula());
		attributes.put("requiresShipping", getRequiresShipping());
		attributes.put("stockQuantity", getStockQuantity());
		attributes.put("featured", getFeatured());
		attributes.put("sale", getSale());
		attributes.put("smallImage", getSmallImage());
		attributes.put("smallImageId", getSmallImageId());
		attributes.put("smallImageURL", getSmallImageURL());
		attributes.put("mediumImage", getMediumImage());
		attributes.put("mediumImageId", getMediumImageId());
		attributes.put("mediumImageURL", getMediumImageURL());
		attributes.put("largeImage", getLargeImage());
		attributes.put("largeImageId", getLargeImageId());
		attributes.put("largeImageURL", getLargeImageURL());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long itemId = (Long)attributes.get("itemId");

		if (itemId != null) {
			setItemId(itemId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		Long categoryId = (Long)attributes.get("categoryId");

		if (categoryId != null) {
			setCategoryId(categoryId);
		}

		String sku = (String)attributes.get("sku");

		if (sku != null) {
			setSku(sku);
		}

		String name = (String)attributes.get("name");

		if (name != null) {
			setName(name);
		}

		String description = (String)attributes.get("description");

		if (description != null) {
			setDescription(description);
		}

		String properties = (String)attributes.get("properties");

		if (properties != null) {
			setProperties(properties);
		}

		Boolean fields = (Boolean)attributes.get("fields");

		if (fields != null) {
			setFields(fields);
		}

		String fieldsQuantities = (String)attributes.get("fieldsQuantities");

		if (fieldsQuantities != null) {
			setFieldsQuantities(fieldsQuantities);
		}

		Integer minQuantity = (Integer)attributes.get("minQuantity");

		if (minQuantity != null) {
			setMinQuantity(minQuantity);
		}

		Integer maxQuantity = (Integer)attributes.get("maxQuantity");

		if (maxQuantity != null) {
			setMaxQuantity(maxQuantity);
		}

		Double price = (Double)attributes.get("price");

		if (price != null) {
			setPrice(price);
		}

		Double discount = (Double)attributes.get("discount");

		if (discount != null) {
			setDiscount(discount);
		}

		Boolean taxable = (Boolean)attributes.get("taxable");

		if (taxable != null) {
			setTaxable(taxable);
		}

		Double shipping = (Double)attributes.get("shipping");

		if (shipping != null) {
			setShipping(shipping);
		}

		Boolean useShippingFormula = (Boolean)attributes.get(
				"useShippingFormula");

		if (useShippingFormula != null) {
			setUseShippingFormula(useShippingFormula);
		}

		Boolean requiresShipping = (Boolean)attributes.get("requiresShipping");

		if (requiresShipping != null) {
			setRequiresShipping(requiresShipping);
		}

		Integer stockQuantity = (Integer)attributes.get("stockQuantity");

		if (stockQuantity != null) {
			setStockQuantity(stockQuantity);
		}

		Boolean featured = (Boolean)attributes.get("featured");

		if (featured != null) {
			setFeatured(featured);
		}

		Boolean sale = (Boolean)attributes.get("sale");

		if (sale != null) {
			setSale(sale);
		}

		Boolean smallImage = (Boolean)attributes.get("smallImage");

		if (smallImage != null) {
			setSmallImage(smallImage);
		}

		Long smallImageId = (Long)attributes.get("smallImageId");

		if (smallImageId != null) {
			setSmallImageId(smallImageId);
		}

		String smallImageURL = (String)attributes.get("smallImageURL");

		if (smallImageURL != null) {
			setSmallImageURL(smallImageURL);
		}

		Boolean mediumImage = (Boolean)attributes.get("mediumImage");

		if (mediumImage != null) {
			setMediumImage(mediumImage);
		}

		Long mediumImageId = (Long)attributes.get("mediumImageId");

		if (mediumImageId != null) {
			setMediumImageId(mediumImageId);
		}

		String mediumImageURL = (String)attributes.get("mediumImageURL");

		if (mediumImageURL != null) {
			setMediumImageURL(mediumImageURL);
		}

		Boolean largeImage = (Boolean)attributes.get("largeImage");

		if (largeImage != null) {
			setLargeImage(largeImage);
		}

		Long largeImageId = (Long)attributes.get("largeImageId");

		if (largeImageId != null) {
			setLargeImageId(largeImageId);
		}

		String largeImageURL = (String)attributes.get("largeImageURL");

		if (largeImageURL != null) {
			setLargeImageURL(largeImageURL);
		}
	}

	@JSON
	@Override
	public long getItemId() {
		return _itemId;
	}

	@Override
	public void setItemId(long itemId) {
		_columnBitmask = -1L;

		_itemId = itemId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_columnBitmask |= COMPANYID_COLUMN_BITMASK;

		if (!_setOriginalCompanyId) {
			_setOriginalCompanyId = true;

			_originalCompanyId = _companyId;
		}

		_companyId = companyId;
	}

	public long getOriginalCompanyId() {
		return _originalCompanyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_userId = userId;
	}

	@Override
	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}

	@Override
	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return StringPool.BLANK;
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getCategoryId() {
		return _categoryId;
	}

	@Override
	public void setCategoryId(long categoryId) {
		_columnBitmask |= CATEGORYID_COLUMN_BITMASK;

		if (!_setOriginalCategoryId) {
			_setOriginalCategoryId = true;

			_originalCategoryId = _categoryId;
		}

		_categoryId = categoryId;
	}

	public long getOriginalCategoryId() {
		return _originalCategoryId;
	}

	@JSON
	@Override
	public String getSku() {
		if (_sku == null) {
			return StringPool.BLANK;
		}
		else {
			return _sku;
		}
	}

	@Override
	public void setSku(String sku) {
		_columnBitmask |= SKU_COLUMN_BITMASK;

		if (_originalSku == null) {
			_originalSku = _sku;
		}

		_sku = sku;
	}

	public String getOriginalSku() {
		return GetterUtil.getString(_originalSku);
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return StringPool.BLANK;
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		_name = name;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return StringPool.BLANK;
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		_description = description;
	}

	@JSON
	@Override
	public String getProperties() {
		if (_properties == null) {
			return StringPool.BLANK;
		}
		else {
			return _properties;
		}
	}

	@Override
	public void setProperties(String properties) {
		_properties = properties;
	}

	@JSON
	@Override
	public boolean getFields() {
		return _fields;
	}

	@Override
	public boolean isFields() {
		return _fields;
	}

	@Override
	public void setFields(boolean fields) {
		_fields = fields;
	}

	@JSON
	@Override
	public String getFieldsQuantities() {
		if (_fieldsQuantities == null) {
			return StringPool.BLANK;
		}
		else {
			return _fieldsQuantities;
		}
	}

	@Override
	public void setFieldsQuantities(String fieldsQuantities) {
		_fieldsQuantities = fieldsQuantities;
	}

	@JSON
	@Override
	public int getMinQuantity() {
		return _minQuantity;
	}

	@Override
	public void setMinQuantity(int minQuantity) {
		_minQuantity = minQuantity;
	}

	@JSON
	@Override
	public int getMaxQuantity() {
		return _maxQuantity;
	}

	@Override
	public void setMaxQuantity(int maxQuantity) {
		_maxQuantity = maxQuantity;
	}

	@JSON
	@Override
	public double getPrice() {
		return _price;
	}

	@Override
	public void setPrice(double price) {
		_price = price;
	}

	@JSON
	@Override
	public double getDiscount() {
		return _discount;
	}

	@Override
	public void setDiscount(double discount) {
		_discount = discount;
	}

	@JSON
	@Override
	public boolean getTaxable() {
		return _taxable;
	}

	@Override
	public boolean isTaxable() {
		return _taxable;
	}

	@Override
	public void setTaxable(boolean taxable) {
		_taxable = taxable;
	}

	@JSON
	@Override
	public double getShipping() {
		return _shipping;
	}

	@Override
	public void setShipping(double shipping) {
		_shipping = shipping;
	}

	@JSON
	@Override
	public boolean getUseShippingFormula() {
		return _useShippingFormula;
	}

	@Override
	public boolean isUseShippingFormula() {
		return _useShippingFormula;
	}

	@Override
	public void setUseShippingFormula(boolean useShippingFormula) {
		_useShippingFormula = useShippingFormula;
	}

	@JSON
	@Override
	public boolean getRequiresShipping() {
		return _requiresShipping;
	}

	@Override
	public boolean isRequiresShipping() {
		return _requiresShipping;
	}

	@Override
	public void setRequiresShipping(boolean requiresShipping) {
		_requiresShipping = requiresShipping;
	}

	@JSON
	@Override
	public int getStockQuantity() {
		return _stockQuantity;
	}

	@Override
	public void setStockQuantity(int stockQuantity) {
		_stockQuantity = stockQuantity;
	}

	@JSON
	@Override
	public boolean getFeatured() {
		return _featured;
	}

	@Override
	public boolean isFeatured() {
		return _featured;
	}

	@Override
	public void setFeatured(boolean featured) {
		_featured = featured;
	}

	@JSON
	@Override
	public boolean getSale() {
		return _sale;
	}

	@Override
	public boolean isSale() {
		return _sale;
	}

	@Override
	public void setSale(boolean sale) {
		_sale = sale;
	}

	@JSON
	@Override
	public boolean getSmallImage() {
		return _smallImage;
	}

	@Override
	public boolean isSmallImage() {
		return _smallImage;
	}

	@Override
	public void setSmallImage(boolean smallImage) {
		_smallImage = smallImage;
	}

	@JSON
	@Override
	public long getSmallImageId() {
		return _smallImageId;
	}

	@Override
	public void setSmallImageId(long smallImageId) {
		_columnBitmask |= SMALLIMAGEID_COLUMN_BITMASK;

		if (!_setOriginalSmallImageId) {
			_setOriginalSmallImageId = true;

			_originalSmallImageId = _smallImageId;
		}

		_smallImageId = smallImageId;
	}

	public long getOriginalSmallImageId() {
		return _originalSmallImageId;
	}

	@JSON
	@Override
	public String getSmallImageURL() {
		if (_smallImageURL == null) {
			return StringPool.BLANK;
		}
		else {
			return _smallImageURL;
		}
	}

	@Override
	public void setSmallImageURL(String smallImageURL) {
		_smallImageURL = smallImageURL;
	}

	@JSON
	@Override
	public boolean getMediumImage() {
		return _mediumImage;
	}

	@Override
	public boolean isMediumImage() {
		return _mediumImage;
	}

	@Override
	public void setMediumImage(boolean mediumImage) {
		_mediumImage = mediumImage;
	}

	@JSON
	@Override
	public long getMediumImageId() {
		return _mediumImageId;
	}

	@Override
	public void setMediumImageId(long mediumImageId) {
		_columnBitmask |= MEDIUMIMAGEID_COLUMN_BITMASK;

		if (!_setOriginalMediumImageId) {
			_setOriginalMediumImageId = true;

			_originalMediumImageId = _mediumImageId;
		}

		_mediumImageId = mediumImageId;
	}

	public long getOriginalMediumImageId() {
		return _originalMediumImageId;
	}

	@JSON
	@Override
	public String getMediumImageURL() {
		if (_mediumImageURL == null) {
			return StringPool.BLANK;
		}
		else {
			return _mediumImageURL;
		}
	}

	@Override
	public void setMediumImageURL(String mediumImageURL) {
		_mediumImageURL = mediumImageURL;
	}

	@JSON
	@Override
	public boolean getLargeImage() {
		return _largeImage;
	}

	@Override
	public boolean isLargeImage() {
		return _largeImage;
	}

	@Override
	public void setLargeImage(boolean largeImage) {
		_largeImage = largeImage;
	}

	@JSON
	@Override
	public long getLargeImageId() {
		return _largeImageId;
	}

	@Override
	public void setLargeImageId(long largeImageId) {
		_columnBitmask |= LARGEIMAGEID_COLUMN_BITMASK;

		if (!_setOriginalLargeImageId) {
			_setOriginalLargeImageId = true;

			_originalLargeImageId = _largeImageId;
		}

		_largeImageId = largeImageId;
	}

	public long getOriginalLargeImageId() {
		return _originalLargeImageId;
	}

	@JSON
	@Override
	public String getLargeImageURL() {
		if (_largeImageURL == null) {
			return StringPool.BLANK;
		}
		else {
			return _largeImageURL;
		}
	}

	@Override
	public void setLargeImageURL(String largeImageURL) {
		_largeImageURL = largeImageURL;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			ShoppingItem.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ShoppingItem toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (ShoppingItem)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ShoppingItemImpl shoppingItemImpl = new ShoppingItemImpl();

		shoppingItemImpl.setItemId(getItemId());
		shoppingItemImpl.setGroupId(getGroupId());
		shoppingItemImpl.setCompanyId(getCompanyId());
		shoppingItemImpl.setUserId(getUserId());
		shoppingItemImpl.setUserName(getUserName());
		shoppingItemImpl.setCreateDate(getCreateDate());
		shoppingItemImpl.setModifiedDate(getModifiedDate());
		shoppingItemImpl.setCategoryId(getCategoryId());
		shoppingItemImpl.setSku(getSku());
		shoppingItemImpl.setName(getName());
		shoppingItemImpl.setDescription(getDescription());
		shoppingItemImpl.setProperties(getProperties());
		shoppingItemImpl.setFields(getFields());
		shoppingItemImpl.setFieldsQuantities(getFieldsQuantities());
		shoppingItemImpl.setMinQuantity(getMinQuantity());
		shoppingItemImpl.setMaxQuantity(getMaxQuantity());
		shoppingItemImpl.setPrice(getPrice());
		shoppingItemImpl.setDiscount(getDiscount());
		shoppingItemImpl.setTaxable(getTaxable());
		shoppingItemImpl.setShipping(getShipping());
		shoppingItemImpl.setUseShippingFormula(getUseShippingFormula());
		shoppingItemImpl.setRequiresShipping(getRequiresShipping());
		shoppingItemImpl.setStockQuantity(getStockQuantity());
		shoppingItemImpl.setFeatured(getFeatured());
		shoppingItemImpl.setSale(getSale());
		shoppingItemImpl.setSmallImage(getSmallImage());
		shoppingItemImpl.setSmallImageId(getSmallImageId());
		shoppingItemImpl.setSmallImageURL(getSmallImageURL());
		shoppingItemImpl.setMediumImage(getMediumImage());
		shoppingItemImpl.setMediumImageId(getMediumImageId());
		shoppingItemImpl.setMediumImageURL(getMediumImageURL());
		shoppingItemImpl.setLargeImage(getLargeImage());
		shoppingItemImpl.setLargeImageId(getLargeImageId());
		shoppingItemImpl.setLargeImageURL(getLargeImageURL());

		shoppingItemImpl.resetOriginalValues();

		return shoppingItemImpl;
	}

	@Override
	public int compareTo(ShoppingItem shoppingItem) {
		int value = 0;

		if (getItemId() < shoppingItem.getItemId()) {
			value = -1;
		}
		else if (getItemId() > shoppingItem.getItemId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof ShoppingItem)) {
			return false;
		}

		ShoppingItem shoppingItem = (ShoppingItem)obj;

		long primaryKey = shoppingItem.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public void resetOriginalValues() {
		ShoppingItemModelImpl shoppingItemModelImpl = this;

		shoppingItemModelImpl._originalGroupId = shoppingItemModelImpl._groupId;

		shoppingItemModelImpl._setOriginalGroupId = false;

		shoppingItemModelImpl._originalCompanyId = shoppingItemModelImpl._companyId;

		shoppingItemModelImpl._setOriginalCompanyId = false;

		shoppingItemModelImpl._originalCategoryId = shoppingItemModelImpl._categoryId;

		shoppingItemModelImpl._setOriginalCategoryId = false;

		shoppingItemModelImpl._originalSku = shoppingItemModelImpl._sku;

		shoppingItemModelImpl._originalSmallImageId = shoppingItemModelImpl._smallImageId;

		shoppingItemModelImpl._setOriginalSmallImageId = false;

		shoppingItemModelImpl._originalMediumImageId = shoppingItemModelImpl._mediumImageId;

		shoppingItemModelImpl._setOriginalMediumImageId = false;

		shoppingItemModelImpl._originalLargeImageId = shoppingItemModelImpl._largeImageId;

		shoppingItemModelImpl._setOriginalLargeImageId = false;

		shoppingItemModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<ShoppingItem> toCacheModel() {
		ShoppingItemCacheModel shoppingItemCacheModel = new ShoppingItemCacheModel();

		shoppingItemCacheModel.itemId = getItemId();

		shoppingItemCacheModel.groupId = getGroupId();

		shoppingItemCacheModel.companyId = getCompanyId();

		shoppingItemCacheModel.userId = getUserId();

		shoppingItemCacheModel.userName = getUserName();

		String userName = shoppingItemCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			shoppingItemCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			shoppingItemCacheModel.createDate = createDate.getTime();
		}
		else {
			shoppingItemCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			shoppingItemCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			shoppingItemCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		shoppingItemCacheModel.categoryId = getCategoryId();

		shoppingItemCacheModel.sku = getSku();

		String sku = shoppingItemCacheModel.sku;

		if ((sku != null) && (sku.length() == 0)) {
			shoppingItemCacheModel.sku = null;
		}

		shoppingItemCacheModel.name = getName();

		String name = shoppingItemCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			shoppingItemCacheModel.name = null;
		}

		shoppingItemCacheModel.description = getDescription();

		String description = shoppingItemCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			shoppingItemCacheModel.description = null;
		}

		shoppingItemCacheModel.properties = getProperties();

		String properties = shoppingItemCacheModel.properties;

		if ((properties != null) && (properties.length() == 0)) {
			shoppingItemCacheModel.properties = null;
		}

		shoppingItemCacheModel.fields = getFields();

		shoppingItemCacheModel.fieldsQuantities = getFieldsQuantities();

		String fieldsQuantities = shoppingItemCacheModel.fieldsQuantities;

		if ((fieldsQuantities != null) && (fieldsQuantities.length() == 0)) {
			shoppingItemCacheModel.fieldsQuantities = null;
		}

		shoppingItemCacheModel.minQuantity = getMinQuantity();

		shoppingItemCacheModel.maxQuantity = getMaxQuantity();

		shoppingItemCacheModel.price = getPrice();

		shoppingItemCacheModel.discount = getDiscount();

		shoppingItemCacheModel.taxable = getTaxable();

		shoppingItemCacheModel.shipping = getShipping();

		shoppingItemCacheModel.useShippingFormula = getUseShippingFormula();

		shoppingItemCacheModel.requiresShipping = getRequiresShipping();

		shoppingItemCacheModel.stockQuantity = getStockQuantity();

		shoppingItemCacheModel.featured = getFeatured();

		shoppingItemCacheModel.sale = getSale();

		shoppingItemCacheModel.smallImage = getSmallImage();

		shoppingItemCacheModel.smallImageId = getSmallImageId();

		shoppingItemCacheModel.smallImageURL = getSmallImageURL();

		String smallImageURL = shoppingItemCacheModel.smallImageURL;

		if ((smallImageURL != null) && (smallImageURL.length() == 0)) {
			shoppingItemCacheModel.smallImageURL = null;
		}

		shoppingItemCacheModel.mediumImage = getMediumImage();

		shoppingItemCacheModel.mediumImageId = getMediumImageId();

		shoppingItemCacheModel.mediumImageURL = getMediumImageURL();

		String mediumImageURL = shoppingItemCacheModel.mediumImageURL;

		if ((mediumImageURL != null) && (mediumImageURL.length() == 0)) {
			shoppingItemCacheModel.mediumImageURL = null;
		}

		shoppingItemCacheModel.largeImage = getLargeImage();

		shoppingItemCacheModel.largeImageId = getLargeImageId();

		shoppingItemCacheModel.largeImageURL = getLargeImageURL();

		String largeImageURL = shoppingItemCacheModel.largeImageURL;

		if ((largeImageURL != null) && (largeImageURL.length() == 0)) {
			shoppingItemCacheModel.largeImageURL = null;
		}

		return shoppingItemCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(69);

		sb.append("{itemId=");
		sb.append(getItemId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", categoryId=");
		sb.append(getCategoryId());
		sb.append(", sku=");
		sb.append(getSku());
		sb.append(", name=");
		sb.append(getName());
		sb.append(", description=");
		sb.append(getDescription());
		sb.append(", properties=");
		sb.append(getProperties());
		sb.append(", fields=");
		sb.append(getFields());
		sb.append(", fieldsQuantities=");
		sb.append(getFieldsQuantities());
		sb.append(", minQuantity=");
		sb.append(getMinQuantity());
		sb.append(", maxQuantity=");
		sb.append(getMaxQuantity());
		sb.append(", price=");
		sb.append(getPrice());
		sb.append(", discount=");
		sb.append(getDiscount());
		sb.append(", taxable=");
		sb.append(getTaxable());
		sb.append(", shipping=");
		sb.append(getShipping());
		sb.append(", useShippingFormula=");
		sb.append(getUseShippingFormula());
		sb.append(", requiresShipping=");
		sb.append(getRequiresShipping());
		sb.append(", stockQuantity=");
		sb.append(getStockQuantity());
		sb.append(", featured=");
		sb.append(getFeatured());
		sb.append(", sale=");
		sb.append(getSale());
		sb.append(", smallImage=");
		sb.append(getSmallImage());
		sb.append(", smallImageId=");
		sb.append(getSmallImageId());
		sb.append(", smallImageURL=");
		sb.append(getSmallImageURL());
		sb.append(", mediumImage=");
		sb.append(getMediumImage());
		sb.append(", mediumImageId=");
		sb.append(getMediumImageId());
		sb.append(", mediumImageURL=");
		sb.append(getMediumImageURL());
		sb.append(", largeImage=");
		sb.append(getLargeImage());
		sb.append(", largeImageId=");
		sb.append(getLargeImageId());
		sb.append(", largeImageURL=");
		sb.append(getLargeImageURL());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(106);

		sb.append("<model><model-name>");
		sb.append("com.liferay.portlet.shopping.model.ShoppingItem");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>itemId</column-name><column-value><![CDATA[");
		sb.append(getItemId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>categoryId</column-name><column-value><![CDATA[");
		sb.append(getCategoryId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>sku</column-name><column-value><![CDATA[");
		sb.append(getSku());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>name</column-name><column-value><![CDATA[");
		sb.append(getName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>description</column-name><column-value><![CDATA[");
		sb.append(getDescription());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>properties</column-name><column-value><![CDATA[");
		sb.append(getProperties());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>fields</column-name><column-value><![CDATA[");
		sb.append(getFields());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>fieldsQuantities</column-name><column-value><![CDATA[");
		sb.append(getFieldsQuantities());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>minQuantity</column-name><column-value><![CDATA[");
		sb.append(getMinQuantity());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>maxQuantity</column-name><column-value><![CDATA[");
		sb.append(getMaxQuantity());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>price</column-name><column-value><![CDATA[");
		sb.append(getPrice());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>discount</column-name><column-value><![CDATA[");
		sb.append(getDiscount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>taxable</column-name><column-value><![CDATA[");
		sb.append(getTaxable());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shipping</column-name><column-value><![CDATA[");
		sb.append(getShipping());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>useShippingFormula</column-name><column-value><![CDATA[");
		sb.append(getUseShippingFormula());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>requiresShipping</column-name><column-value><![CDATA[");
		sb.append(getRequiresShipping());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>stockQuantity</column-name><column-value><![CDATA[");
		sb.append(getStockQuantity());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>featured</column-name><column-value><![CDATA[");
		sb.append(getFeatured());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>sale</column-name><column-value><![CDATA[");
		sb.append(getSale());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>smallImage</column-name><column-value><![CDATA[");
		sb.append(getSmallImage());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>smallImageId</column-name><column-value><![CDATA[");
		sb.append(getSmallImageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>smallImageURL</column-name><column-value><![CDATA[");
		sb.append(getSmallImageURL());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>mediumImage</column-name><column-value><![CDATA[");
		sb.append(getMediumImage());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>mediumImageId</column-name><column-value><![CDATA[");
		sb.append(getMediumImageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>mediumImageURL</column-name><column-value><![CDATA[");
		sb.append(getMediumImageURL());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>largeImage</column-name><column-value><![CDATA[");
		sb.append(getLargeImage());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>largeImageId</column-name><column-value><![CDATA[");
		sb.append(getLargeImageId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>largeImageURL</column-name><column-value><![CDATA[");
		sb.append(getLargeImageURL());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = ShoppingItem.class.getClassLoader();
	private static Class<?>[] _escapedModelInterfaces = new Class[] {
			ShoppingItem.class
		};
	private long _itemId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _originalCompanyId;
	private boolean _setOriginalCompanyId;
	private long _userId;
	private String _userUuid;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private long _categoryId;
	private long _originalCategoryId;
	private boolean _setOriginalCategoryId;
	private String _sku;
	private String _originalSku;
	private String _name;
	private String _description;
	private String _properties;
	private boolean _fields;
	private String _fieldsQuantities;
	private int _minQuantity;
	private int _maxQuantity;
	private double _price;
	private double _discount;
	private boolean _taxable;
	private double _shipping;
	private boolean _useShippingFormula;
	private boolean _requiresShipping;
	private int _stockQuantity;
	private boolean _featured;
	private boolean _sale;
	private boolean _smallImage;
	private long _smallImageId;
	private long _originalSmallImageId;
	private boolean _setOriginalSmallImageId;
	private String _smallImageURL;
	private boolean _mediumImage;
	private long _mediumImageId;
	private long _originalMediumImageId;
	private boolean _setOriginalMediumImageId;
	private String _mediumImageURL;
	private boolean _largeImage;
	private long _largeImageId;
	private long _originalLargeImageId;
	private boolean _setOriginalLargeImageId;
	private String _largeImageURL;
	private long _columnBitmask;
	private ShoppingItem _escapedModel;
}