/**
 * Copyright (c) 2000-2013 Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.portlet.shopping.model.impl;

import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.model.CacheModel;
import com.liferay.portal.model.impl.BaseModelImpl;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;

import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.expando.util.ExpandoBridgeFactoryUtil;
import com.liferay.portlet.shopping.model.ShoppingOrder;
import com.liferay.portlet.shopping.model.ShoppingOrderModel;
import com.liferay.portlet.shopping.model.ShoppingOrderSoap;

import java.io.Serializable;

import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The base model implementation for the ShoppingOrder service. Represents a row in the &quot;ShoppingOrder&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link com.liferay.portlet.shopping.model.ShoppingOrderModel} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ShoppingOrderImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see ShoppingOrderImpl
 * @see com.liferay.portlet.shopping.model.ShoppingOrder
 * @see com.liferay.portlet.shopping.model.ShoppingOrderModel
 * @generated
 */
@JSON(strict = true)
public class ShoppingOrderModelImpl extends BaseModelImpl<ShoppingOrder>
	implements ShoppingOrderModel {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a shopping order model instance should use the {@link com.liferay.portlet.shopping.model.ShoppingOrder} interface instead.
	 */
	public static final String TABLE_NAME = "ShoppingOrder";
	public static final Object[][] TABLE_COLUMNS = {
			{ "orderId", Types.BIGINT },
			{ "groupId", Types.BIGINT },
			{ "companyId", Types.BIGINT },
			{ "userId", Types.BIGINT },
			{ "userName", Types.VARCHAR },
			{ "createDate", Types.TIMESTAMP },
			{ "modifiedDate", Types.TIMESTAMP },
			{ "number_", Types.VARCHAR },
			{ "tax", Types.DOUBLE },
			{ "shipping", Types.DOUBLE },
			{ "altShipping", Types.VARCHAR },
			{ "requiresShipping", Types.BOOLEAN },
			{ "insure", Types.BOOLEAN },
			{ "insurance", Types.DOUBLE },
			{ "couponCodes", Types.VARCHAR },
			{ "couponDiscount", Types.DOUBLE },
			{ "billingFirstName", Types.VARCHAR },
			{ "billingLastName", Types.VARCHAR },
			{ "billingEmailAddress", Types.VARCHAR },
			{ "billingCompany", Types.VARCHAR },
			{ "billingStreet", Types.VARCHAR },
			{ "billingCity", Types.VARCHAR },
			{ "billingState", Types.VARCHAR },
			{ "billingZip", Types.VARCHAR },
			{ "billingCountry", Types.VARCHAR },
			{ "billingPhone", Types.VARCHAR },
			{ "shipToBilling", Types.BOOLEAN },
			{ "shippingFirstName", Types.VARCHAR },
			{ "shippingLastName", Types.VARCHAR },
			{ "shippingEmailAddress", Types.VARCHAR },
			{ "shippingCompany", Types.VARCHAR },
			{ "shippingStreet", Types.VARCHAR },
			{ "shippingCity", Types.VARCHAR },
			{ "shippingState", Types.VARCHAR },
			{ "shippingZip", Types.VARCHAR },
			{ "shippingCountry", Types.VARCHAR },
			{ "shippingPhone", Types.VARCHAR },
			{ "ccName", Types.VARCHAR },
			{ "ccType", Types.VARCHAR },
			{ "ccNumber", Types.VARCHAR },
			{ "ccExpMonth", Types.INTEGER },
			{ "ccExpYear", Types.INTEGER },
			{ "ccVerNumber", Types.VARCHAR },
			{ "comments", Types.VARCHAR },
			{ "ppTxnId", Types.VARCHAR },
			{ "ppPaymentStatus", Types.VARCHAR },
			{ "ppPaymentGross", Types.DOUBLE },
			{ "ppReceiverEmail", Types.VARCHAR },
			{ "ppPayerEmail", Types.VARCHAR },
			{ "sendOrderEmail", Types.BOOLEAN },
			{ "sendShippingEmail", Types.BOOLEAN }
		};
	public static final String TABLE_SQL_CREATE = "create table ShoppingOrder (orderId LONG not null primary key,groupId LONG,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,number_ VARCHAR(75) null,tax DOUBLE,shipping DOUBLE,altShipping VARCHAR(75) null,requiresShipping BOOLEAN,insure BOOLEAN,insurance DOUBLE,couponCodes VARCHAR(75) null,couponDiscount DOUBLE,billingFirstName VARCHAR(75) null,billingLastName VARCHAR(75) null,billingEmailAddress VARCHAR(75) null,billingCompany VARCHAR(75) null,billingStreet VARCHAR(75) null,billingCity VARCHAR(75) null,billingState VARCHAR(75) null,billingZip VARCHAR(75) null,billingCountry VARCHAR(75) null,billingPhone VARCHAR(75) null,shipToBilling BOOLEAN,shippingFirstName VARCHAR(75) null,shippingLastName VARCHAR(75) null,shippingEmailAddress VARCHAR(75) null,shippingCompany VARCHAR(75) null,shippingStreet VARCHAR(75) null,shippingCity VARCHAR(75) null,shippingState VARCHAR(75) null,shippingZip VARCHAR(75) null,shippingCountry VARCHAR(75) null,shippingPhone VARCHAR(75) null,ccName VARCHAR(75) null,ccType VARCHAR(75) null,ccNumber VARCHAR(75) null,ccExpMonth INTEGER,ccExpYear INTEGER,ccVerNumber VARCHAR(75) null,comments STRING null,ppTxnId VARCHAR(75) null,ppPaymentStatus VARCHAR(75) null,ppPaymentGross DOUBLE,ppReceiverEmail VARCHAR(75) null,ppPayerEmail VARCHAR(75) null,sendOrderEmail BOOLEAN,sendShippingEmail BOOLEAN)";
	public static final String TABLE_SQL_DROP = "drop table ShoppingOrder";
	public static final String ORDER_BY_JPQL = " ORDER BY shoppingOrder.createDate DESC";
	public static final String ORDER_BY_SQL = " ORDER BY ShoppingOrder.createDate DESC";
	public static final String DATA_SOURCE = "liferayDataSource";
	public static final String SESSION_FACTORY = "liferaySessionFactory";
	public static final String TX_MANAGER = "liferayTransactionManager";
	public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.entity.cache.enabled.com.liferay.portlet.shopping.model.ShoppingOrder"),
			true);
	public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.finder.cache.enabled.com.liferay.portlet.shopping.model.ShoppingOrder"),
			true);
	public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(com.liferay.portal.util.PropsUtil.get(
				"value.object.column.bitmask.enabled.com.liferay.portlet.shopping.model.ShoppingOrder"),
			true);
	public static long GROUPID_COLUMN_BITMASK = 1L;
	public static long NUMBER_COLUMN_BITMASK = 2L;
	public static long PPPAYMENTSTATUS_COLUMN_BITMASK = 4L;
	public static long PPTXNID_COLUMN_BITMASK = 8L;
	public static long USERID_COLUMN_BITMASK = 16L;
	public static long CREATEDATE_COLUMN_BITMASK = 32L;

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 */
	public static ShoppingOrder toModel(ShoppingOrderSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		ShoppingOrder model = new ShoppingOrderImpl();

		model.setOrderId(soapModel.getOrderId());
		model.setGroupId(soapModel.getGroupId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setNumber(soapModel.getNumber());
		model.setTax(soapModel.getTax());
		model.setShipping(soapModel.getShipping());
		model.setAltShipping(soapModel.getAltShipping());
		model.setRequiresShipping(soapModel.getRequiresShipping());
		model.setInsure(soapModel.getInsure());
		model.setInsurance(soapModel.getInsurance());
		model.setCouponCodes(soapModel.getCouponCodes());
		model.setCouponDiscount(soapModel.getCouponDiscount());
		model.setBillingFirstName(soapModel.getBillingFirstName());
		model.setBillingLastName(soapModel.getBillingLastName());
		model.setBillingEmailAddress(soapModel.getBillingEmailAddress());
		model.setBillingCompany(soapModel.getBillingCompany());
		model.setBillingStreet(soapModel.getBillingStreet());
		model.setBillingCity(soapModel.getBillingCity());
		model.setBillingState(soapModel.getBillingState());
		model.setBillingZip(soapModel.getBillingZip());
		model.setBillingCountry(soapModel.getBillingCountry());
		model.setBillingPhone(soapModel.getBillingPhone());
		model.setShipToBilling(soapModel.getShipToBilling());
		model.setShippingFirstName(soapModel.getShippingFirstName());
		model.setShippingLastName(soapModel.getShippingLastName());
		model.setShippingEmailAddress(soapModel.getShippingEmailAddress());
		model.setShippingCompany(soapModel.getShippingCompany());
		model.setShippingStreet(soapModel.getShippingStreet());
		model.setShippingCity(soapModel.getShippingCity());
		model.setShippingState(soapModel.getShippingState());
		model.setShippingZip(soapModel.getShippingZip());
		model.setShippingCountry(soapModel.getShippingCountry());
		model.setShippingPhone(soapModel.getShippingPhone());
		model.setCcName(soapModel.getCcName());
		model.setCcType(soapModel.getCcType());
		model.setCcNumber(soapModel.getCcNumber());
		model.setCcExpMonth(soapModel.getCcExpMonth());
		model.setCcExpYear(soapModel.getCcExpYear());
		model.setCcVerNumber(soapModel.getCcVerNumber());
		model.setComments(soapModel.getComments());
		model.setPpTxnId(soapModel.getPpTxnId());
		model.setPpPaymentStatus(soapModel.getPpPaymentStatus());
		model.setPpPaymentGross(soapModel.getPpPaymentGross());
		model.setPpReceiverEmail(soapModel.getPpReceiverEmail());
		model.setPpPayerEmail(soapModel.getPpPayerEmail());
		model.setSendOrderEmail(soapModel.getSendOrderEmail());
		model.setSendShippingEmail(soapModel.getSendShippingEmail());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 */
	public static List<ShoppingOrder> toModels(ShoppingOrderSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<ShoppingOrder> models = new ArrayList<ShoppingOrder>(soapModels.length);

		for (ShoppingOrderSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(com.liferay.portal.util.PropsUtil.get(
				"lock.expiration.time.com.liferay.portlet.shopping.model.ShoppingOrder"));

	public ShoppingOrderModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _orderId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setOrderId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _orderId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ShoppingOrder.class;
	}

	@Override
	public String getModelClassName() {
		return ShoppingOrder.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		attributes.put("orderId", getOrderId());
		attributes.put("groupId", getGroupId());
		attributes.put("companyId", getCompanyId());
		attributes.put("userId", getUserId());
		attributes.put("userName", getUserName());
		attributes.put("createDate", getCreateDate());
		attributes.put("modifiedDate", getModifiedDate());
		attributes.put("number", getNumber());
		attributes.put("tax", getTax());
		attributes.put("shipping", getShipping());
		attributes.put("altShipping", getAltShipping());
		attributes.put("requiresShipping", getRequiresShipping());
		attributes.put("insure", getInsure());
		attributes.put("insurance", getInsurance());
		attributes.put("couponCodes", getCouponCodes());
		attributes.put("couponDiscount", getCouponDiscount());
		attributes.put("billingFirstName", getBillingFirstName());
		attributes.put("billingLastName", getBillingLastName());
		attributes.put("billingEmailAddress", getBillingEmailAddress());
		attributes.put("billingCompany", getBillingCompany());
		attributes.put("billingStreet", getBillingStreet());
		attributes.put("billingCity", getBillingCity());
		attributes.put("billingState", getBillingState());
		attributes.put("billingZip", getBillingZip());
		attributes.put("billingCountry", getBillingCountry());
		attributes.put("billingPhone", getBillingPhone());
		attributes.put("shipToBilling", getShipToBilling());
		attributes.put("shippingFirstName", getShippingFirstName());
		attributes.put("shippingLastName", getShippingLastName());
		attributes.put("shippingEmailAddress", getShippingEmailAddress());
		attributes.put("shippingCompany", getShippingCompany());
		attributes.put("shippingStreet", getShippingStreet());
		attributes.put("shippingCity", getShippingCity());
		attributes.put("shippingState", getShippingState());
		attributes.put("shippingZip", getShippingZip());
		attributes.put("shippingCountry", getShippingCountry());
		attributes.put("shippingPhone", getShippingPhone());
		attributes.put("ccName", getCcName());
		attributes.put("ccType", getCcType());
		attributes.put("ccNumber", getCcNumber());
		attributes.put("ccExpMonth", getCcExpMonth());
		attributes.put("ccExpYear", getCcExpYear());
		attributes.put("ccVerNumber", getCcVerNumber());
		attributes.put("comments", getComments());
		attributes.put("ppTxnId", getPpTxnId());
		attributes.put("ppPaymentStatus", getPpPaymentStatus());
		attributes.put("ppPaymentGross", getPpPaymentGross());
		attributes.put("ppReceiverEmail", getPpReceiverEmail());
		attributes.put("ppPayerEmail", getPpPayerEmail());
		attributes.put("sendOrderEmail", getSendOrderEmail());
		attributes.put("sendShippingEmail", getSendShippingEmail());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Long orderId = (Long)attributes.get("orderId");

		if (orderId != null) {
			setOrderId(orderId);
		}

		Long groupId = (Long)attributes.get("groupId");

		if (groupId != null) {
			setGroupId(groupId);
		}

		Long companyId = (Long)attributes.get("companyId");

		if (companyId != null) {
			setCompanyId(companyId);
		}

		Long userId = (Long)attributes.get("userId");

		if (userId != null) {
			setUserId(userId);
		}

		String userName = (String)attributes.get("userName");

		if (userName != null) {
			setUserName(userName);
		}

		Date createDate = (Date)attributes.get("createDate");

		if (createDate != null) {
			setCreateDate(createDate);
		}

		Date modifiedDate = (Date)attributes.get("modifiedDate");

		if (modifiedDate != null) {
			setModifiedDate(modifiedDate);
		}

		String number = (String)attributes.get("number");

		if (number != null) {
			setNumber(number);
		}

		Double tax = (Double)attributes.get("tax");

		if (tax != null) {
			setTax(tax);
		}

		Double shipping = (Double)attributes.get("shipping");

		if (shipping != null) {
			setShipping(shipping);
		}

		String altShipping = (String)attributes.get("altShipping");

		if (altShipping != null) {
			setAltShipping(altShipping);
		}

		Boolean requiresShipping = (Boolean)attributes.get("requiresShipping");

		if (requiresShipping != null) {
			setRequiresShipping(requiresShipping);
		}

		Boolean insure = (Boolean)attributes.get("insure");

		if (insure != null) {
			setInsure(insure);
		}

		Double insurance = (Double)attributes.get("insurance");

		if (insurance != null) {
			setInsurance(insurance);
		}

		String couponCodes = (String)attributes.get("couponCodes");

		if (couponCodes != null) {
			setCouponCodes(couponCodes);
		}

		Double couponDiscount = (Double)attributes.get("couponDiscount");

		if (couponDiscount != null) {
			setCouponDiscount(couponDiscount);
		}

		String billingFirstName = (String)attributes.get("billingFirstName");

		if (billingFirstName != null) {
			setBillingFirstName(billingFirstName);
		}

		String billingLastName = (String)attributes.get("billingLastName");

		if (billingLastName != null) {
			setBillingLastName(billingLastName);
		}

		String billingEmailAddress = (String)attributes.get(
				"billingEmailAddress");

		if (billingEmailAddress != null) {
			setBillingEmailAddress(billingEmailAddress);
		}

		String billingCompany = (String)attributes.get("billingCompany");

		if (billingCompany != null) {
			setBillingCompany(billingCompany);
		}

		String billingStreet = (String)attributes.get("billingStreet");

		if (billingStreet != null) {
			setBillingStreet(billingStreet);
		}

		String billingCity = (String)attributes.get("billingCity");

		if (billingCity != null) {
			setBillingCity(billingCity);
		}

		String billingState = (String)attributes.get("billingState");

		if (billingState != null) {
			setBillingState(billingState);
		}

		String billingZip = (String)attributes.get("billingZip");

		if (billingZip != null) {
			setBillingZip(billingZip);
		}

		String billingCountry = (String)attributes.get("billingCountry");

		if (billingCountry != null) {
			setBillingCountry(billingCountry);
		}

		String billingPhone = (String)attributes.get("billingPhone");

		if (billingPhone != null) {
			setBillingPhone(billingPhone);
		}

		Boolean shipToBilling = (Boolean)attributes.get("shipToBilling");

		if (shipToBilling != null) {
			setShipToBilling(shipToBilling);
		}

		String shippingFirstName = (String)attributes.get("shippingFirstName");

		if (shippingFirstName != null) {
			setShippingFirstName(shippingFirstName);
		}

		String shippingLastName = (String)attributes.get("shippingLastName");

		if (shippingLastName != null) {
			setShippingLastName(shippingLastName);
		}

		String shippingEmailAddress = (String)attributes.get(
				"shippingEmailAddress");

		if (shippingEmailAddress != null) {
			setShippingEmailAddress(shippingEmailAddress);
		}

		String shippingCompany = (String)attributes.get("shippingCompany");

		if (shippingCompany != null) {
			setShippingCompany(shippingCompany);
		}

		String shippingStreet = (String)attributes.get("shippingStreet");

		if (shippingStreet != null) {
			setShippingStreet(shippingStreet);
		}

		String shippingCity = (String)attributes.get("shippingCity");

		if (shippingCity != null) {
			setShippingCity(shippingCity);
		}

		String shippingState = (String)attributes.get("shippingState");

		if (shippingState != null) {
			setShippingState(shippingState);
		}

		String shippingZip = (String)attributes.get("shippingZip");

		if (shippingZip != null) {
			setShippingZip(shippingZip);
		}

		String shippingCountry = (String)attributes.get("shippingCountry");

		if (shippingCountry != null) {
			setShippingCountry(shippingCountry);
		}

		String shippingPhone = (String)attributes.get("shippingPhone");

		if (shippingPhone != null) {
			setShippingPhone(shippingPhone);
		}

		String ccName = (String)attributes.get("ccName");

		if (ccName != null) {
			setCcName(ccName);
		}

		String ccType = (String)attributes.get("ccType");

		if (ccType != null) {
			setCcType(ccType);
		}

		String ccNumber = (String)attributes.get("ccNumber");

		if (ccNumber != null) {
			setCcNumber(ccNumber);
		}

		Integer ccExpMonth = (Integer)attributes.get("ccExpMonth");

		if (ccExpMonth != null) {
			setCcExpMonth(ccExpMonth);
		}

		Integer ccExpYear = (Integer)attributes.get("ccExpYear");

		if (ccExpYear != null) {
			setCcExpYear(ccExpYear);
		}

		String ccVerNumber = (String)attributes.get("ccVerNumber");

		if (ccVerNumber != null) {
			setCcVerNumber(ccVerNumber);
		}

		String comments = (String)attributes.get("comments");

		if (comments != null) {
			setComments(comments);
		}

		String ppTxnId = (String)attributes.get("ppTxnId");

		if (ppTxnId != null) {
			setPpTxnId(ppTxnId);
		}

		String ppPaymentStatus = (String)attributes.get("ppPaymentStatus");

		if (ppPaymentStatus != null) {
			setPpPaymentStatus(ppPaymentStatus);
		}

		Double ppPaymentGross = (Double)attributes.get("ppPaymentGross");

		if (ppPaymentGross != null) {
			setPpPaymentGross(ppPaymentGross);
		}

		String ppReceiverEmail = (String)attributes.get("ppReceiverEmail");

		if (ppReceiverEmail != null) {
			setPpReceiverEmail(ppReceiverEmail);
		}

		String ppPayerEmail = (String)attributes.get("ppPayerEmail");

		if (ppPayerEmail != null) {
			setPpPayerEmail(ppPayerEmail);
		}

		Boolean sendOrderEmail = (Boolean)attributes.get("sendOrderEmail");

		if (sendOrderEmail != null) {
			setSendOrderEmail(sendOrderEmail);
		}

		Boolean sendShippingEmail = (Boolean)attributes.get("sendShippingEmail");

		if (sendShippingEmail != null) {
			setSendShippingEmail(sendShippingEmail);
		}
	}

	@JSON
	@Override
	public long getOrderId() {
		return _orderId;
	}

	@Override
	public void setOrderId(long orderId) {
		_orderId = orderId;
	}

	@JSON
	@Override
	public long getGroupId() {
		return _groupId;
	}

	@Override
	public void setGroupId(long groupId) {
		_columnBitmask |= GROUPID_COLUMN_BITMASK;

		if (!_setOriginalGroupId) {
			_setOriginalGroupId = true;

			_originalGroupId = _groupId;
		}

		_groupId = groupId;
	}

	public long getOriginalGroupId() {
		return _originalGroupId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		_columnBitmask |= USERID_COLUMN_BITMASK;

		if (!_setOriginalUserId) {
			_setOriginalUserId = true;

			_originalUserId = _userId;
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() throws SystemException {
		return PortalUtil.getUserValue(getUserId(), "uuid", _userUuid);
	}

	@Override
	public void setUserUuid(String userUuid) {
		_userUuid = userUuid;
	}

	public long getOriginalUserId() {
		return _originalUserId;
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return StringPool.BLANK;
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		_columnBitmask = -1L;

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getNumber() {
		if (_number == null) {
			return StringPool.BLANK;
		}
		else {
			return _number;
		}
	}

	@Override
	public void setNumber(String number) {
		_columnBitmask |= NUMBER_COLUMN_BITMASK;

		if (_originalNumber == null) {
			_originalNumber = _number;
		}

		_number = number;
	}

	public String getOriginalNumber() {
		return GetterUtil.getString(_originalNumber);
	}

	@JSON
	@Override
	public double getTax() {
		return _tax;
	}

	@Override
	public void setTax(double tax) {
		_tax = tax;
	}

	@JSON
	@Override
	public double getShipping() {
		return _shipping;
	}

	@Override
	public void setShipping(double shipping) {
		_shipping = shipping;
	}

	@JSON
	@Override
	public String getAltShipping() {
		if (_altShipping == null) {
			return StringPool.BLANK;
		}
		else {
			return _altShipping;
		}
	}

	@Override
	public void setAltShipping(String altShipping) {
		_altShipping = altShipping;
	}

	@JSON
	@Override
	public boolean getRequiresShipping() {
		return _requiresShipping;
	}

	@Override
	public boolean isRequiresShipping() {
		return _requiresShipping;
	}

	@Override
	public void setRequiresShipping(boolean requiresShipping) {
		_requiresShipping = requiresShipping;
	}

	@JSON
	@Override
	public boolean getInsure() {
		return _insure;
	}

	@Override
	public boolean isInsure() {
		return _insure;
	}

	@Override
	public void setInsure(boolean insure) {
		_insure = insure;
	}

	@JSON
	@Override
	public double getInsurance() {
		return _insurance;
	}

	@Override
	public void setInsurance(double insurance) {
		_insurance = insurance;
	}

	@JSON
	@Override
	public String getCouponCodes() {
		if (_couponCodes == null) {
			return StringPool.BLANK;
		}
		else {
			return _couponCodes;
		}
	}

	@Override
	public void setCouponCodes(String couponCodes) {
		_couponCodes = couponCodes;
	}

	@JSON
	@Override
	public double getCouponDiscount() {
		return _couponDiscount;
	}

	@Override
	public void setCouponDiscount(double couponDiscount) {
		_couponDiscount = couponDiscount;
	}

	@JSON
	@Override
	public String getBillingFirstName() {
		if (_billingFirstName == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingFirstName;
		}
	}

	@Override
	public void setBillingFirstName(String billingFirstName) {
		_billingFirstName = billingFirstName;
	}

	@JSON
	@Override
	public String getBillingLastName() {
		if (_billingLastName == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingLastName;
		}
	}

	@Override
	public void setBillingLastName(String billingLastName) {
		_billingLastName = billingLastName;
	}

	@JSON
	@Override
	public String getBillingEmailAddress() {
		if (_billingEmailAddress == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingEmailAddress;
		}
	}

	@Override
	public void setBillingEmailAddress(String billingEmailAddress) {
		_billingEmailAddress = billingEmailAddress;
	}

	@JSON
	@Override
	public String getBillingCompany() {
		if (_billingCompany == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingCompany;
		}
	}

	@Override
	public void setBillingCompany(String billingCompany) {
		_billingCompany = billingCompany;
	}

	@JSON
	@Override
	public String getBillingStreet() {
		if (_billingStreet == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingStreet;
		}
	}

	@Override
	public void setBillingStreet(String billingStreet) {
		_billingStreet = billingStreet;
	}

	@JSON
	@Override
	public String getBillingCity() {
		if (_billingCity == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingCity;
		}
	}

	@Override
	public void setBillingCity(String billingCity) {
		_billingCity = billingCity;
	}

	@JSON
	@Override
	public String getBillingState() {
		if (_billingState == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingState;
		}
	}

	@Override
	public void setBillingState(String billingState) {
		_billingState = billingState;
	}

	@JSON
	@Override
	public String getBillingZip() {
		if (_billingZip == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingZip;
		}
	}

	@Override
	public void setBillingZip(String billingZip) {
		_billingZip = billingZip;
	}

	@JSON
	@Override
	public String getBillingCountry() {
		if (_billingCountry == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingCountry;
		}
	}

	@Override
	public void setBillingCountry(String billingCountry) {
		_billingCountry = billingCountry;
	}

	@JSON
	@Override
	public String getBillingPhone() {
		if (_billingPhone == null) {
			return StringPool.BLANK;
		}
		else {
			return _billingPhone;
		}
	}

	@Override
	public void setBillingPhone(String billingPhone) {
		_billingPhone = billingPhone;
	}

	@JSON
	@Override
	public boolean getShipToBilling() {
		return _shipToBilling;
	}

	@Override
	public boolean isShipToBilling() {
		return _shipToBilling;
	}

	@Override
	public void setShipToBilling(boolean shipToBilling) {
		_shipToBilling = shipToBilling;
	}

	@JSON
	@Override
	public String getShippingFirstName() {
		if (_shippingFirstName == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingFirstName;
		}
	}

	@Override
	public void setShippingFirstName(String shippingFirstName) {
		_shippingFirstName = shippingFirstName;
	}

	@JSON
	@Override
	public String getShippingLastName() {
		if (_shippingLastName == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingLastName;
		}
	}

	@Override
	public void setShippingLastName(String shippingLastName) {
		_shippingLastName = shippingLastName;
	}

	@JSON
	@Override
	public String getShippingEmailAddress() {
		if (_shippingEmailAddress == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingEmailAddress;
		}
	}

	@Override
	public void setShippingEmailAddress(String shippingEmailAddress) {
		_shippingEmailAddress = shippingEmailAddress;
	}

	@JSON
	@Override
	public String getShippingCompany() {
		if (_shippingCompany == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingCompany;
		}
	}

	@Override
	public void setShippingCompany(String shippingCompany) {
		_shippingCompany = shippingCompany;
	}

	@JSON
	@Override
	public String getShippingStreet() {
		if (_shippingStreet == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingStreet;
		}
	}

	@Override
	public void setShippingStreet(String shippingStreet) {
		_shippingStreet = shippingStreet;
	}

	@JSON
	@Override
	public String getShippingCity() {
		if (_shippingCity == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingCity;
		}
	}

	@Override
	public void setShippingCity(String shippingCity) {
		_shippingCity = shippingCity;
	}

	@JSON
	@Override
	public String getShippingState() {
		if (_shippingState == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingState;
		}
	}

	@Override
	public void setShippingState(String shippingState) {
		_shippingState = shippingState;
	}

	@JSON
	@Override
	public String getShippingZip() {
		if (_shippingZip == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingZip;
		}
	}

	@Override
	public void setShippingZip(String shippingZip) {
		_shippingZip = shippingZip;
	}

	@JSON
	@Override
	public String getShippingCountry() {
		if (_shippingCountry == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingCountry;
		}
	}

	@Override
	public void setShippingCountry(String shippingCountry) {
		_shippingCountry = shippingCountry;
	}

	@JSON
	@Override
	public String getShippingPhone() {
		if (_shippingPhone == null) {
			return StringPool.BLANK;
		}
		else {
			return _shippingPhone;
		}
	}

	@Override
	public void setShippingPhone(String shippingPhone) {
		_shippingPhone = shippingPhone;
	}

	@JSON
	@Override
	public String getCcName() {
		if (_ccName == null) {
			return StringPool.BLANK;
		}
		else {
			return _ccName;
		}
	}

	@Override
	public void setCcName(String ccName) {
		_ccName = ccName;
	}

	@JSON
	@Override
	public String getCcType() {
		if (_ccType == null) {
			return StringPool.BLANK;
		}
		else {
			return _ccType;
		}
	}

	@Override
	public void setCcType(String ccType) {
		_ccType = ccType;
	}

	@JSON
	@Override
	public String getCcNumber() {
		if (_ccNumber == null) {
			return StringPool.BLANK;
		}
		else {
			return _ccNumber;
		}
	}

	@Override
	public void setCcNumber(String ccNumber) {
		_ccNumber = ccNumber;
	}

	@JSON
	@Override
	public int getCcExpMonth() {
		return _ccExpMonth;
	}

	@Override
	public void setCcExpMonth(int ccExpMonth) {
		_ccExpMonth = ccExpMonth;
	}

	@JSON
	@Override
	public int getCcExpYear() {
		return _ccExpYear;
	}

	@Override
	public void setCcExpYear(int ccExpYear) {
		_ccExpYear = ccExpYear;
	}

	@JSON
	@Override
	public String getCcVerNumber() {
		if (_ccVerNumber == null) {
			return StringPool.BLANK;
		}
		else {
			return _ccVerNumber;
		}
	}

	@Override
	public void setCcVerNumber(String ccVerNumber) {
		_ccVerNumber = ccVerNumber;
	}

	@JSON
	@Override
	public String getComments() {
		if (_comments == null) {
			return StringPool.BLANK;
		}
		else {
			return _comments;
		}
	}

	@Override
	public void setComments(String comments) {
		_comments = comments;
	}

	@JSON
	@Override
	public String getPpTxnId() {
		if (_ppTxnId == null) {
			return StringPool.BLANK;
		}
		else {
			return _ppTxnId;
		}
	}

	@Override
	public void setPpTxnId(String ppTxnId) {
		_columnBitmask |= PPTXNID_COLUMN_BITMASK;

		if (_originalPpTxnId == null) {
			_originalPpTxnId = _ppTxnId;
		}

		_ppTxnId = ppTxnId;
	}

	public String getOriginalPpTxnId() {
		return GetterUtil.getString(_originalPpTxnId);
	}

	@JSON
	@Override
	public String getPpPaymentStatus() {
		if (_ppPaymentStatus == null) {
			return StringPool.BLANK;
		}
		else {
			return _ppPaymentStatus;
		}
	}

	@Override
	public void setPpPaymentStatus(String ppPaymentStatus) {
		_columnBitmask |= PPPAYMENTSTATUS_COLUMN_BITMASK;

		if (_originalPpPaymentStatus == null) {
			_originalPpPaymentStatus = _ppPaymentStatus;
		}

		_ppPaymentStatus = ppPaymentStatus;
	}

	public String getOriginalPpPaymentStatus() {
		return GetterUtil.getString(_originalPpPaymentStatus);
	}

	@JSON
	@Override
	public double getPpPaymentGross() {
		return _ppPaymentGross;
	}

	@Override
	public void setPpPaymentGross(double ppPaymentGross) {
		_ppPaymentGross = ppPaymentGross;
	}

	@JSON
	@Override
	public String getPpReceiverEmail() {
		if (_ppReceiverEmail == null) {
			return StringPool.BLANK;
		}
		else {
			return _ppReceiverEmail;
		}
	}

	@Override
	public void setPpReceiverEmail(String ppReceiverEmail) {
		_ppReceiverEmail = ppReceiverEmail;
	}

	@JSON
	@Override
	public String getPpPayerEmail() {
		if (_ppPayerEmail == null) {
			return StringPool.BLANK;
		}
		else {
			return _ppPayerEmail;
		}
	}

	@Override
	public void setPpPayerEmail(String ppPayerEmail) {
		_ppPayerEmail = ppPayerEmail;
	}

	@JSON
	@Override
	public boolean getSendOrderEmail() {
		return _sendOrderEmail;
	}

	@Override
	public boolean isSendOrderEmail() {
		return _sendOrderEmail;
	}

	@Override
	public void setSendOrderEmail(boolean sendOrderEmail) {
		_sendOrderEmail = sendOrderEmail;
	}

	@JSON
	@Override
	public boolean getSendShippingEmail() {
		return _sendShippingEmail;
	}

	@Override
	public boolean isSendShippingEmail() {
		return _sendShippingEmail;
	}

	@Override
	public void setSendShippingEmail(boolean sendShippingEmail) {
		_sendShippingEmail = sendShippingEmail;
	}

	public long getColumnBitmask() {
		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(getCompanyId(),
			ShoppingOrder.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public ShoppingOrder toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (ShoppingOrder)ProxyUtil.newProxyInstance(_classLoader,
					_escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ShoppingOrderImpl shoppingOrderImpl = new ShoppingOrderImpl();

		shoppingOrderImpl.setOrderId(getOrderId());
		shoppingOrderImpl.setGroupId(getGroupId());
		shoppingOrderImpl.setCompanyId(getCompanyId());
		shoppingOrderImpl.setUserId(getUserId());
		shoppingOrderImpl.setUserName(getUserName());
		shoppingOrderImpl.setCreateDate(getCreateDate());
		shoppingOrderImpl.setModifiedDate(getModifiedDate());
		shoppingOrderImpl.setNumber(getNumber());
		shoppingOrderImpl.setTax(getTax());
		shoppingOrderImpl.setShipping(getShipping());
		shoppingOrderImpl.setAltShipping(getAltShipping());
		shoppingOrderImpl.setRequiresShipping(getRequiresShipping());
		shoppingOrderImpl.setInsure(getInsure());
		shoppingOrderImpl.setInsurance(getInsurance());
		shoppingOrderImpl.setCouponCodes(getCouponCodes());
		shoppingOrderImpl.setCouponDiscount(getCouponDiscount());
		shoppingOrderImpl.setBillingFirstName(getBillingFirstName());
		shoppingOrderImpl.setBillingLastName(getBillingLastName());
		shoppingOrderImpl.setBillingEmailAddress(getBillingEmailAddress());
		shoppingOrderImpl.setBillingCompany(getBillingCompany());
		shoppingOrderImpl.setBillingStreet(getBillingStreet());
		shoppingOrderImpl.setBillingCity(getBillingCity());
		shoppingOrderImpl.setBillingState(getBillingState());
		shoppingOrderImpl.setBillingZip(getBillingZip());
		shoppingOrderImpl.setBillingCountry(getBillingCountry());
		shoppingOrderImpl.setBillingPhone(getBillingPhone());
		shoppingOrderImpl.setShipToBilling(getShipToBilling());
		shoppingOrderImpl.setShippingFirstName(getShippingFirstName());
		shoppingOrderImpl.setShippingLastName(getShippingLastName());
		shoppingOrderImpl.setShippingEmailAddress(getShippingEmailAddress());
		shoppingOrderImpl.setShippingCompany(getShippingCompany());
		shoppingOrderImpl.setShippingStreet(getShippingStreet());
		shoppingOrderImpl.setShippingCity(getShippingCity());
		shoppingOrderImpl.setShippingState(getShippingState());
		shoppingOrderImpl.setShippingZip(getShippingZip());
		shoppingOrderImpl.setShippingCountry(getShippingCountry());
		shoppingOrderImpl.setShippingPhone(getShippingPhone());
		shoppingOrderImpl.setCcName(getCcName());
		shoppingOrderImpl.setCcType(getCcType());
		shoppingOrderImpl.setCcNumber(getCcNumber());
		shoppingOrderImpl.setCcExpMonth(getCcExpMonth());
		shoppingOrderImpl.setCcExpYear(getCcExpYear());
		shoppingOrderImpl.setCcVerNumber(getCcVerNumber());
		shoppingOrderImpl.setComments(getComments());
		shoppingOrderImpl.setPpTxnId(getPpTxnId());
		shoppingOrderImpl.setPpPaymentStatus(getPpPaymentStatus());
		shoppingOrderImpl.setPpPaymentGross(getPpPaymentGross());
		shoppingOrderImpl.setPpReceiverEmail(getPpReceiverEmail());
		shoppingOrderImpl.setPpPayerEmail(getPpPayerEmail());
		shoppingOrderImpl.setSendOrderEmail(getSendOrderEmail());
		shoppingOrderImpl.setSendShippingEmail(getSendShippingEmail());

		shoppingOrderImpl.resetOriginalValues();

		return shoppingOrderImpl;
	}

	@Override
	public int compareTo(ShoppingOrder shoppingOrder) {
		int value = 0;

		value = DateUtil.compareTo(getCreateDate(),
				shoppingOrder.getCreateDate());

		value = value * -1;

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof ShoppingOrder)) {
			return false;
		}

		ShoppingOrder shoppingOrder = (ShoppingOrder)obj;

		long primaryKey = shoppingOrder.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	@Override
	public void resetOriginalValues() {
		ShoppingOrderModelImpl shoppingOrderModelImpl = this;

		shoppingOrderModelImpl._originalGroupId = shoppingOrderModelImpl._groupId;

		shoppingOrderModelImpl._setOriginalGroupId = false;

		shoppingOrderModelImpl._originalUserId = shoppingOrderModelImpl._userId;

		shoppingOrderModelImpl._setOriginalUserId = false;

		shoppingOrderModelImpl._originalNumber = shoppingOrderModelImpl._number;

		shoppingOrderModelImpl._originalPpTxnId = shoppingOrderModelImpl._ppTxnId;

		shoppingOrderModelImpl._originalPpPaymentStatus = shoppingOrderModelImpl._ppPaymentStatus;

		shoppingOrderModelImpl._columnBitmask = 0;
	}

	@Override
	public CacheModel<ShoppingOrder> toCacheModel() {
		ShoppingOrderCacheModel shoppingOrderCacheModel = new ShoppingOrderCacheModel();

		shoppingOrderCacheModel.orderId = getOrderId();

		shoppingOrderCacheModel.groupId = getGroupId();

		shoppingOrderCacheModel.companyId = getCompanyId();

		shoppingOrderCacheModel.userId = getUserId();

		shoppingOrderCacheModel.userName = getUserName();

		String userName = shoppingOrderCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			shoppingOrderCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			shoppingOrderCacheModel.createDate = createDate.getTime();
		}
		else {
			shoppingOrderCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			shoppingOrderCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			shoppingOrderCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		shoppingOrderCacheModel.number = getNumber();

		String number = shoppingOrderCacheModel.number;

		if ((number != null) && (number.length() == 0)) {
			shoppingOrderCacheModel.number = null;
		}

		shoppingOrderCacheModel.tax = getTax();

		shoppingOrderCacheModel.shipping = getShipping();

		shoppingOrderCacheModel.altShipping = getAltShipping();

		String altShipping = shoppingOrderCacheModel.altShipping;

		if ((altShipping != null) && (altShipping.length() == 0)) {
			shoppingOrderCacheModel.altShipping = null;
		}

		shoppingOrderCacheModel.requiresShipping = getRequiresShipping();

		shoppingOrderCacheModel.insure = getInsure();

		shoppingOrderCacheModel.insurance = getInsurance();

		shoppingOrderCacheModel.couponCodes = getCouponCodes();

		String couponCodes = shoppingOrderCacheModel.couponCodes;

		if ((couponCodes != null) && (couponCodes.length() == 0)) {
			shoppingOrderCacheModel.couponCodes = null;
		}

		shoppingOrderCacheModel.couponDiscount = getCouponDiscount();

		shoppingOrderCacheModel.billingFirstName = getBillingFirstName();

		String billingFirstName = shoppingOrderCacheModel.billingFirstName;

		if ((billingFirstName != null) && (billingFirstName.length() == 0)) {
			shoppingOrderCacheModel.billingFirstName = null;
		}

		shoppingOrderCacheModel.billingLastName = getBillingLastName();

		String billingLastName = shoppingOrderCacheModel.billingLastName;

		if ((billingLastName != null) && (billingLastName.length() == 0)) {
			shoppingOrderCacheModel.billingLastName = null;
		}

		shoppingOrderCacheModel.billingEmailAddress = getBillingEmailAddress();

		String billingEmailAddress = shoppingOrderCacheModel.billingEmailAddress;

		if ((billingEmailAddress != null) &&
				(billingEmailAddress.length() == 0)) {
			shoppingOrderCacheModel.billingEmailAddress = null;
		}

		shoppingOrderCacheModel.billingCompany = getBillingCompany();

		String billingCompany = shoppingOrderCacheModel.billingCompany;

		if ((billingCompany != null) && (billingCompany.length() == 0)) {
			shoppingOrderCacheModel.billingCompany = null;
		}

		shoppingOrderCacheModel.billingStreet = getBillingStreet();

		String billingStreet = shoppingOrderCacheModel.billingStreet;

		if ((billingStreet != null) && (billingStreet.length() == 0)) {
			shoppingOrderCacheModel.billingStreet = null;
		}

		shoppingOrderCacheModel.billingCity = getBillingCity();

		String billingCity = shoppingOrderCacheModel.billingCity;

		if ((billingCity != null) && (billingCity.length() == 0)) {
			shoppingOrderCacheModel.billingCity = null;
		}

		shoppingOrderCacheModel.billingState = getBillingState();

		String billingState = shoppingOrderCacheModel.billingState;

		if ((billingState != null) && (billingState.length() == 0)) {
			shoppingOrderCacheModel.billingState = null;
		}

		shoppingOrderCacheModel.billingZip = getBillingZip();

		String billingZip = shoppingOrderCacheModel.billingZip;

		if ((billingZip != null) && (billingZip.length() == 0)) {
			shoppingOrderCacheModel.billingZip = null;
		}

		shoppingOrderCacheModel.billingCountry = getBillingCountry();

		String billingCountry = shoppingOrderCacheModel.billingCountry;

		if ((billingCountry != null) && (billingCountry.length() == 0)) {
			shoppingOrderCacheModel.billingCountry = null;
		}

		shoppingOrderCacheModel.billingPhone = getBillingPhone();

		String billingPhone = shoppingOrderCacheModel.billingPhone;

		if ((billingPhone != null) && (billingPhone.length() == 0)) {
			shoppingOrderCacheModel.billingPhone = null;
		}

		shoppingOrderCacheModel.shipToBilling = getShipToBilling();

		shoppingOrderCacheModel.shippingFirstName = getShippingFirstName();

		String shippingFirstName = shoppingOrderCacheModel.shippingFirstName;

		if ((shippingFirstName != null) && (shippingFirstName.length() == 0)) {
			shoppingOrderCacheModel.shippingFirstName = null;
		}

		shoppingOrderCacheModel.shippingLastName = getShippingLastName();

		String shippingLastName = shoppingOrderCacheModel.shippingLastName;

		if ((shippingLastName != null) && (shippingLastName.length() == 0)) {
			shoppingOrderCacheModel.shippingLastName = null;
		}

		shoppingOrderCacheModel.shippingEmailAddress = getShippingEmailAddress();

		String shippingEmailAddress = shoppingOrderCacheModel.shippingEmailAddress;

		if ((shippingEmailAddress != null) &&
				(shippingEmailAddress.length() == 0)) {
			shoppingOrderCacheModel.shippingEmailAddress = null;
		}

		shoppingOrderCacheModel.shippingCompany = getShippingCompany();

		String shippingCompany = shoppingOrderCacheModel.shippingCompany;

		if ((shippingCompany != null) && (shippingCompany.length() == 0)) {
			shoppingOrderCacheModel.shippingCompany = null;
		}

		shoppingOrderCacheModel.shippingStreet = getShippingStreet();

		String shippingStreet = shoppingOrderCacheModel.shippingStreet;

		if ((shippingStreet != null) && (shippingStreet.length() == 0)) {
			shoppingOrderCacheModel.shippingStreet = null;
		}

		shoppingOrderCacheModel.shippingCity = getShippingCity();

		String shippingCity = shoppingOrderCacheModel.shippingCity;

		if ((shippingCity != null) && (shippingCity.length() == 0)) {
			shoppingOrderCacheModel.shippingCity = null;
		}

		shoppingOrderCacheModel.shippingState = getShippingState();

		String shippingState = shoppingOrderCacheModel.shippingState;

		if ((shippingState != null) && (shippingState.length() == 0)) {
			shoppingOrderCacheModel.shippingState = null;
		}

		shoppingOrderCacheModel.shippingZip = getShippingZip();

		String shippingZip = shoppingOrderCacheModel.shippingZip;

		if ((shippingZip != null) && (shippingZip.length() == 0)) {
			shoppingOrderCacheModel.shippingZip = null;
		}

		shoppingOrderCacheModel.shippingCountry = getShippingCountry();

		String shippingCountry = shoppingOrderCacheModel.shippingCountry;

		if ((shippingCountry != null) && (shippingCountry.length() == 0)) {
			shoppingOrderCacheModel.shippingCountry = null;
		}

		shoppingOrderCacheModel.shippingPhone = getShippingPhone();

		String shippingPhone = shoppingOrderCacheModel.shippingPhone;

		if ((shippingPhone != null) && (shippingPhone.length() == 0)) {
			shoppingOrderCacheModel.shippingPhone = null;
		}

		shoppingOrderCacheModel.ccName = getCcName();

		String ccName = shoppingOrderCacheModel.ccName;

		if ((ccName != null) && (ccName.length() == 0)) {
			shoppingOrderCacheModel.ccName = null;
		}

		shoppingOrderCacheModel.ccType = getCcType();

		String ccType = shoppingOrderCacheModel.ccType;

		if ((ccType != null) && (ccType.length() == 0)) {
			shoppingOrderCacheModel.ccType = null;
		}

		shoppingOrderCacheModel.ccNumber = getCcNumber();

		String ccNumber = shoppingOrderCacheModel.ccNumber;

		if ((ccNumber != null) && (ccNumber.length() == 0)) {
			shoppingOrderCacheModel.ccNumber = null;
		}

		shoppingOrderCacheModel.ccExpMonth = getCcExpMonth();

		shoppingOrderCacheModel.ccExpYear = getCcExpYear();

		shoppingOrderCacheModel.ccVerNumber = getCcVerNumber();

		String ccVerNumber = shoppingOrderCacheModel.ccVerNumber;

		if ((ccVerNumber != null) && (ccVerNumber.length() == 0)) {
			shoppingOrderCacheModel.ccVerNumber = null;
		}

		shoppingOrderCacheModel.comments = getComments();

		String comments = shoppingOrderCacheModel.comments;

		if ((comments != null) && (comments.length() == 0)) {
			shoppingOrderCacheModel.comments = null;
		}

		shoppingOrderCacheModel.ppTxnId = getPpTxnId();

		String ppTxnId = shoppingOrderCacheModel.ppTxnId;

		if ((ppTxnId != null) && (ppTxnId.length() == 0)) {
			shoppingOrderCacheModel.ppTxnId = null;
		}

		shoppingOrderCacheModel.ppPaymentStatus = getPpPaymentStatus();

		String ppPaymentStatus = shoppingOrderCacheModel.ppPaymentStatus;

		if ((ppPaymentStatus != null) && (ppPaymentStatus.length() == 0)) {
			shoppingOrderCacheModel.ppPaymentStatus = null;
		}

		shoppingOrderCacheModel.ppPaymentGross = getPpPaymentGross();

		shoppingOrderCacheModel.ppReceiverEmail = getPpReceiverEmail();

		String ppReceiverEmail = shoppingOrderCacheModel.ppReceiverEmail;

		if ((ppReceiverEmail != null) && (ppReceiverEmail.length() == 0)) {
			shoppingOrderCacheModel.ppReceiverEmail = null;
		}

		shoppingOrderCacheModel.ppPayerEmail = getPpPayerEmail();

		String ppPayerEmail = shoppingOrderCacheModel.ppPayerEmail;

		if ((ppPayerEmail != null) && (ppPayerEmail.length() == 0)) {
			shoppingOrderCacheModel.ppPayerEmail = null;
		}

		shoppingOrderCacheModel.sendOrderEmail = getSendOrderEmail();

		shoppingOrderCacheModel.sendShippingEmail = getSendShippingEmail();

		return shoppingOrderCacheModel;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(103);

		sb.append("{orderId=");
		sb.append(getOrderId());
		sb.append(", groupId=");
		sb.append(getGroupId());
		sb.append(", companyId=");
		sb.append(getCompanyId());
		sb.append(", userId=");
		sb.append(getUserId());
		sb.append(", userName=");
		sb.append(getUserName());
		sb.append(", createDate=");
		sb.append(getCreateDate());
		sb.append(", modifiedDate=");
		sb.append(getModifiedDate());
		sb.append(", number=");
		sb.append(getNumber());
		sb.append(", tax=");
		sb.append(getTax());
		sb.append(", shipping=");
		sb.append(getShipping());
		sb.append(", altShipping=");
		sb.append(getAltShipping());
		sb.append(", requiresShipping=");
		sb.append(getRequiresShipping());
		sb.append(", insure=");
		sb.append(getInsure());
		sb.append(", insurance=");
		sb.append(getInsurance());
		sb.append(", couponCodes=");
		sb.append(getCouponCodes());
		sb.append(", couponDiscount=");
		sb.append(getCouponDiscount());
		sb.append(", billingFirstName=");
		sb.append(getBillingFirstName());
		sb.append(", billingLastName=");
		sb.append(getBillingLastName());
		sb.append(", billingEmailAddress=");
		sb.append(getBillingEmailAddress());
		sb.append(", billingCompany=");
		sb.append(getBillingCompany());
		sb.append(", billingStreet=");
		sb.append(getBillingStreet());
		sb.append(", billingCity=");
		sb.append(getBillingCity());
		sb.append(", billingState=");
		sb.append(getBillingState());
		sb.append(", billingZip=");
		sb.append(getBillingZip());
		sb.append(", billingCountry=");
		sb.append(getBillingCountry());
		sb.append(", billingPhone=");
		sb.append(getBillingPhone());
		sb.append(", shipToBilling=");
		sb.append(getShipToBilling());
		sb.append(", shippingFirstName=");
		sb.append(getShippingFirstName());
		sb.append(", shippingLastName=");
		sb.append(getShippingLastName());
		sb.append(", shippingEmailAddress=");
		sb.append(getShippingEmailAddress());
		sb.append(", shippingCompany=");
		sb.append(getShippingCompany());
		sb.append(", shippingStreet=");
		sb.append(getShippingStreet());
		sb.append(", shippingCity=");
		sb.append(getShippingCity());
		sb.append(", shippingState=");
		sb.append(getShippingState());
		sb.append(", shippingZip=");
		sb.append(getShippingZip());
		sb.append(", shippingCountry=");
		sb.append(getShippingCountry());
		sb.append(", shippingPhone=");
		sb.append(getShippingPhone());
		sb.append(", ccName=");
		sb.append(getCcName());
		sb.append(", ccType=");
		sb.append(getCcType());
		sb.append(", ccNumber=");
		sb.append(getCcNumber());
		sb.append(", ccExpMonth=");
		sb.append(getCcExpMonth());
		sb.append(", ccExpYear=");
		sb.append(getCcExpYear());
		sb.append(", ccVerNumber=");
		sb.append(getCcVerNumber());
		sb.append(", comments=");
		sb.append(getComments());
		sb.append(", ppTxnId=");
		sb.append(getPpTxnId());
		sb.append(", ppPaymentStatus=");
		sb.append(getPpPaymentStatus());
		sb.append(", ppPaymentGross=");
		sb.append(getPpPaymentGross());
		sb.append(", ppReceiverEmail=");
		sb.append(getPpReceiverEmail());
		sb.append(", ppPayerEmail=");
		sb.append(getPpPayerEmail());
		sb.append(", sendOrderEmail=");
		sb.append(getSendOrderEmail());
		sb.append(", sendShippingEmail=");
		sb.append(getSendShippingEmail());
		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		StringBundler sb = new StringBundler(157);

		sb.append("<model><model-name>");
		sb.append("com.liferay.portlet.shopping.model.ShoppingOrder");
		sb.append("</model-name>");

		sb.append(
			"<column><column-name>orderId</column-name><column-value><![CDATA[");
		sb.append(getOrderId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>groupId</column-name><column-value><![CDATA[");
		sb.append(getGroupId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>companyId</column-name><column-value><![CDATA[");
		sb.append(getCompanyId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userId</column-name><column-value><![CDATA[");
		sb.append(getUserId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>userName</column-name><column-value><![CDATA[");
		sb.append(getUserName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>createDate</column-name><column-value><![CDATA[");
		sb.append(getCreateDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>modifiedDate</column-name><column-value><![CDATA[");
		sb.append(getModifiedDate());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>number</column-name><column-value><![CDATA[");
		sb.append(getNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>tax</column-name><column-value><![CDATA[");
		sb.append(getTax());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shipping</column-name><column-value><![CDATA[");
		sb.append(getShipping());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>altShipping</column-name><column-value><![CDATA[");
		sb.append(getAltShipping());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>requiresShipping</column-name><column-value><![CDATA[");
		sb.append(getRequiresShipping());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>insure</column-name><column-value><![CDATA[");
		sb.append(getInsure());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>insurance</column-name><column-value><![CDATA[");
		sb.append(getInsurance());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>couponCodes</column-name><column-value><![CDATA[");
		sb.append(getCouponCodes());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>couponDiscount</column-name><column-value><![CDATA[");
		sb.append(getCouponDiscount());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingFirstName</column-name><column-value><![CDATA[");
		sb.append(getBillingFirstName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingLastName</column-name><column-value><![CDATA[");
		sb.append(getBillingLastName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingEmailAddress</column-name><column-value><![CDATA[");
		sb.append(getBillingEmailAddress());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingCompany</column-name><column-value><![CDATA[");
		sb.append(getBillingCompany());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingStreet</column-name><column-value><![CDATA[");
		sb.append(getBillingStreet());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingCity</column-name><column-value><![CDATA[");
		sb.append(getBillingCity());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingState</column-name><column-value><![CDATA[");
		sb.append(getBillingState());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingZip</column-name><column-value><![CDATA[");
		sb.append(getBillingZip());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingCountry</column-name><column-value><![CDATA[");
		sb.append(getBillingCountry());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>billingPhone</column-name><column-value><![CDATA[");
		sb.append(getBillingPhone());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shipToBilling</column-name><column-value><![CDATA[");
		sb.append(getShipToBilling());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingFirstName</column-name><column-value><![CDATA[");
		sb.append(getShippingFirstName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingLastName</column-name><column-value><![CDATA[");
		sb.append(getShippingLastName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingEmailAddress</column-name><column-value><![CDATA[");
		sb.append(getShippingEmailAddress());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingCompany</column-name><column-value><![CDATA[");
		sb.append(getShippingCompany());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingStreet</column-name><column-value><![CDATA[");
		sb.append(getShippingStreet());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingCity</column-name><column-value><![CDATA[");
		sb.append(getShippingCity());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingState</column-name><column-value><![CDATA[");
		sb.append(getShippingState());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingZip</column-name><column-value><![CDATA[");
		sb.append(getShippingZip());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingCountry</column-name><column-value><![CDATA[");
		sb.append(getShippingCountry());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>shippingPhone</column-name><column-value><![CDATA[");
		sb.append(getShippingPhone());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ccName</column-name><column-value><![CDATA[");
		sb.append(getCcName());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ccType</column-name><column-value><![CDATA[");
		sb.append(getCcType());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ccNumber</column-name><column-value><![CDATA[");
		sb.append(getCcNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ccExpMonth</column-name><column-value><![CDATA[");
		sb.append(getCcExpMonth());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ccExpYear</column-name><column-value><![CDATA[");
		sb.append(getCcExpYear());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ccVerNumber</column-name><column-value><![CDATA[");
		sb.append(getCcVerNumber());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>comments</column-name><column-value><![CDATA[");
		sb.append(getComments());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ppTxnId</column-name><column-value><![CDATA[");
		sb.append(getPpTxnId());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ppPaymentStatus</column-name><column-value><![CDATA[");
		sb.append(getPpPaymentStatus());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ppPaymentGross</column-name><column-value><![CDATA[");
		sb.append(getPpPaymentGross());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ppReceiverEmail</column-name><column-value><![CDATA[");
		sb.append(getPpReceiverEmail());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>ppPayerEmail</column-name><column-value><![CDATA[");
		sb.append(getPpPayerEmail());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>sendOrderEmail</column-name><column-value><![CDATA[");
		sb.append(getSendOrderEmail());
		sb.append("]]></column-value></column>");
		sb.append(
			"<column><column-name>sendShippingEmail</column-name><column-value><![CDATA[");
		sb.append(getSendShippingEmail());
		sb.append("]]></column-value></column>");

		sb.append("</model>");

		return sb.toString();
	}

	private static ClassLoader _classLoader = ShoppingOrder.class.getClassLoader();
	private static Class<?>[] _escapedModelInterfaces = new Class[] {
			ShoppingOrder.class
		};
	private long _orderId;
	private long _groupId;
	private long _originalGroupId;
	private boolean _setOriginalGroupId;
	private long _companyId;
	private long _userId;
	private String _userUuid;
	private long _originalUserId;
	private boolean _setOriginalUserId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private String _number;
	private String _originalNumber;
	private double _tax;
	private double _shipping;
	private String _altShipping;
	private boolean _requiresShipping;
	private boolean _insure;
	private double _insurance;
	private String _couponCodes;
	private double _couponDiscount;
	private String _billingFirstName;
	private String _billingLastName;
	private String _billingEmailAddress;
	private String _billingCompany;
	private String _billingStreet;
	private String _billingCity;
	private String _billingState;
	private String _billingZip;
	private String _billingCountry;
	private String _billingPhone;
	private boolean _shipToBilling;
	private String _shippingFirstName;
	private String _shippingLastName;
	private String _shippingEmailAddress;
	private String _shippingCompany;
	private String _shippingStreet;
	private String _shippingCity;
	private String _shippingState;
	private String _shippingZip;
	private String _shippingCountry;
	private String _shippingPhone;
	private String _ccName;
	private String _ccType;
	private String _ccNumber;
	private int _ccExpMonth;
	private int _ccExpYear;
	private String _ccVerNumber;
	private String _comments;
	private String _ppTxnId;
	private String _originalPpTxnId;
	private String _ppPaymentStatus;
	private String _originalPpPaymentStatus;
	private double _ppPaymentGross;
	private String _ppReceiverEmail;
	private String _ppPayerEmail;
	private boolean _sendOrderEmail;
	private boolean _sendShippingEmail;
	private long _columnBitmask;
	private ShoppingOrder _escapedModel;
}