/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.text.Format;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.time.FastDateFormat;

@DoPrivileged
public class FastDateFormatFactoryImpl
implements FastDateFormatFactory {
    private Map<String, Format> _dateFormats = new ConcurrentHashMap<String, Format>();
    private Map<String, Format> _dateTimeFormats = new ConcurrentHashMap<String, Format>();
    private Map<String, Format> _simpleDateFormats = new ConcurrentHashMap<String, Format>();
    private Map<String, Format> _timeFormats = new ConcurrentHashMap<String, Format>();

    public Format getDate(int style, Locale locale, TimeZone timeZone) {
        String key = this.getKey(style, locale, timeZone);
        Format format = this._dateFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getDateInstance((int)style, (TimeZone)timeZone, (Locale)locale);
            this._dateFormats.put(key, format);
        }
        return format;
    }

    public Format getDate(Locale locale) {
        return this.getDate(locale, null);
    }

    public Format getDate(Locale locale, TimeZone timeZone) {
        return this.getDate(3, locale, timeZone);
    }

    public Format getDate(TimeZone timeZone) {
        return this.getDate(LocaleUtil.getDefault(), timeZone);
    }

    public Format getDateTime(int dateStyle, int timeStyle, Locale locale, TimeZone timeZone) {
        String key = this.getKey(dateStyle, timeStyle, locale, timeZone);
        Format format = this._dateTimeFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (TimeZone)timeZone, (Locale)locale);
            this._dateTimeFormats.put(key, format);
        }
        return format;
    }

    public Format getDateTime(Locale locale) {
        return this.getDateTime(locale, null);
    }

    public Format getDateTime(Locale locale, TimeZone timeZone) {
        return this.getDateTime(3, 3, locale, timeZone);
    }

    public Format getDateTime(TimeZone timeZone) {
        return this.getDateTime(LocaleUtil.getDefault(), timeZone);
    }

    public Format getSimpleDateFormat(String pattern) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), null);
    }

    public Format getSimpleDateFormat(String pattern, Locale locale) {
        return this.getSimpleDateFormat(pattern, locale, null);
    }

    public Format getSimpleDateFormat(String pattern, Locale locale, TimeZone timeZone) {
        String key = this.getKey(pattern, locale, timeZone);
        Format format = this._simpleDateFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
            this._simpleDateFormats.put(key, format);
        }
        return format;
    }

    public Format getSimpleDateFormat(String pattern, TimeZone timeZone) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), timeZone);
    }

    public Format getTime(int style, Locale locale, TimeZone timeZone) {
        String key = this.getKey(style, locale, timeZone);
        Format format = this._timeFormats.get(key);
        if (format == null) {
            format = FastDateFormat.getTimeInstance((int)style, (TimeZone)timeZone, (Locale)locale);
            this._timeFormats.put(key, format);
        }
        return format;
    }

    public Format getTime(Locale locale) {
        return this.getTime(locale, null);
    }

    public Format getTime(Locale locale, TimeZone timeZone) {
        return this.getTime(3, locale, timeZone);
    }

    public Format getTime(TimeZone timeZone) {
        return this.getTime(LocaleUtil.getDefault(), timeZone);
    }

    protected String getKey(Object ... arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 - 1);
        int i2 = 0;
        while (i2 < arguments.length) {
            sb.append(arguments[i2]);
            if (i2 + 1 < arguments.length) {
                sb.append("_");
            }
            ++i2;
        }
        return sb.toString();
    }
}

