/**
 * Copyright (c) 2000-2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.liferay.portletmvc4spring.context;

import org.springframework.web.context.WebApplicationContext;


/**
 * @author  Neil Griffin
 */
public interface PortletApplicationContext extends WebApplicationContext {

	/**
	 * Scope identifier for global session scope: "globalSession". Supported in addition to the standard scopes
	 * "singleton" and "prototype".
	 */
	String SCOPE_GLOBAL_SESSION = "globalSession";
}
