/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.rtf.RtfAddableElement;
import com.lowagie.text.rtf.graphic.RtfImage;
import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.io.OutputStream;

public class RtfShapeProperty
extends RtfAddableElement {
    public static final String PROPERTY_IMAGE = "pib";
    public static final String PROPERTY_VERTICIES = "pVerticies";
    public static final String PROPERTY_GEO_TOP = "geoTop";
    public static final String PROPERTY_GEO_LEFT = "geoLeft";
    public static final String PROPERTY_GEO_RIGHT = "geoRight";
    public static final String PROPERTY_GEO_BOTTOM = "geoBottom";
    public static final String PROPERTY_LAYOUT_IN_CELL = "fLayoutInCell";
    public static final String PROPERTY_FLIP_V = "fFlipV";
    public static final String PROPERTY_FLIP_H = "fFlipH";
    public static final String PROPERTY_FILL_COLOR = "fillColor";
    public static final String PROPERTY_LINE_COLOR = "lineColor";
    public static final String PROPERTY_ADJUST_VALUE = "adjustValue";
    private static final int PROPERTY_TYPE_LONG = 1;
    private static final int PROPERTY_TYPE_BOOLEAN = 2;
    private static final int PROPERTY_TYPE_DOUBLE = 3;
    private static final int PROPERTY_TYPE_COLOR = 4;
    private static final int PROPERTY_TYPE_ARRAY = 5;
    private static final int PROPERTY_TYPE_IMAGE = 6;
    private int type = 0;
    private String name = "";
    private Object value = null;

    private RtfShapeProperty(String string, Object object) {
        this.name = string;
        this.value = object;
    }

    public RtfShapeProperty(String string, long l) {
        this(string, new Long(l));
        this.type = 1;
    }

    public RtfShapeProperty(String string, double d) {
        this(string, new Double(d));
        this.type = 3;
    }

    public RtfShapeProperty(String string, boolean bl) {
        this(string, (Object)bl);
        this.type = 2;
    }

    public RtfShapeProperty(String string, Color color) {
        this(string, (Object)color);
        this.type = 4;
    }

    public RtfShapeProperty(String string, int[] nArray) {
        this(string, (Object)nArray);
        this.type = 5;
    }

    public RtfShapeProperty(String string, Point[] pointArray) {
        this(string, (Object)pointArray);
        this.type = 5;
    }

    public RtfShapeProperty(String string, Image image) {
        this.name = string;
        this.value = image;
        this.type = 6;
    }

    public String getName() {
        return this.name;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write("\\sp".getBytes());
        outputStream.write(OPEN_GROUP);
        outputStream.write("\\sn".getBytes());
        outputStream.write(DELIMITER);
        outputStream.write(this.name.getBytes());
        outputStream.write(CLOSE_GROUP);
        outputStream.write(OPEN_GROUP);
        outputStream.write("\\sv".getBytes());
        outputStream.write(DELIMITER);
        switch (this.type) {
            case 1: 
            case 3: {
                outputStream.write(this.value.toString().getBytes());
                break;
            }
            case 2: {
                if (((Boolean)this.value).booleanValue()) {
                    outputStream.write("1".getBytes());
                    break;
                }
                outputStream.write("0".getBytes());
                break;
            }
            case 4: {
                Color color = (Color)this.value;
                outputStream.write(this.intToByteArray(color.getRed() | color.getGreen() << 8 | color.getBlue() << 16));
                break;
            }
            case 5: {
                if (this.value instanceof int[]) {
                    int[] nArray = (int[])this.value;
                    outputStream.write("4;".getBytes());
                    outputStream.write(this.intToByteArray(nArray.length));
                    outputStream.write(COMMA_DELIMITER);
                    for (int i = 0; i < nArray.length; ++i) {
                        outputStream.write(this.intToByteArray(nArray[i]));
                        if (i >= nArray.length - 1) continue;
                        outputStream.write(COMMA_DELIMITER);
                    }
                } else {
                    if (!(this.value instanceof Point[])) break;
                    Point[] pointArray = (Point[])this.value;
                    outputStream.write("8;".getBytes());
                    outputStream.write(this.intToByteArray(pointArray.length));
                    outputStream.write(COMMA_DELIMITER);
                    for (int i = 0; i < pointArray.length; ++i) {
                        outputStream.write("(".getBytes());
                        outputStream.write(this.intToByteArray(pointArray[i].x));
                        outputStream.write(",".getBytes());
                        outputStream.write(this.intToByteArray(pointArray[i].y));
                        outputStream.write(")".getBytes());
                        if (i >= pointArray.length - 1) continue;
                        outputStream.write(COMMA_DELIMITER);
                    }
                }
                break;
            }
            case 6: {
                Image image = (Image)this.value;
                RtfImage rtfImage = null;
                try {
                    rtfImage = new RtfImage(this.doc, image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter((Exception)((Object)documentException));
                }
                rtfImage.setTopLevelElement(true);
                outputStream.write(OPEN_GROUP);
                rtfImage.writeContent(outputStream);
                outputStream.write(CLOSE_GROUP);
            }
        }
        outputStream.write(CLOSE_GROUP);
        outputStream.write(CLOSE_GROUP);
    }
}

