/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfReaderInstance;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PdfCopy
extends PdfWriter {
    protected HashMap indirects;
    protected HashMap indirectMap;
    protected int currentObjectNum = 1;
    protected PdfReader reader;
    protected PdfIndirectReference acroForm;
    protected PdfIndirectReference topPageParent;
    protected ArrayList pageNumbersToRefs = new ArrayList();
    protected List newBookmarks;

    public PdfCopy(Document document, OutputStream outputStream) throws DocumentException {
        super(new PdfDocument(), outputStream);
        document.addDocListener(this.pdf);
        this.pdf.addWriter(this);
        this.indirectMap = new HashMap();
    }

    public void open() {
        super.open();
        this.topPageParent = this.getPdfIndirectReference();
        this.root.setLinearMode(this.topPageParent);
    }

    public PdfImportedPage getImportedPage(PdfReader pdfReader, int n) {
        if (this.currentPdfReaderInstance != null) {
            if (this.currentPdfReaderInstance.getReader() != pdfReader) {
                try {
                    this.currentPdfReaderInstance.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.currentPdfReaderInstance = pdfReader.getPdfReaderInstance(this);
            }
        } else {
            this.currentPdfReaderInstance = pdfReader.getPdfReaderInstance(this);
        }
        return this.currentPdfReaderInstance.getImportedPage(n);
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference pRIndirectReference) throws IOException, BadPdfFormatException {
        PdfIndirectReference pdfIndirectReference;
        RefKey refKey = new RefKey(pRIndirectReference);
        IndirectReferences indirectReferences = (IndirectReferences)this.indirects.get(refKey);
        if (indirectReferences != null) {
            pdfIndirectReference = indirectReferences.getRef();
            if (indirectReferences.getCopied()) {
                return pdfIndirectReference;
            }
        } else {
            pdfIndirectReference = this.body.getPdfIndirectReference();
            indirectReferences = new IndirectReferences(pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        indirectReferences.setCopied();
        PdfObject pdfObject = this.copyObject(PdfReader.getPdfObject(pRIndirectReference));
        PdfIndirectObject pdfIndirectObject = this.addToBody(pdfObject, pdfIndirectReference);
        return pdfIndirectReference;
    }

    protected PdfDictionary copyDictionary(PdfDictionary pdfDictionary) throws IOException, BadPdfFormatException {
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        PdfName pdfName = (PdfName)pdfDictionary.get(PdfName.TYPE);
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName2 = (PdfName)iterator.next();
            PdfObject pdfObject = pdfDictionary.get(pdfName2);
            if (pdfName2.equals(PdfName.PARENT) && pdfName != null && pdfName.equals(PdfName.PAGE)) {
                pdfDictionary2.put(PdfName.PARENT, this.topPageParent);
                continue;
            }
            pdfDictionary2.put(pdfName2, this.copyObject(pdfObject));
        }
        return pdfDictionary2;
    }

    protected PdfStream copyStream(PRStream pRStream) throws IOException, BadPdfFormatException {
        PRStream pRStream2 = new PRStream(pRStream, null);
        Iterator iterator = pRStream.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = pRStream.get(pdfName);
            pRStream2.put(pdfName, this.copyObject(pdfObject));
        }
        return pRStream2;
    }

    protected PdfArray copyArray(PdfArray pdfArray) throws IOException, BadPdfFormatException {
        PdfArray pdfArray2 = new PdfArray();
        Iterator iterator = pdfArray.getArrayList().iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject = (PdfObject)iterator.next();
            pdfArray2.add(this.copyObject(pdfObject));
        }
        return pdfArray2;
    }

    protected PdfObject copyObject(PdfObject pdfObject) throws IOException, BadPdfFormatException {
        switch (pdfObject.type) {
            case 6: {
                return this.copyDictionary((PdfDictionary)pdfObject);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)pdfObject);
            }
            case 5: {
                return this.copyArray((PdfArray)pdfObject);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return pdfObject;
            }
            case 7: {
                return this.copyStream((PRStream)pdfObject);
            }
        }
        if (pdfObject.type < 0) {
            String string = ((PdfLiteral)pdfObject).toString();
            if (string.equals("true") || string.equals("false")) {
                return new PdfBoolean(string);
            }
            return new PdfLiteral(string);
        }
        System.out.println("CANNOT COPY type " + pdfObject.type);
        return null;
    }

    protected int setFromIPage(PdfImportedPage pdfImportedPage) {
        int n = pdfImportedPage.getPageNumber();
        PdfReaderInstance pdfReaderInstance = this.currentPdfReaderInstance = pdfImportedPage.getPdfReaderInstance();
        this.reader = pdfReaderInstance.getReader();
        this.setFromReader(this.reader);
        return n;
    }

    protected void setFromReader(PdfReader pdfReader) {
        this.reader = pdfReader;
        this.indirects = (HashMap)this.indirectMap.get(pdfReader);
        if (this.indirects == null) {
            this.indirects = new HashMap();
            this.indirectMap.put(pdfReader, this.indirects);
            PdfDictionary pdfDictionary = pdfReader.getCatalog();
            PRIndirectReference pRIndirectReference = (PRIndirectReference)pdfDictionary.get(PdfName.PAGES);
            this.indirects.put(new RefKey(pRIndirectReference), new IndirectReferences(this.topPageParent));
            pRIndirectReference = null;
            PdfObject pdfObject = pdfDictionary.get(PdfName.ACROFORM);
            if (pdfObject == null || pdfObject.type() != 10) {
                return;
            }
            pRIndirectReference = (PRIndirectReference)pdfObject;
            if (this.acroForm == null) {
                this.acroForm = this.body.getPdfIndirectReference();
            }
            this.indirects.put(new RefKey(pRIndirectReference), new IndirectReferences(this.acroForm));
        }
    }

    public void addPage(PdfImportedPage pdfImportedPage) throws IOException, BadPdfFormatException {
        PdfIndirectReference pdfIndirectReference;
        int n = this.setFromIPage(pdfImportedPage);
        PdfDictionary pdfDictionary = this.reader.getPageN(n);
        PRIndirectReference pRIndirectReference = this.reader.getPageOrigRef(n);
        RefKey refKey = new RefKey(pRIndirectReference);
        IndirectReferences indirectReferences = (IndirectReferences)this.indirects.get(refKey);
        if (indirectReferences != null) {
            pdfIndirectReference = indirectReferences.getRef();
        } else {
            pdfIndirectReference = this.body.getPdfIndirectReference();
            indirectReferences = new IndirectReferences(pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        this.pageReferences.add(pdfIndirectReference);
        ++this.currentPageNumber;
        if (!indirectReferences.getCopied()) {
            indirectReferences.setCopied();
            PdfDictionary pdfDictionary2 = this.copyDictionary(pdfDictionary);
            pdfDictionary2.put(PdfName.PARENT, this.topPageParent);
            PdfIndirectObject pdfIndirectObject = this.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
        }
        this.root.addPage(pdfIndirectReference);
        this.pageNumbersToRefs.add(pdfIndirectReference);
    }

    public PdfIndirectReference getPageReference(int n) {
        if (n < 0 || n > this.pageNumbersToRefs.size()) {
            throw new IllegalArgumentException("Invalid page number " + n);
        }
        return (PdfIndirectReference)this.pageNumbersToRefs.get(n - 1);
    }

    public void copyAcroForm(PdfReader pdfReader) throws IOException, BadPdfFormatException {
        PdfIndirectReference pdfIndirectReference;
        RefKey refKey;
        IndirectReferences indirectReferences;
        this.setFromReader(pdfReader);
        PdfDictionary pdfDictionary = pdfReader.getCatalog();
        PRIndirectReference pRIndirectReference = null;
        PdfObject pdfObject = pdfDictionary.get(PdfName.ACROFORM);
        if (pdfObject != null && pdfObject.type() == 10) {
            pRIndirectReference = (PRIndirectReference)pdfObject;
        }
        if ((indirectReferences = (IndirectReferences)this.indirects.get(refKey = new RefKey(pRIndirectReference))) != null) {
            this.acroForm = pdfIndirectReference = indirectReferences.getRef();
        } else {
            this.acroForm = pdfIndirectReference = this.body.getPdfIndirectReference();
            indirectReferences = new IndirectReferences(pdfIndirectReference);
            this.indirects.put(refKey, indirectReferences);
        }
        if (!indirectReferences.getCopied()) {
            indirectReferences.setCopied();
            PdfDictionary pdfDictionary2 = this.copyDictionary((PdfDictionary)PdfReader.getPdfObject(pRIndirectReference));
            PdfIndirectObject pdfIndirectObject = this.addToBody((PdfObject)pdfDictionary2, pdfIndirectReference);
        }
    }

    protected PdfDictionary getCatalog(PdfIndirectReference pdfIndirectReference) {
        try {
            PdfDocument.PdfCatalog pdfCatalog = ((PdfDocument)this.document).getCatalog(pdfIndirectReference);
            if (this.acroForm != null) {
                pdfCatalog.put(PdfName.ACROFORM, this.acroForm);
            }
            if (this.newBookmarks == null || this.newBookmarks.size() == 0) {
                return pdfCatalog;
            }
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfIndirectReference pdfIndirectReference2 = this.getPdfIndirectReference();
            Object[] objectArray = SimpleBookmark.iterateOutlines(this, pdfIndirectReference2, this.newBookmarks, false);
            pdfDictionary.put(PdfName.FIRST, (PdfIndirectReference)objectArray[0]);
            pdfDictionary.put(PdfName.LAST, (PdfIndirectReference)objectArray[1]);
            pdfDictionary.put(PdfName.COUNT, new PdfNumber((Integer)objectArray[2]));
            this.addToBody((PdfObject)pdfDictionary, pdfIndirectReference2);
            pdfCatalog.put(PdfName.OUTLINES, pdfIndirectReference2);
            return pdfCatalog;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void setOutlines(List list) {
        this.newBookmarks = list;
    }

    public synchronized void close() {
        if (this.open) {
            PdfReaderInstance pdfReaderInstance = this.currentPdfReaderInstance;
            this.pdf.close();
            super.close();
            if (pdfReaderInstance != null) {
                try {
                    pdfReaderInstance.getReaderFile().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        return null;
    }

    public PdfIndirectReference add(PdfOutline pdfOutline) {
        return null;
    }

    public void addAnnotation(PdfAnnotation pdfAnnotation) {
    }

    PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        return null;
    }

    protected static class RefKey {
        int num;
        int gen;

        RefKey(int n, int n2) {
            this.num = n;
            this.gen = n2;
        }

        RefKey(PdfIndirectReference pdfIndirectReference) {
            this.num = pdfIndirectReference.getNumber();
            this.gen = pdfIndirectReference.getGeneration();
        }

        RefKey(PRIndirectReference pRIndirectReference) {
            this.num = pRIndirectReference.getNumber();
            this.gen = pRIndirectReference.getGeneration();
        }

        public int hashCode() {
            return (this.gen << 16) + this.num;
        }

        public boolean equals(Object object) {
            RefKey refKey = (RefKey)object;
            return this.gen == refKey.gen && this.num == refKey.num;
        }

        public String toString() {
            return "" + this.num + " " + this.gen;
        }
    }

    static class IndirectReferences {
        PdfIndirectReference theRef;
        boolean hasCopied;

        IndirectReferences(PdfIndirectReference pdfIndirectReference) {
            this.theRef = pdfIndirectReference;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }
    }
}

