/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jaxrs.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jaxrs.JAXRSConfiguration;
import com.lunatech.doclets.jax.jaxrs.model.Resource;
import com.lunatech.doclets.jax.jaxrs.model.ResourceClass;
import com.lunatech.doclets.jax.jaxrs.model.ResourceMethod;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Parameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Path;

public class JAXRSApplication {
    private static final Class<?>[] jaxrsAnnotations = new Class[]{Path.class};
    private List<ResourceMethod> jaxrsMethods = new LinkedList<ResourceMethod>();
    private Resource rootResource;
    private final JAXRSConfiguration conf;

    public JAXRSApplication(JAXRSConfiguration conf) {
        this.conf = conf;
        this.discoverJAXRSResources();
    }

    private void discoverJAXRSResources() {
        ClassDoc[] classes;
        for (ClassDoc klass : classes = this.conf.parentConfiguration.root.classes()) {
            if (Utils.findAnnotatedClass(klass, jaxrsAnnotations) == null) continue;
            this.handleJAXRSClass(klass);
        }
        Collections.sort(this.jaxrsMethods);
        this.filterMethods();
        this.rootResource = this.buildRootResource();
    }

    private void filterMethods() {
        if (this.conf.pathExcludeFilters.isEmpty()) {
            return;
        }
        LinkedList<ResourceMethod> toRemove = new LinkedList<ResourceMethod>();
        for (Pattern regexpFilter : this.conf.pathExcludeFilters) {
            for (ResourceMethod rm : this.jaxrsMethods) {
                if (!regexpFilter.matcher(rm.getPath()).matches()) continue;
                this.conf.parentConfiguration.root.printNotice("Resource method removed: " + rm);
                toRemove.add(rm);
            }
        }
        this.jaxrsMethods.removeAll(toRemove);
    }

    private void handleJAXRSClass(ClassDoc klass) {
        Matcher m;
        if (this.conf.onlyOutputResourcesMatching != null && !(m = this.conf.onlyOutputResourcesMatching.matcher(klass.qualifiedTypeName())).matches()) {
            return;
        }
        this.jaxrsMethods.addAll(new ResourceClass(klass, null).getMethods());
    }

    public Resource getRootResource() {
        return this.rootResource;
    }

    public Resource findResourceClass(ClassDoc cDoc) {
        return this.findResourceClass(cDoc, null, this.rootResource);
    }

    public Resource findResourceForMethod(ClassDoc cDoc, MethodDoc member) {
        return this.findResourceClass(cDoc, member, this.rootResource);
    }

    private Resource findResourceClass(ClassDoc cDoc, MethodDoc mDoc, Resource resource) {
        for (ResourceMethod rMethod : resource.getMethods()) {
            if (!this.isImplementedBy(cDoc, rMethod.getDeclaringClass()) || mDoc != null && !JAXRSApplication.areEqual(mDoc, rMethod.getMethodDoc())) continue;
            return resource;
        }
        for (Resource subResource : resource.getResources().values()) {
            Resource match = this.findResourceClass(cDoc, mDoc, subResource);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    private boolean isImplementedBy(ClassDoc cDoc, ClassDoc declaringClass) {
        if (declaringClass.qualifiedTypeName().equals(cDoc.qualifiedTypeName())) {
            return true;
        }
        if (declaringClass.superclass() != null && this.isImplementedBy(cDoc, declaringClass.superclass())) {
            return true;
        }
        for (ClassDoc intDoc : declaringClass.interfaces()) {
            if (!this.isImplementedBy(cDoc, intDoc)) continue;
            return true;
        }
        return false;
    }

    static boolean areEqual(MethodDoc m1, MethodDoc m2) {
        Parameter[] p2;
        if (!m1.name().equals(m2.name())) {
            return false;
        }
        Parameter[] p1 = m1.parameters();
        if (p1.length != (p2 = m1.parameters()).length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            Parameter pi1 = p1[i];
            Parameter pi2 = p2[i];
            if (pi1.typeName().equals(pi2.typeName())) continue;
            return false;
        }
        return true;
    }

    private Resource buildRootResource() {
        Resource rootResource = new Resource("", null);
        for (ResourceMethod resourceMethod : this.jaxrsMethods) {
            rootResource.addResourceMethod(resourceMethod);
        }
        return rootResource;
    }
}

