/*
 * Decompiled with CFR 0.152.
 */
package com.lunatech.doclets.jax.jpa.model;

import com.lunatech.doclets.jax.Utils;
import com.lunatech.doclets.jax.jpa.model.JPAClass;
import com.lunatech.doclets.jax.jpa.model.JPAMember;
import com.lunatech.doclets.jax.jpa.model.RelationSize;
import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationValue;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import javax.persistence.JoinTable;

public class Relation
extends JPAMember {
    private RelationSize relationFrom;
    private RelationSize relationTo;
    private boolean owning;
    private AnnotationDesc joinTable;
    private String mappedBy;

    public Relation(JPAClass jpaClass, ProgramElementDoc property, String name, AnnotationDesc columnAnnotation, AnnotationDesc relation) {
        super(jpaClass, property, name, columnAnnotation);
        String relationName = relation.annotationType().name();
        this.relationFrom = relationName.equals("OneToMany") || relationName.equals("OneToOne") ? RelationSize.ONE : RelationSize.MANY;
        this.relationTo = relationName.equals("ManyToOne") || relationName.equals("OneToOne") ? RelationSize.ONE : RelationSize.MANY;
        this.mappedBy = (String)Utils.getAnnotationValue(relation, "mappedBy");
        if (this.isManyToMany()) {
            this.joinTable = Utils.findAnnotation(property, JoinTable.class);
            if (this.joinTable != null) {
                this.owning = true;
            } else if (this.mappedBy == null) {
                throw new RuntimeException("Missing mappedBy for non-owning many-to-many: " + this.klass.getName() + "." + name);
            }
        } else {
            this.owning = columnAnnotation != null ? this.mappedBy != null : true;
        }
    }

    private boolean isManyToMany() {
        return this.relationFrom == RelationSize.MANY && this.relationTo == RelationSize.MANY;
    }

    public RelationSize getRelationFrom() {
        return this.relationFrom;
    }

    public RelationSize getRelationTo() {
        return this.relationTo;
    }

    public String getName() {
        String property;
        String table;
        if (!this.isManyToMany()) {
            return super.getName();
        }
        Type target = this.getJavaType();
        JPAClass targetJPA = this.klass.getRegistry().getJPAClass(target.qualifiedTypeName());
        if (!this.owning) {
            Relation inverseRelation = targetJPA.getRelation(this.mappedBy);
            this.joinTable = inverseRelation.joinTable;
        }
        if (this.joinTable == null) {
            table = this.klass.getName() + "_" + target.typeName();
            property = target.typeName();
        } else {
            table = (String)Utils.getAnnotationValue(this.joinTable, "name");
            AnnotationValue[] joinColumns = (AnnotationValue[])Utils.getAnnotationValue(this.joinTable, this.owning ? "joinColumns" : "inverseJoinColumns");
            AnnotationDesc joinColumn = (AnnotationDesc)joinColumns[0].value();
            property = (String)Utils.getAnnotationValue(joinColumn, "name");
        }
        return table + "." + property;
    }
}

