/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.dvcs;

import java.io.IOException;
import org.spongycastle.cms.CMSException;
import org.spongycastle.cms.CMSProcessableByteArray;
import org.spongycastle.cms.CMSSignedData;
import org.spongycastle.cms.CMSSignedDataGenerator;
import org.spongycastle.dvcs.DVCSException;
import org.spongycastle.dvcs.DVCSMessage;

public class SignedDVCSMessageGenerator {
    private final CMSSignedDataGenerator signedDataGen;

    public SignedDVCSMessageGenerator(CMSSignedDataGenerator signedDataGen) {
        this.signedDataGen = signedDataGen;
    }

    public CMSSignedData build(DVCSMessage message) throws DVCSException {
        try {
            byte[] encapsulatedData = message.getContent().toASN1Primitive().getEncoded("DER");
            return this.signedDataGen.generate(new CMSProcessableByteArray(message.getContentType(), encapsulatedData), true);
        }
        catch (CMSException e) {
            throw new DVCSException("Could not sign DVCS request", e);
        }
        catch (IOException e) {
            throw new DVCSException("Could not encode DVCS request", e);
        }
    }
}

