/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.Base64;
import com.mailjet.client.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.json.JSONObject;

public class MailjetRequest {
    private String _path = "/REST";
    private String _resource;
    private String _action;
    private String _alt;
    private Long _id;
    private long _actionId;
    private String _data;
    HashMap<String, String> _filters = new HashMap();
    JSONObject _body = new JSONObject();
    private int _configuration;

    public MailjetRequest(Resource res) {
        this._configuration = 1;
        this._resource = res.getResource();
        this._action = res.getAction();
        this._id = null;
        if (this._resource.equals("send")) {
            this._path = "";
        }
    }

    public MailjetRequest(Resource res, long id) {
        this._resource = res.getResource();
        this._action = res.getAction();
        this._id = id;
        this._configuration = this._action.equals("") ? 2 : 3;
    }

    public MailjetRequest(Resource res, String id) {
        this._resource = res.getResource();
        this._action = res.getAction();
        this._alt = id;
        this._configuration = this._action.equals("") ? 2 : 3;
    }

    public MailjetRequest(Resource res, long id, long actionid) {
        this._resource = res.getResource();
        this._action = res.getAction();
        this._id = id;
        this._actionId = actionid;
        this._configuration = 4;
    }

    public MailjetRequest setData(String path) throws IOException {
        this._data = new String(Files.readAllBytes(Paths.get(path, new String[0])), StandardCharsets.UTF_8);
        System.out.println(this._data);
        return this;
    }

    public MailjetRequest setBody(String json) {
        this._body = new JSONObject(json);
        return this;
    }

    public MailjetRequest setBody(JSONObject json) {
        return this.setBody(json.toString());
    }

    public MailjetRequest setBody(HashMap<String, Object> json) {
        this._body = new JSONObject(json);
        return this;
    }

    public String getBody() {
        return this._data == null ? this._body.toString() : Base64.encode(this._data.getBytes());
    }

    public JSONObject getBodyJSON() {
        return this._body;
    }

    public String getContentType() {
        if ("csvdata".equals(this._action)) {
            return "text:csv";
        }
        if ("csverror".equals(this._action)) {
            return "text/plain";
        }
        return "application/json";
    }

    public String buildUrl() throws MalformedURLException, UnsupportedEncodingException {
        String base = this._path + '/' + this._resource;
        String id = null;
        String url = null;
        if (this._alt != null || this._id != null) {
            String string = id = this._alt != null ? URLEncoder.encode(this._alt, "UTF-8") : this._id.toString();
        }
        if (id == null && !this._action.equals("")) {
            url = base + '/' + this._action;
        } else if (this._action.equals("managemanycontacts") && id != null) {
            url = base + '/' + this._action + '/' + id;
        } else if (this._configuration == 1) {
            url = base;
        } else if (this._configuration == 2) {
            url = base + '/' + id;
        } else if (this._configuration == 3) {
            url = base + '/' + id + '/' + this._action;
        } else if (this._configuration == 4) {
            url = base + '/' + id + '/' + this._action + '/' + this._actionId;
        }
        return url;
    }

    public MailjetRequest append(String key, Object value) {
        this._body.append(key, value);
        return this;
    }

    public MailjetRequest filter(String key, String value) {
        this._filters.put(key, value);
        return this;
    }

    public MailjetRequest filter(String key, int value) {
        return this.filter(key, String.valueOf(value));
    }

    public String queryString() throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (String key : this._filters.keySet()) {
            String value = this._filters.get(key);
            if (sb.length() > 0) {
                sb.append('&');
            }
            if (sb.length() == 0) {
                sb.append('?');
            }
            sb.append(URLEncoder.encode(key, "UTF-8")).append('=').append(value.replace(' ', '+'));
        }
        return sb.toString();
    }

    public MailjetRequest property(String key, Object value) {
        this._body.put(key, value);
        return this;
    }

    public String toString() {
        return new JSONObject().put("Resource", (Object)this._resource).put("ID", (Object)this._id).put("Action", (Object)this._action).put("Action ID", this._actionId).put("Filters", (Object)this._filters.toString()).put("Body", (Object)this._body.toString()).toString();
    }
}

