/*
 * Decompiled with CFR 0.152.
 */
package com.mailjet.client;

import com.mailjet.client.errors.MailjetException;
import org.json.JSONArray;
import org.json.JSONObject;

public class MailjetResponse {
    private JSONObject _rawResponse;
    private int _status;

    public MailjetResponse(int status, JSONObject obj) {
        this._rawResponse = obj;
        this._status = status;
    }

    public MailjetResponse(JSONObject object) {
        this._rawResponse = object;
        this._status = 0;
    }

    public int getStatus() {
        return this._status;
    }

    public JSONArray getData() {
        if (this._rawResponse.has("Data")) {
            return this._rawResponse.getJSONArray("Data");
        }
        if (this._rawResponse.has("Sent")) {
            return this._rawResponse.getJSONArray("Sent");
        }
        if (this._rawResponse.has("Messages")) {
            return this._rawResponse.getJSONArray("Messages");
        }
        return new JSONArray();
    }

    public int getTotal() {
        if (this._rawResponse.has("Total")) {
            return this._rawResponse.getInt("Total");
        }
        return 0;
    }

    public String getString(String key) throws MailjetException {
        try {
            return this._rawResponse.getString(key);
        }
        catch (NullPointerException e) {
            throw new MailjetException("No entry found for key: " + key);
        }
    }

    public int getInt(String key) throws MailjetException {
        try {
            return this._rawResponse.getInt(key);
        }
        catch (NullPointerException e) {
            throw new MailjetException("No entry found for key: " + key);
        }
    }

    public JSONArray getJSONArray(String key) throws MailjetException {
        try {
            return this._rawResponse.getJSONArray(key);
        }
        catch (NullPointerException e) {
            throw new MailjetException("No entry found for key: " + key);
        }
    }

    public int getCount() {
        if (this._rawResponse.has("Count")) {
            return this._rawResponse.getInt("Count");
        }
        return 0;
    }
}

