/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.util;

import com.microsoft.applicationinsights.internal.util.LocalStringsUtils;
import java.util.Date;
import java.util.Map;

public class MapUtil {
    public static <V> void copy(Map<String, V> source, Map<String, V> target) {
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        if (source == null || source.isEmpty()) {
            return;
        }
        for (Map.Entry<String, V> entry : source.entrySet()) {
            String key = entry.getKey();
            if (LocalStringsUtils.isNullOrEmpty(key) || target.containsKey(key) || entry.getValue() == null) continue;
            target.put(key, entry.getValue());
        }
    }

    public static <K, V> V getValueOrNull(Map<K, V> map, K key) {
        return map.get(key);
    }

    public static void setStringValueOrRemove(Map<String, String> map, String key, String value) {
        if (LocalStringsUtils.isNullOrEmpty(value)) {
            map.remove(key);
        } else {
            map.put(key, value);
        }
    }

    public static void setBoolValueOrRemove(Map<String, String> map, String key, Boolean value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, value != false ? "true" : "false");
        }
    }

    public static void setDateValueOrRemove(Map<String, String> map, String key, Date value) {
        if (value == null) {
            map.remove(key);
        } else {
            map.put(key, LocalStringsUtils.formatDate(value));
        }
    }

    private MapUtil() {
    }
}

