/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.appservice.AppServiceCertificateOrderPatchResource;
import com.microsoft.azure.management.appservice.AppServiceCertificatePatchResource;
import com.microsoft.azure.management.appservice.DefaultErrorResponseException;
import com.microsoft.azure.management.appservice.ReissueCertificateOrderRequest;
import com.microsoft.azure.management.appservice.RenewCertificateOrderRequest;
import com.microsoft.azure.management.appservice.SiteSealRequest;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateOrderInner;
import com.microsoft.azure.management.appservice.implementation.AppServiceCertificateResourceInner;
import com.microsoft.azure.management.appservice.implementation.CertificateEmailInner;
import com.microsoft.azure.management.appservice.implementation.CertificateOrderActionInner;
import com.microsoft.azure.management.appservice.implementation.NameIdentifierInner;
import com.microsoft.azure.management.appservice.implementation.PageImpl;
import com.microsoft.azure.management.appservice.implementation.SiteSealInner;
import com.microsoft.azure.management.appservice.implementation.WebSiteManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AppServiceCertificateOrdersInner
implements InnerSupportsGet<AppServiceCertificateOrderInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<AppServiceCertificateOrderInner> {
    private AppServiceCertificateOrdersService service;
    private WebSiteManagementClientImpl client;

    public AppServiceCertificateOrdersInner(Retrofit retrofit, WebSiteManagementClientImpl client) {
        this.service = (AppServiceCertificateOrdersService)retrofit.create(AppServiceCertificateOrdersService.class);
        this.client = client;
    }

    public PagedList<AppServiceCertificateOrderInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>((Page)response.body()){

            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AppServiceCertificateOrdersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AppServiceCertificateOrderInner>> listAsync(ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                return AppServiceCertificateOrdersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AppServiceCertificateOrderInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>(){

            public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AppServiceCertificateOrdersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AppServiceCertificateOrdersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void validatePurchaseInformation(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        ((ServiceResponse)this.validatePurchaseInformationWithServiceResponseAsync(appServiceCertificateOrder).toBlocking().single()).body();
    }

    public ServiceFuture<Void> validatePurchaseInformationAsync(AppServiceCertificateOrderInner appServiceCertificateOrder, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.validatePurchaseInformationWithServiceResponseAsync(appServiceCertificateOrder), serviceCallback);
    }

    public Observable<Void> validatePurchaseInformationAsync(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        return this.validatePurchaseInformationWithServiceResponseAsync(appServiceCertificateOrder).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> validatePurchaseInformationWithServiceResponseAsync(AppServiceCertificateOrderInner appServiceCertificateOrder) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (appServiceCertificateOrder == null) {
            throw new IllegalArgumentException("Parameter appServiceCertificateOrder is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)appServiceCertificateOrder));
        return this.service.validatePurchaseInformation(this.client.subscriptionId(), appServiceCertificateOrder, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.validatePurchaseInformationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> validatePurchaseInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AppServiceCertificateOrderInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>((Page)response.body()){

            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AppServiceCertificateOrdersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AppServiceCertificateOrderInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                return AppServiceCertificateOrdersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AppServiceCertificateOrderInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>(){

            public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AppServiceCertificateOrdersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AppServiceCertificateOrdersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public AppServiceCertificateOrderInner getByResourceGroup(String resourceGroupName, String certificateOrderName) {
        return (AppServiceCertificateOrderInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single()).body());
    }

    public ServiceFuture<AppServiceCertificateOrderInner> getByResourceGroupAsync(String resourceGroupName, String certificateOrderName, ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    public Observable<AppServiceCertificateOrderInner> getByResourceGroupAsync(String resourceGroupName, String certificateOrderName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, certificateOrderName).map((Func1)new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>(){

            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return (AppServiceCertificateOrderInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateOrderInner>>>(){

            public Observable<ServiceResponse<AppServiceCertificateOrderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AppServiceCertificateOrderInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AppServiceCertificateOrderInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public AppServiceCertificateOrderInner createOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return (AppServiceCertificateOrderInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).toBlocking().last()).body());
    }

    public ServiceFuture<AppServiceCertificateOrderInner> createOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName), serviceCallback);
    }

    public Observable<AppServiceCertificateOrderInner> createOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).map((Func1)new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>(){

            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return (AppServiceCertificateOrderInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (certificateDistinguishedName == null) {
            throw new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)certificateDistinguishedName));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, certificateOrderName, this.client.subscriptionId(), certificateDistinguishedName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AppServiceCertificateOrderInner>(){}.getType());
    }

    public AppServiceCertificateOrderInner beginCreateOrUpdate(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return (AppServiceCertificateOrderInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).toBlocking().single()).body());
    }

    public ServiceFuture<AppServiceCertificateOrderInner> beginCreateOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName, ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName), serviceCallback);
    }

    public Observable<AppServiceCertificateOrderInner> beginCreateOrUpdateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).map((Func1)new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>(){

            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return (AppServiceCertificateOrderInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderInner certificateDistinguishedName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (certificateDistinguishedName == null) {
            throw new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)certificateDistinguishedName));
        return this.service.beginCreateOrUpdate(resourceGroupName, certificateOrderName, this.client.subscriptionId(), certificateDistinguishedName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateOrderInner>>>(){

            public Observable<ServiceResponse<AppServiceCertificateOrderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AppServiceCertificateOrderInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AppServiceCertificateOrderInner>(){}.getType()).register(201, new TypeToken<AppServiceCertificateOrderInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void delete(String resourceGroupName, String certificateOrderName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String certificateOrderName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String certificateOrderName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, certificateOrderName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AppServiceCertificateOrderInner update(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        return (AppServiceCertificateOrderInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).toBlocking().single()).body());
    }

    public ServiceFuture<AppServiceCertificateOrderInner> updateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName, ServiceCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName), serviceCallback);
    }

    public Observable<AppServiceCertificateOrderInner> updateAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, certificateOrderName, certificateDistinguishedName).map((Func1)new Func1<ServiceResponse<AppServiceCertificateOrderInner>, AppServiceCertificateOrderInner>(){

            public AppServiceCertificateOrderInner call(ServiceResponse<AppServiceCertificateOrderInner> response) {
                return (AppServiceCertificateOrderInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateOrderInner>> updateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, AppServiceCertificateOrderPatchResource certificateDistinguishedName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (certificateDistinguishedName == null) {
            throw new IllegalArgumentException("Parameter certificateDistinguishedName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)certificateDistinguishedName));
        return this.service.update(resourceGroupName, certificateOrderName, this.client.subscriptionId(), certificateDistinguishedName, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateOrderInner>>>(){

            public Observable<ServiceResponse<AppServiceCertificateOrderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AppServiceCertificateOrderInner> updateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AppServiceCertificateOrderInner>(){}.getType()).register(201, new TypeToken<AppServiceCertificateOrderInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<AppServiceCertificateResourceInner> listCertificates(String resourceGroupName, String certificateOrderName) {
        ServiceResponse response = (ServiceResponse)this.listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName).toBlocking().single();
        return new PagedList<AppServiceCertificateResourceInner>((Page)response.body()){

            public Page<AppServiceCertificateResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AppServiceCertificateOrdersInner.this.listCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AppServiceCertificateResourceInner>> listCertificatesAsync(String resourceGroupName, String certificateOrderName, ListOperationCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName), (Func1)new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(String nextPageLink) {
                return AppServiceCertificateOrdersInner.this.listCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AppServiceCertificateResourceInner>> listCertificatesAsync(String resourceGroupName, String certificateOrderName) {
        return this.listCertificatesWithServiceResponseAsync(resourceGroupName, certificateOrderName).map((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Page<AppServiceCertificateResourceInner>>(){

            public Page<AppServiceCertificateResourceInner> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        return this.listCertificatesSinglePageAsync(resourceGroupName, certificateOrderName).concatMap((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AppServiceCertificateOrdersInner.this.listCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesSinglePageAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listCertificates(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AppServiceCertificateOrdersInner.this.listCertificatesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> listCertificatesDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AppServiceCertificateResourceInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public AppServiceCertificateResourceInner getCertificate(String resourceGroupName, String certificateOrderName, String name) {
        return (AppServiceCertificateResourceInner)((Object)((ServiceResponse)this.getCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).toBlocking().single()).body());
    }

    public ServiceFuture<AppServiceCertificateResourceInner> getCertificateAsync(String resourceGroupName, String certificateOrderName, String name, ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name), serviceCallback);
    }

    public Observable<AppServiceCertificateResourceInner> getCertificateAsync(String resourceGroupName, String certificateOrderName, String name) {
        return this.getCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).map((Func1)new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>(){

            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return (AppServiceCertificateResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> getCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateResourceInner>>>(){

            public Observable<ServiceResponse<AppServiceCertificateResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.getCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AppServiceCertificateResourceInner> getCertificateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AppServiceCertificateResourceInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public AppServiceCertificateResourceInner createOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return (AppServiceCertificateResourceInner)((Object)((ServiceResponse)this.createOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).toBlocking().last()).body());
    }

    public ServiceFuture<AppServiceCertificateResourceInner> createOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate), serviceCallback);
    }

    public Observable<AppServiceCertificateResourceInner> createOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return this.createOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).map((Func1)new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>(){

            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return (AppServiceCertificateResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> createOrUpdateCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (keyVaultCertificate == null) {
            throw new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)keyVaultCertificate));
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdateCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), keyVaultCertificate, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<AppServiceCertificateResourceInner>(){}.getType());
    }

    public AppServiceCertificateResourceInner beginCreateOrUpdateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return (AppServiceCertificateResourceInner)((Object)((ServiceResponse)this.beginCreateOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).toBlocking().single()).body());
    }

    public ServiceFuture<AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate, ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate), serviceCallback);
    }

    public Observable<AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        return this.beginCreateOrUpdateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).map((Func1)new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>(){

            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return (AppServiceCertificateResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> beginCreateOrUpdateCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificateResourceInner keyVaultCertificate) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (keyVaultCertificate == null) {
            throw new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)keyVaultCertificate));
        return this.service.beginCreateOrUpdateCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), keyVaultCertificate, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateResourceInner>>>(){

            public Observable<ServiceResponse<AppServiceCertificateResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.beginCreateOrUpdateCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AppServiceCertificateResourceInner> beginCreateOrUpdateCertificateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AppServiceCertificateResourceInner>(){}.getType()).register(201, new TypeToken<AppServiceCertificateResourceInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void deleteCertificate(String resourceGroupName, String certificateOrderName, String name) {
        ((ServiceResponse)this.deleteCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteCertificateAsync(String resourceGroupName, String certificateOrderName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name), serviceCallback);
    }

    public Observable<Void> deleteCertificateAsync(String resourceGroupName, String certificateOrderName, String name) {
        return this.deleteCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.deleteCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.deleteCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteCertificateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public AppServiceCertificateResourceInner updateCertificate(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate) {
        return (AppServiceCertificateResourceInner)((Object)((ServiceResponse)this.updateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).toBlocking().single()).body());
    }

    public ServiceFuture<AppServiceCertificateResourceInner> updateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate, ServiceCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate), serviceCallback);
    }

    public Observable<AppServiceCertificateResourceInner> updateCertificateAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate) {
        return this.updateCertificateWithServiceResponseAsync(resourceGroupName, certificateOrderName, name, keyVaultCertificate).map((Func1)new Func1<ServiceResponse<AppServiceCertificateResourceInner>, AppServiceCertificateResourceInner>(){

            public AppServiceCertificateResourceInner call(ServiceResponse<AppServiceCertificateResourceInner> response) {
                return (AppServiceCertificateResourceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<AppServiceCertificateResourceInner>> updateCertificateWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name, AppServiceCertificatePatchResource keyVaultCertificate) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (keyVaultCertificate == null) {
            throw new IllegalArgumentException("Parameter keyVaultCertificate is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)keyVaultCertificate));
        return this.service.updateCertificate(resourceGroupName, certificateOrderName, name, this.client.subscriptionId(), keyVaultCertificate, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<AppServiceCertificateResourceInner>>>(){

            public Observable<ServiceResponse<AppServiceCertificateResourceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.updateCertificateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<AppServiceCertificateResourceInner> updateCertificateDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AppServiceCertificateResourceInner>(){}.getType()).register(201, new TypeToken<AppServiceCertificateResourceInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void reissue(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        ((ServiceResponse)this.reissueWithServiceResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest).toBlocking().single()).body();
    }

    public ServiceFuture<Void> reissueAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.reissueWithServiceResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest), serviceCallback);
    }

    public Observable<Void> reissueAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        return this.reissueWithServiceResponseAsync(resourceGroupName, certificateOrderName, reissueCertificateOrderRequest).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> reissueWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, ReissueCertificateOrderRequest reissueCertificateOrderRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (reissueCertificateOrderRequest == null) {
            throw new IllegalArgumentException("Parameter reissueCertificateOrderRequest is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)reissueCertificateOrderRequest));
        return this.service.reissue(resourceGroupName, certificateOrderName, this.client.subscriptionId(), reissueCertificateOrderRequest, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.reissueDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> reissueDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void renew(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        ((ServiceResponse)this.renewWithServiceResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest).toBlocking().single()).body();
    }

    public ServiceFuture<Void> renewAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.renewWithServiceResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest), serviceCallback);
    }

    public Observable<Void> renewAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        return this.renewWithServiceResponseAsync(resourceGroupName, certificateOrderName, renewCertificateOrderRequest).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> renewWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, RenewCertificateOrderRequest renewCertificateOrderRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (renewCertificateOrderRequest == null) {
            throw new IllegalArgumentException("Parameter renewCertificateOrderRequest is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)renewCertificateOrderRequest));
        return this.service.renew(resourceGroupName, certificateOrderName, this.client.subscriptionId(), renewCertificateOrderRequest, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.renewDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> renewDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resendEmail(String resourceGroupName, String certificateOrderName) {
        ((ServiceResponse)this.resendEmailWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> resendEmailAsync(String resourceGroupName, String certificateOrderName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resendEmailWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    public Observable<Void> resendEmailAsync(String resourceGroupName, String certificateOrderName) {
        return this.resendEmailWithServiceResponseAsync(resourceGroupName, certificateOrderName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resendEmailWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.resendEmail(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.resendEmailDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resendEmailDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void resendRequestEmails(String resourceGroupName, String certificateOrderName) {
        ((ServiceResponse)this.resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    public Observable<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName) {
        return this.resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resendRequestEmailsWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object name = null;
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(null);
        return this.service.resendRequestEmails(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), nameIdentifier, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.resendRequestEmailsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void resendRequestEmails(String resourceGroupName, String certificateOrderName, String name) {
        ((ServiceResponse)this.resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).toBlocking().single()).body();
    }

    public ServiceFuture<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, String name, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName, name), serviceCallback);
    }

    public Observable<Void> resendRequestEmailsAsync(String resourceGroupName, String certificateOrderName, String name) {
        return this.resendRequestEmailsWithServiceResponseAsync(resourceGroupName, certificateOrderName, name).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> resendRequestEmailsWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        NameIdentifierInner nameIdentifier = new NameIdentifierInner();
        nameIdentifier.withName(name);
        return this.service.resendRequestEmails(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), nameIdentifier, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.resendRequestEmailsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> resendRequestEmailsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SiteSealInner retrieveSiteSeal(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        return (SiteSealInner)((ServiceResponse)this.retrieveSiteSealWithServiceResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest).toBlocking().single()).body();
    }

    public ServiceFuture<SiteSealInner> retrieveSiteSealAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest, ServiceCallback<SiteSealInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.retrieveSiteSealWithServiceResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest), serviceCallback);
    }

    public Observable<SiteSealInner> retrieveSiteSealAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        return this.retrieveSiteSealWithServiceResponseAsync(resourceGroupName, certificateOrderName, siteSealRequest).map((Func1)new Func1<ServiceResponse<SiteSealInner>, SiteSealInner>(){

            public SiteSealInner call(ServiceResponse<SiteSealInner> response) {
                return (SiteSealInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<SiteSealInner>> retrieveSiteSealWithServiceResponseAsync(String resourceGroupName, String certificateOrderName, SiteSealRequest siteSealRequest) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (siteSealRequest == null) {
            throw new IllegalArgumentException("Parameter siteSealRequest is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)siteSealRequest);
        return this.service.retrieveSiteSeal(resourceGroupName, certificateOrderName, this.client.subscriptionId(), siteSealRequest, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SiteSealInner>>>(){

            public Observable<ServiceResponse<SiteSealInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.retrieveSiteSealDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SiteSealInner> retrieveSiteSealDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SiteSealInner>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public void verifyDomainOwnership(String resourceGroupName, String certificateOrderName) {
        ((ServiceResponse)this.verifyDomainOwnershipWithServiceResponseAsync(resourceGroupName, certificateOrderName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> verifyDomainOwnershipAsync(String resourceGroupName, String certificateOrderName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.verifyDomainOwnershipWithServiceResponseAsync(resourceGroupName, certificateOrderName), serviceCallback);
    }

    public Observable<Void> verifyDomainOwnershipAsync(String resourceGroupName, String certificateOrderName) {
        return this.verifyDomainOwnershipWithServiceResponseAsync(resourceGroupName, certificateOrderName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> verifyDomainOwnershipWithServiceResponseAsync(String resourceGroupName, String certificateOrderName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (certificateOrderName == null) {
            throw new IllegalArgumentException("Parameter certificateOrderName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.verifyDomainOwnership(resourceGroupName, certificateOrderName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.verifyDomainOwnershipDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> verifyDomainOwnershipDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public List<CertificateOrderActionInner> retrieveCertificateActions(String resourceGroupName, String name) {
        return (List)((ServiceResponse)this.retrieveCertificateActionsWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body();
    }

    public ServiceFuture<List<CertificateOrderActionInner>> retrieveCertificateActionsAsync(String resourceGroupName, String name, ServiceCallback<List<CertificateOrderActionInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.retrieveCertificateActionsWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<List<CertificateOrderActionInner>> retrieveCertificateActionsAsync(String resourceGroupName, String name) {
        return this.retrieveCertificateActionsWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<List<CertificateOrderActionInner>>, List<CertificateOrderActionInner>>(){

            public List<CertificateOrderActionInner> call(ServiceResponse<List<CertificateOrderActionInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CertificateOrderActionInner>>> retrieveCertificateActionsWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.retrieveCertificateActions(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CertificateOrderActionInner>>>>(){

            public Observable<ServiceResponse<List<CertificateOrderActionInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.retrieveCertificateActionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<CertificateOrderActionInner>> retrieveCertificateActionsDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<CertificateOrderActionInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public List<CertificateEmailInner> retrieveCertificateEmailHistory(String resourceGroupName, String name) {
        return (List)((ServiceResponse)this.retrieveCertificateEmailHistoryWithServiceResponseAsync(resourceGroupName, name).toBlocking().single()).body();
    }

    public ServiceFuture<List<CertificateEmailInner>> retrieveCertificateEmailHistoryAsync(String resourceGroupName, String name, ServiceCallback<List<CertificateEmailInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.retrieveCertificateEmailHistoryWithServiceResponseAsync(resourceGroupName, name), serviceCallback);
    }

    public Observable<List<CertificateEmailInner>> retrieveCertificateEmailHistoryAsync(String resourceGroupName, String name) {
        return this.retrieveCertificateEmailHistoryWithServiceResponseAsync(resourceGroupName, name).map((Func1)new Func1<ServiceResponse<List<CertificateEmailInner>>, List<CertificateEmailInner>>(){

            public List<CertificateEmailInner> call(ServiceResponse<List<CertificateEmailInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<CertificateEmailInner>>> retrieveCertificateEmailHistoryWithServiceResponseAsync(String resourceGroupName, String name) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.retrieveCertificateEmailHistory(resourceGroupName, name, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<CertificateEmailInner>>>>(){

            public Observable<ServiceResponse<List<CertificateEmailInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = AppServiceCertificateOrdersInner.this.retrieveCertificateEmailHistoryDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<CertificateEmailInner>> retrieveCertificateEmailHistoryDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<CertificateEmailInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<AppServiceCertificateOrderInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>((Page)response.body()){

            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AppServiceCertificateOrdersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AppServiceCertificateOrderInner>> listNextAsync(String nextPageLink, ServiceFuture<List<AppServiceCertificateOrderInner>> serviceFuture, ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                return AppServiceCertificateOrdersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AppServiceCertificateOrderInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>(){

            public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AppServiceCertificateOrdersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AppServiceCertificateOrdersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<AppServiceCertificateOrderInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceCertificateOrderInner>((Page)response.body()){

            public Page<AppServiceCertificateOrderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AppServiceCertificateOrdersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AppServiceCertificateOrderInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<AppServiceCertificateOrderInner>> serviceFuture, ListOperationCallback<AppServiceCertificateOrderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(String nextPageLink) {
                return AppServiceCertificateOrdersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AppServiceCertificateOrderInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Page<AppServiceCertificateOrderInner>>(){

            public Page<AppServiceCertificateOrderInner> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateOrderInner>>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(ServiceResponse<Page<AppServiceCertificateOrderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AppServiceCertificateOrdersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateOrderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AppServiceCertificateOrdersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateOrderInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AppServiceCertificateOrderInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    public PagedList<AppServiceCertificateResourceInner> listCertificatesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AppServiceCertificateResourceInner>((Page)response.body()){

            public Page<AppServiceCertificateResourceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AppServiceCertificateOrdersInner.this.listCertificatesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AppServiceCertificateResourceInner>> listCertificatesNextAsync(String nextPageLink, ServiceFuture<List<AppServiceCertificateResourceInner>> serviceFuture, ListOperationCallback<AppServiceCertificateResourceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listCertificatesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(String nextPageLink) {
                return AppServiceCertificateOrdersInner.this.listCertificatesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AppServiceCertificateResourceInner>> listCertificatesNextAsync(String nextPageLink) {
        return this.listCertificatesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Page<AppServiceCertificateResourceInner>>(){

            public Page<AppServiceCertificateResourceInner> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listCertificatesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AppServiceCertificateResourceInner>>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(ServiceResponse<Page<AppServiceCertificateResourceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AppServiceCertificateOrdersInner.this.listCertificatesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> listCertificatesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listCertificatesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>>>(){

            public Observable<ServiceResponse<Page<AppServiceCertificateResourceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AppServiceCertificateOrdersInner.this.listCertificatesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AppServiceCertificateResourceInner>> listCertificatesNextDelegate(Response<ResponseBody> response) throws DefaultErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AppServiceCertificateResourceInner>>(){}.getType()).registerError(DefaultErrorResponseException.class).build(response);
    }

    static interface AppServiceCertificateOrdersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/certificateOrders")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders validatePurchaseInformation"})
        @POST(value="subscriptions/{subscriptionId}/providers/Microsoft.CertificateRegistration/validateCertificateRegistrationInformation")
        public Observable<Response<ResponseBody>> validatePurchaseInformation(@Path(value="subscriptionId") String var1, @Body AppServiceCertificateOrderInner var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Body AppServiceCertificateOrderInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Body AppServiceCertificateOrderInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Body AppServiceCertificateOrderPatchResource var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listCertificates"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates")
        public Observable<Response<ResponseBody>> listCertificates(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders getCertificate"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        public Observable<Response<ResponseBody>> getCertificate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders createOrUpdateCertificate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        public Observable<Response<ResponseBody>> createOrUpdateCertificate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Body AppServiceCertificateResourceInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders beginCreateOrUpdateCertificate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdateCertificate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Body AppServiceCertificateResourceInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders deleteCertificate"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteCertificate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders updateCertificate"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/certificates/{name}")
        public Observable<Response<ResponseBody>> updateCertificate(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="name") String var3, @Path(value="subscriptionId") String var4, @Body AppServiceCertificatePatchResource var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders reissue"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/reissue")
        public Observable<Response<ResponseBody>> reissue(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Body ReissueCertificateOrderRequest var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders renew"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/renew")
        public Observable<Response<ResponseBody>> renew(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Body RenewCertificateOrderRequest var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders resendEmail"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendEmail")
        public Observable<Response<ResponseBody>> resendEmail(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders resendRequestEmails"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/resendRequestEmails")
        public Observable<Response<ResponseBody>> resendRequestEmails(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body NameIdentifierInner var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders retrieveSiteSeal"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/retrieveSiteSeal")
        public Observable<Response<ResponseBody>> retrieveSiteSeal(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Body SiteSealRequest var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders verifyDomainOwnership"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{certificateOrderName}/verifyDomainOwnership")
        public Observable<Response<ResponseBody>> verifyDomainOwnership(@Path(value="resourceGroupName") String var1, @Path(value="certificateOrderName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders retrieveCertificateActions"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveCertificateActions")
        public Observable<Response<ResponseBody>> retrieveCertificateActions(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders retrieveCertificateEmailHistory"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CertificateRegistration/certificateOrders/{name}/retrieveEmailHistory")
        public Observable<Response<ResponseBody>> retrieveCertificateEmailHistory(@Path(value="resourceGroupName") String var1, @Path(value="name") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.appservice.AppServiceCertificateOrders listCertificatesNext"})
        @GET
        public Observable<Response<ResponseBody>> listCertificatesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

