/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.DeploymentSlot;
import com.microsoft.azure.management.appservice.WebApp;
import com.microsoft.azure.management.appservice.implementation.DeploymentSlotBaseImpl;
import com.microsoft.azure.management.appservice.implementation.KuduClient;
import com.microsoft.azure.management.appservice.implementation.SiteConfigResourceInner;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.appservice.implementation.WebAppImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import rx.Completable;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
class DeploymentSlotImpl
extends DeploymentSlotBaseImpl<DeploymentSlot, DeploymentSlotImpl, WebAppImpl, DeploymentSlot.DefinitionStages.WithCreate, DeploymentSlot.Update>
implements DeploymentSlot,
DeploymentSlot.Definition,
DeploymentSlot.Update {
    private KuduClient kuduClient = new KuduClient(this);

    DeploymentSlotImpl(String name, SiteInner innerObject, SiteConfigResourceInner configObject, WebAppImpl parent) {
        super(name, innerObject, configObject, parent);
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromParent() {
        return this.withConfigurationFromWebApp((WebApp)this.parent());
    }

    @Override
    public DeploymentSlotImpl withConfigurationFromWebApp(WebApp webApp) {
        this.siteConfig = ((WebAppBaseImpl)((Object)webApp)).siteConfig;
        this.configurationSource = webApp;
        return this;
    }

    @Override
    public Completable warDeployAsync(File warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(File warFile) {
        this.warDeployAsync(warFile).await();
    }

    @Override
    public Completable warDeployAsync(InputStream warFile) {
        return this.warDeployAsync(warFile, null);
    }

    @Override
    public void warDeploy(InputStream warFile) {
        this.warDeployAsync(warFile).await();
    }

    @Override
    public Completable warDeployAsync(File warFile, String appName) {
        try {
            return this.warDeployAsync(new FileInputStream(warFile), appName);
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    public void warDeploy(File warFile, String appName) {
        this.warDeployAsync(warFile, appName).await();
    }

    @Override
    public Completable warDeployAsync(InputStream warFile, String appName) {
        return this.kuduClient.warDeployAsync(warFile, appName);
    }

    @Override
    public void warDeploy(InputStream warFile, String appName) {
        this.warDeployAsync(warFile, appName).await();
    }

    @Override
    public void zipDeploy(File zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    public void zipDeploy(InputStream zipFile) {
        this.zipDeployAsync(zipFile).await();
    }

    @Override
    public Completable zipDeployAsync(InputStream zipFile) {
        return this.kuduClient.zipDeployAsync(zipFile).concatWith(this.stopAsync()).concatWith(this.startAsync());
    }

    @Override
    public Completable zipDeployAsync(File zipFile) {
        try {
            return this.zipDeployAsync(new FileInputStream(zipFile));
        }
        catch (IOException e) {
            return Completable.error((Throwable)e);
        }
    }
}

