/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.arm;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import java.security.InvalidParameterException;
import org.apache.commons.lang3.StringUtils;

@LangDefinition
public final class ResourceId {
    private String subscriptionId = null;
    private String resourceGroupName = null;
    private String name = null;
    private String providerNamespace = null;
    private String resourceType = null;
    private String id = null;
    private String parentId = null;

    private static String badIdErrorText(String id) {
        return String.format("The specified ID `%s` is not a valid Azure resource ID.", id);
    }

    private ResourceId(String id) {
        String[] splits;
        if (id == null) {
            return;
        }
        String[] stringArray = splits = id.startsWith("/") ? id.substring(1).split("/") : id.split("/");
        if (splits.length % 2 == 1) {
            throw new InvalidParameterException(ResourceId.badIdErrorText(id));
        }
        this.id = id;
        if (splits.length < 2) {
            throw new InvalidParameterException(ResourceId.badIdErrorText(id));
        }
        this.name = splits[splits.length - 1];
        this.resourceType = splits[splits.length - 2];
        if (splits.length < 10) {
            this.parentId = null;
        } else {
            Object[] parentSplits = new String[splits.length - 2];
            System.arraycopy(splits, 0, parentSplits, 0, splits.length - 2);
            this.parentId = "/" + StringUtils.join((Object[])parentSplits, (String)"/");
        }
        block8: for (int i = 0; i < splits.length && i < 6; ++i) {
            switch (i) {
                case 0: {
                    if (splits[i].equalsIgnoreCase("subscriptions")) continue block8;
                    throw new InvalidParameterException(ResourceId.badIdErrorText(id));
                }
                case 1: {
                    this.subscriptionId = splits[i];
                    continue block8;
                }
                case 2: {
                    if (splits[i].equalsIgnoreCase("resourceGroups")) continue block8;
                    throw new InvalidParameterException(ResourceId.badIdErrorText(id));
                }
                case 3: {
                    this.resourceGroupName = splits[i];
                    continue block8;
                }
                case 4: {
                    if (splits[i].equalsIgnoreCase("providers")) continue block8;
                    throw new InvalidParameterException(ResourceId.badIdErrorText(id));
                }
                case 5: {
                    this.providerNamespace = splits[i];
                    continue block8;
                }
            }
        }
    }

    public static ResourceId fromString(String id) {
        return new ResourceId(id);
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String name() {
        return this.name;
    }

    public ResourceId parent() {
        if (this.id == null || this.parentId == null) {
            return null;
        }
        return ResourceId.fromString(this.parentId);
    }

    public String providerNamespace() {
        return this.providerNamespace;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String fullResourceType() {
        if (this.parentId == null) {
            return this.providerNamespace + "/" + this.resourceType;
        }
        return this.parent().fullResourceType() + "/" + this.resourceType;
    }

    public String id() {
        return this.id;
    }
}

