/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.fluentcore.model.implementation;

import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskItem;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import rx.Completable;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;

public class CreateUpdateTask<ResourceT extends Indexable>
implements TaskItem {
    private ResourceCreatorUpdater<ResourceT> resourceCreatorUpdater;
    private ResourceT resource;

    public CreateUpdateTask(ResourceCreatorUpdater<ResourceT> resourceCreatorUpdater) {
        this.resourceCreatorUpdater = resourceCreatorUpdater;
    }

    public ResourceT result() {
        return this.resource;
    }

    @Override
    public void beforeGroupInvoke() {
        this.resourceCreatorUpdater.beforeGroupCreateOrUpdate();
    }

    @Override
    public Observable<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
        if (this.resourceCreatorUpdater.isInCreateMode()) {
            return this.resourceCreatorUpdater.createResourceAsync().subscribeOn(SdkContext.getRxScheduler()).doOnNext(new Action1<ResourceT>(){

                public void call(ResourceT resourceT) {
                    CreateUpdateTask.this.resource = resourceT;
                }
            }).map(new Func1<ResourceT, Indexable>(){

                public Indexable call(ResourceT resourceT) {
                    return resourceT;
                }
            });
        }
        return this.resourceCreatorUpdater.updateResourceAsync().subscribeOn(SdkContext.getRxScheduler()).doOnNext(new Action1<ResourceT>(){

            public void call(ResourceT resourceT) {
                CreateUpdateTask.this.resource = resourceT;
            }
        }).map(new Func1<ResourceT, Indexable>(){

            public Indexable call(ResourceT resourceT) {
                return resourceT;
            }
        });
    }

    @Override
    public Completable invokeAfterPostRunAsync(boolean isGroupFaulted) {
        return this.resourceCreatorUpdater.afterPostRunAsync(isGroupFaulted);
    }

    @Override
    public boolean isHot() {
        return this.resourceCreatorUpdater.isHot();
    }

    public static interface ResourceCreatorUpdater<T extends Indexable> {
        public boolean isInCreateMode();

        public void beforeGroupCreateOrUpdate();

        public Observable<T> createResourceAsync();

        public Observable<T> updateResourceAsync();

        public boolean isHot();

        public Completable afterPostRunAsync(boolean var1);
    }
}

