/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.management.resources.DebugSetting;
import com.microsoft.azure.management.resources.Dependency;
import com.microsoft.azure.management.resources.Deployment;
import com.microsoft.azure.management.resources.DeploymentExportResult;
import com.microsoft.azure.management.resources.DeploymentMode;
import com.microsoft.azure.management.resources.DeploymentOperations;
import com.microsoft.azure.management.resources.DeploymentProperties;
import com.microsoft.azure.management.resources.DeploymentPropertiesExtended;
import com.microsoft.azure.management.resources.DeploymentWhatIf;
import com.microsoft.azure.management.resources.DeploymentWhatIfProperties;
import com.microsoft.azure.management.resources.DeploymentWhatIfSettings;
import com.microsoft.azure.management.resources.OnErrorDeployment;
import com.microsoft.azure.management.resources.OnErrorDeploymentType;
import com.microsoft.azure.management.resources.ParametersLink;
import com.microsoft.azure.management.resources.Provider;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.TemplateLink;
import com.microsoft.azure.management.resources.WhatIfOperationResult;
import com.microsoft.azure.management.resources.WhatIfResultFormat;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentExportResultImpl;
import com.microsoft.azure.management.resources.implementation.DeploymentExportResultInner;
import com.microsoft.azure.management.resources.implementation.DeploymentExtendedInner;
import com.microsoft.azure.management.resources.implementation.DeploymentInner;
import com.microsoft.azure.management.resources.implementation.DeploymentOperationsImpl;
import com.microsoft.azure.management.resources.implementation.ProviderImpl;
import com.microsoft.azure.management.resources.implementation.ProviderInner;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.management.resources.implementation.WhatIfOperationResultImpl;
import com.microsoft.azure.management.resources.implementation.WhatIfOperationResultInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public final class DeploymentImpl
extends CreatableUpdatableImpl<Deployment, DeploymentExtendedInner, DeploymentImpl>
implements Deployment,
Deployment.Definition,
Deployment.Update,
Deployment.Execution {
    private final ResourceManager resourceManager;
    private String resourceGroupName;
    private Creatable<ResourceGroup> creatableResourceGroup;
    private ObjectMapper objectMapper;
    private DeploymentWhatIf deploymentWhatIf;

    DeploymentImpl(DeploymentExtendedInner innerModel, String name, ResourceManager resourceManager) {
        super(name, innerModel);
        this.resourceGroupName = ResourceUtils.groupFromResourceId(innerModel.id());
        this.resourceManager = resourceManager;
        this.objectMapper = new ObjectMapper();
        this.deploymentWhatIf = new DeploymentWhatIf();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public String provisioningState() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().provisioningState();
    }

    @Override
    public String correlationId() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().correlationId();
    }

    @Override
    public DateTime timestamp() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().timestamp();
    }

    @Override
    public Object outputs() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().outputs();
    }

    @Override
    public List<Provider> providers() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        ArrayList<Provider> providers = new ArrayList<Provider>();
        for (ProviderInner inner : ((DeploymentExtendedInner)((Object)this.inner())).properties().providers()) {
            providers.add(new ProviderImpl(inner));
        }
        return providers;
    }

    @Override
    public List<Dependency> dependencies() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().dependencies();
    }

    @Override
    public Object template() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().template();
    }

    @Override
    public TemplateLink templateLink() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().templateLink();
    }

    @Override
    public Object parameters() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().parameters();
    }

    @Override
    public ParametersLink parametersLink() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().parametersLink();
    }

    @Override
    public DeploymentMode mode() {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            return null;
        }
        return ((DeploymentExtendedInner)((Object)this.inner())).properties().mode();
    }

    @Override
    public DeploymentOperations deploymentOperations() {
        return new DeploymentOperationsImpl(this.manager().inner().deploymentOperations(), this);
    }

    @Override
    public void cancel() {
        this.cancelAsync().await();
    }

    @Override
    public Completable cancelAsync() {
        return this.manager().inner().deployments().cancelAsync(this.resourceGroupName, this.name()).toCompletable();
    }

    @Override
    public ServiceFuture<Void> cancelAsync(ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.cancelAsync(), callback);
    }

    @Override
    public DeploymentExportResult exportTemplate() {
        return (DeploymentExportResult)this.exportTemplateAsync().toBlocking().last();
    }

    @Override
    public Observable<DeploymentExportResult> exportTemplateAsync() {
        return this.manager().inner().deployments().exportTemplateAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<DeploymentExportResultInner, DeploymentExportResult>(){

            public DeploymentExportResult call(DeploymentExportResultInner deploymentExportResultInner) {
                return new DeploymentExportResultImpl(deploymentExportResultInner);
            }
        });
    }

    @Override
    public ServiceFuture<DeploymentExportResult> exportTemplateAsync(ServiceCallback<DeploymentExportResult> callback) {
        return ServiceFuture.fromBody(this.exportTemplateAsync(), callback);
    }

    @Override
    public DeploymentImpl prepareWhatIf() {
        return this;
    }

    @Override
    public DeploymentImpl withNewResourceGroup(String resourceGroupName, Region region) {
        this.creatableResourceGroup = (Creatable)((ResourceGroup.DefinitionStages.Blank)this.resourceManager.resourceGroups().define(resourceGroupName)).withRegion(region);
        this.addDependency(this.creatableResourceGroup);
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentImpl withNewResourceGroup(Creatable<ResourceGroup> resourceGroupDefinition) {
        this.resourceGroupName = resourceGroupDefinition.name();
        this.addDependency(resourceGroupDefinition);
        this.creatableResourceGroup = resourceGroupDefinition;
        return this;
    }

    @Override
    public DeploymentImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public DeploymentImpl withExistingResourceGroup(ResourceGroup resourceGroup) {
        this.resourceGroupName = resourceGroup.name();
        return this;
    }

    @Override
    public DeploymentImpl withTemplate(Object template) {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            ((DeploymentExtendedInner)((Object)this.inner())).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withTemplate(template);
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withTemplateLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withTemplate(String templateJson) throws IOException {
        return this.withTemplate(this.objectMapper.readTree(templateJson));
    }

    @Override
    public DeploymentImpl withTemplateLink(String uri, String contentVersion) {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            ((DeploymentExtendedInner)((Object)this.inner())).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withTemplateLink(new TemplateLink().withUri(uri).withContentVersion(contentVersion));
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withTemplate(null);
        return this;
    }

    @Override
    public DeploymentImpl withMode(DeploymentMode mode) {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            ((DeploymentExtendedInner)((Object)this.inner())).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withMode(mode);
        return this;
    }

    @Override
    public DeploymentImpl withParameters(Object parameters) {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            ((DeploymentExtendedInner)((Object)this.inner())).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withParameters(parameters);
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withParametersLink(null);
        return this;
    }

    @Override
    public DeploymentImpl withParameters(String parametersJson) throws IOException {
        return this.withParameters(this.objectMapper.readTree(parametersJson));
    }

    @Override
    public DeploymentImpl withParametersLink(String uri, String contentVersion) {
        if (((DeploymentExtendedInner)((Object)this.inner())).properties() == null) {
            ((DeploymentExtendedInner)((Object)this.inner())).withProperties(new DeploymentPropertiesExtended());
        }
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withParametersLink(new ParametersLink().withUri(uri).withContentVersion(contentVersion));
        ((DeploymentExtendedInner)((Object)this.inner())).properties().withParameters(null);
        return this;
    }

    private DeploymentInner createRequestFromInner() {
        DeploymentInner inner = new DeploymentInner().withProperties(new DeploymentProperties());
        inner.properties().withMode(this.mode());
        inner.properties().withTemplate(this.template());
        inner.properties().withTemplateLink(this.templateLink());
        inner.properties().withParameters(this.parameters());
        inner.properties().withParametersLink(this.parametersLink());
        return inner;
    }

    @Override
    public DeploymentImpl beginCreate() {
        if (this.creatableResourceGroup != null) {
            this.creatableResourceGroup.create();
        }
        this.setInner(this.manager().inner().deployments().beginCreateOrUpdate(this.resourceGroupName(), this.name(), this.createRequestFromInner()));
        return this;
    }

    @Override
    public Observable<Deployment> beginCreateAsync() {
        return Observable.just(this.creatableResourceGroup).flatMap((Func1)new Func1<Creatable<ResourceGroup>, Observable<Indexable>>(){

            public Observable<Indexable> call(Creatable<ResourceGroup> resourceGroupCreatable) {
                if (resourceGroupCreatable != null) {
                    return DeploymentImpl.this.creatableResourceGroup.createAsync();
                }
                return Observable.just((Object)DeploymentImpl.this);
            }
        }).flatMap((Func1)new Func1<Indexable, Observable<DeploymentExtendedInner>>(){

            public Observable<DeploymentExtendedInner> call(Indexable indexable) {
                return DeploymentImpl.this.manager().inner().deployments().beginCreateOrUpdateAsync(DeploymentImpl.this.resourceGroupName(), DeploymentImpl.this.name(), DeploymentImpl.this.createRequestFromInner());
            }
        }).map(this.innerToFluentMap(this));
    }

    @Override
    public Observable<Deployment> createResourceAsync() {
        return this.manager().inner().deployments().createOrUpdateAsync(this.resourceGroupName(), this.name(), this.createRequestFromInner()).map(this.innerToFluentMap(this));
    }

    @Override
    public Observable<Deployment> applyAsync() {
        return this.updateResourceAsync();
    }

    @Override
    public Observable<Deployment> updateResourceAsync() {
        try {
            if (this.templateLink() != null && this.template() != null) {
                this.withTemplate(null);
            }
            if (this.parametersLink() != null && this.parameters() != null) {
                this.withParameters(null);
            }
        }
        catch (IOException e) {
            return Observable.error((Throwable)e);
        }
        return this.createResourceAsync();
    }

    @Override
    protected Observable<DeploymentExtendedInner> getInnerAsync() {
        return this.manager().inner().deployments().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public boolean isInCreateMode() {
        return ((DeploymentExtendedInner)((Object)this.inner())).id() == null;
    }

    @Override
    public ResourceManager manager() {
        return this.resourceManager;
    }

    @Override
    public String id() {
        return ((DeploymentExtendedInner)((Object)this.inner())).id();
    }

    @Override
    public DeploymentImpl withDetailedLevel(String detailedLevel) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withDebugSetting(new DebugSetting().withDetailLevel(detailedLevel));
        return this;
    }

    @Override
    public DeploymentImpl withDeploymentName(String deploymentName) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().onErrorDeployment() == null) {
            this.deploymentWhatIf.properties().withOnErrorDeployment(new OnErrorDeployment());
        }
        this.deploymentWhatIf.properties().onErrorDeployment().withDeploymentName(deploymentName);
        return this;
    }

    @Override
    public DeploymentImpl withLocation(String location) {
        this.deploymentWhatIf.withLocation(location);
        return this;
    }

    @Override
    public DeploymentImpl withIncrementalMode() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withMode(DeploymentMode.INCREMENTAL);
        return this;
    }

    @Override
    public DeploymentImpl withCompleteMode() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withMode(DeploymentMode.COMPLETE);
        return this;
    }

    @Override
    public DeploymentImpl withFullResourcePayloadsResultFormat() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().whatIfSettings() == null) {
            this.deploymentWhatIf.properties().withWhatIfSettings(new DeploymentWhatIfSettings());
        }
        this.deploymentWhatIf.properties().whatIfSettings().withResultFormat(WhatIfResultFormat.FULL_RESOURCE_PAYLOADS);
        return this;
    }

    @Override
    public DeploymentImpl withResourceIdOnlyResultFormat() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().whatIfSettings() == null) {
            this.deploymentWhatIf.properties().withWhatIfSettings(new DeploymentWhatIfSettings());
        }
        this.deploymentWhatIf.properties().whatIfSettings().withResultFormat(WhatIfResultFormat.RESOURCE_ID_ONLY);
        return this;
    }

    @Override
    public DeploymentImpl withLastSuccessfulOnErrorDeployment() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().onErrorDeployment() == null) {
            this.deploymentWhatIf.properties().withOnErrorDeployment(new OnErrorDeployment());
        }
        this.deploymentWhatIf.properties().onErrorDeployment().withType(OnErrorDeploymentType.LAST_SUCCESSFUL);
        return this;
    }

    @Override
    public DeploymentImpl withSpecialDeploymentOnErrorDeployment() {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        if (this.deploymentWhatIf.properties().onErrorDeployment() == null) {
            this.deploymentWhatIf.properties().withOnErrorDeployment(new OnErrorDeployment());
        }
        this.deploymentWhatIf.properties().onErrorDeployment().withType(OnErrorDeploymentType.SPECIFIC_DEPLOYMENT);
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfTemplate(Object template) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withTemplate(template);
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfTemplateLink(String uri, String contentVersion) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withTemplateLink(new TemplateLink().withUri(uri).withContentVersion(contentVersion));
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfParameters(Object parameters) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withParameters(parameters);
        return this;
    }

    @Override
    public DeploymentImpl withWhatIfParametersLink(String uri, String contentVersion) {
        if (this.deploymentWhatIf.properties() == null) {
            this.deploymentWhatIf.withProperties(new DeploymentWhatIfProperties());
        }
        this.deploymentWhatIf.properties().withParametersLink(new ParametersLink().withUri(uri).withContentVersion(contentVersion));
        return this;
    }

    @Override
    public WhatIfOperationResult whatIf() {
        return (WhatIfOperationResult)this.whatIfAsync().toBlocking().last();
    }

    @Override
    public Observable<WhatIfOperationResult> whatIfAsync() {
        return this.manager().inner().deployments().whatIfAsync(this.resourceGroupName(), this.name(), this.deploymentWhatIf).map((Func1)new Func1<WhatIfOperationResultInner, WhatIfOperationResult>(){

            public WhatIfOperationResult call(WhatIfOperationResultInner whatIfOperationResultInner) {
                return new WhatIfOperationResultImpl(whatIfOperationResultInner);
            }
        });
    }

    @Override
    public ServiceFuture<WhatIfOperationResult> whatIfAsync(ServiceCallback<WhatIfOperationResult> callback) {
        return ServiceFuture.fromBody(this.whatIfAsync(), callback);
    }

    @Override
    public WhatIfOperationResult whatIfAtSubscriptionScope() {
        return (WhatIfOperationResult)this.whatIfAtSubscriptionScopeAsync().toBlocking().last();
    }

    @Override
    public Observable<WhatIfOperationResult> whatIfAtSubscriptionScopeAsync() {
        return this.manager().inner().deployments().whatIfAtSubscriptionScopeAsync(this.name(), this.deploymentWhatIf).map((Func1)new Func1<WhatIfOperationResultInner, WhatIfOperationResult>(){

            public WhatIfOperationResult call(WhatIfOperationResultInner whatIfOperationResultInner) {
                return new WhatIfOperationResultImpl(whatIfOperationResultInner);
            }
        });
    }

    @Override
    public ServiceFuture<WhatIfOperationResult> whatIfAtSubscriptionScopeAsync(ServiceCallback<WhatIfOperationResult> callback) {
        return ServiceFuture.fromBody(this.whatIfAtSubscriptionScopeAsync(), callback);
    }
}

