/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ProviderInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ProvidersInner {
    private ProvidersService service;
    private ResourceManagementClientImpl client;

    public ProvidersInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (ProvidersService)retrofit.create(ProvidersService.class);
        this.client = client;
    }

    public ProviderInner unregister(String resourceProviderNamespace) {
        return (ProviderInner)((ServiceResponse)this.unregisterWithServiceResponseAsync(resourceProviderNamespace).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderInner> unregisterAsync(String resourceProviderNamespace, ServiceCallback<ProviderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.unregisterWithServiceResponseAsync(resourceProviderNamespace), serviceCallback);
    }

    public Observable<ProviderInner> unregisterAsync(String resourceProviderNamespace) {
        return this.unregisterWithServiceResponseAsync(resourceProviderNamespace).map((Func1)new Func1<ServiceResponse<ProviderInner>, ProviderInner>(){

            public ProviderInner call(ServiceResponse<ProviderInner> response) {
                return (ProviderInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderInner>> unregisterWithServiceResponseAsync(String resourceProviderNamespace) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.unregister(resourceProviderNamespace, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderInner>>>(){

            public Observable<ServiceResponse<ProviderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.unregisterDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProviderInner> unregisterDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProviderInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProviderInner register(String resourceProviderNamespace) {
        return (ProviderInner)((ServiceResponse)this.registerWithServiceResponseAsync(resourceProviderNamespace).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderInner> registerAsync(String resourceProviderNamespace, ServiceCallback<ProviderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.registerWithServiceResponseAsync(resourceProviderNamespace), serviceCallback);
    }

    public Observable<ProviderInner> registerAsync(String resourceProviderNamespace) {
        return this.registerWithServiceResponseAsync(resourceProviderNamespace).map((Func1)new Func1<ServiceResponse<ProviderInner>, ProviderInner>(){

            public ProviderInner call(ServiceResponse<ProviderInner> response) {
                return (ProviderInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderInner>> registerWithServiceResponseAsync(String resourceProviderNamespace) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.register(resourceProviderNamespace, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderInner>>>(){

            public Observable<ServiceResponse<ProviderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.registerDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProviderInner> registerDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProviderInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProviderInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ProviderInner>((Page)response.body()){

            public Page<ProviderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderInner>> listAsync(ListOperationCallback<ProviderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Page<ProviderInner>>(){

            public Page<ProviderInner> call(ServiceResponse<Page<ProviderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(ServiceResponse<Page<ProviderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        String expand = null;
        return this.service.list(this.client.subscriptionId(), top, expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ProviderInner> list(Integer top, String expand) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(top, expand).toBlocking().single();
        return new PagedList<ProviderInner>((Page)response.body()){

            public Page<ProviderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderInner>> listAsync(Integer top, String expand, ListOperationCallback<ProviderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(top, expand), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderInner>> listAsync(Integer top, String expand) {
        return this.listWithServiceResponseAsync(top, expand).map((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Page<ProviderInner>>(){

            public Page<ProviderInner> call(ServiceResponse<Page<ProviderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listWithServiceResponseAsync(Integer top, String expand) {
        return this.listSinglePageAsync(top, expand).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(ServiceResponse<Page<ProviderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listSinglePageAsync(Integer top, String expand) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), top, expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProviderInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProviderInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProviderInner> listAtTenantScope() {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeSinglePageAsync().toBlocking().single();
        return new PagedList<ProviderInner>((Page)response.body()){

            public Page<ProviderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderInner>> listAtTenantScopeAsync(ListOperationCallback<ProviderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderInner>> listAtTenantScopeAsync() {
        return this.listAtTenantScopeWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Page<ProviderInner>>(){

            public Page<ProviderInner> call(ServiceResponse<Page<ProviderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listAtTenantScopeWithServiceResponseAsync() {
        return this.listAtTenantScopeSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(ServiceResponse<Page<ProviderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listAtTenantScopeSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer top = null;
        String expand = null;
        return this.service.listAtTenantScope(top, expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ProviderInner> listAtTenantScope(Integer top, String expand) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeSinglePageAsync(top, expand).toBlocking().single();
        return new PagedList<ProviderInner>((Page)response.body()){

            public Page<ProviderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderInner>> listAtTenantScopeAsync(Integer top, String expand, ListOperationCallback<ProviderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeSinglePageAsync(top, expand), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderInner>> listAtTenantScopeAsync(Integer top, String expand) {
        return this.listAtTenantScopeWithServiceResponseAsync(top, expand).map((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Page<ProviderInner>>(){

            public Page<ProviderInner> call(ServiceResponse<Page<ProviderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listAtTenantScopeWithServiceResponseAsync(Integer top, String expand) {
        return this.listAtTenantScopeSinglePageAsync(top, expand).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(ServiceResponse<Page<ProviderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listAtTenantScopeSinglePageAsync(Integer top, String expand) {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listAtTenantScope(top, expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProviderInner>> listAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProviderInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProviderInner get(String resourceProviderNamespace) {
        return (ProviderInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceProviderNamespace).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderInner> getAsync(String resourceProviderNamespace, ServiceCallback<ProviderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceProviderNamespace), serviceCallback);
    }

    public Observable<ProviderInner> getAsync(String resourceProviderNamespace) {
        return this.getWithServiceResponseAsync(resourceProviderNamespace).map((Func1)new Func1<ServiceResponse<ProviderInner>, ProviderInner>(){

            public ProviderInner call(ServiceResponse<ProviderInner> response) {
                return (ProviderInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderInner>> getWithServiceResponseAsync(String resourceProviderNamespace) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String expand = null;
        return this.service.get(resourceProviderNamespace, this.client.subscriptionId(), expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderInner>>>(){

            public Observable<ServiceResponse<ProviderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ProviderInner get(String resourceProviderNamespace, String expand) {
        return (ProviderInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceProviderNamespace, expand).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderInner> getAsync(String resourceProviderNamespace, String expand, ServiceCallback<ProviderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceProviderNamespace, expand), serviceCallback);
    }

    public Observable<ProviderInner> getAsync(String resourceProviderNamespace, String expand) {
        return this.getWithServiceResponseAsync(resourceProviderNamespace, expand).map((Func1)new Func1<ServiceResponse<ProviderInner>, ProviderInner>(){

            public ProviderInner call(ServiceResponse<ProviderInner> response) {
                return (ProviderInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderInner>> getWithServiceResponseAsync(String resourceProviderNamespace, String expand) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceProviderNamespace, this.client.subscriptionId(), expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderInner>>>(){

            public Observable<ServiceResponse<ProviderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProviderInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProviderInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ProviderInner getAtTenantScope(String resourceProviderNamespace) {
        return (ProviderInner)((ServiceResponse)this.getAtTenantScopeWithServiceResponseAsync(resourceProviderNamespace).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderInner> getAtTenantScopeAsync(String resourceProviderNamespace, ServiceCallback<ProviderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtTenantScopeWithServiceResponseAsync(resourceProviderNamespace), serviceCallback);
    }

    public Observable<ProviderInner> getAtTenantScopeAsync(String resourceProviderNamespace) {
        return this.getAtTenantScopeWithServiceResponseAsync(resourceProviderNamespace).map((Func1)new Func1<ServiceResponse<ProviderInner>, ProviderInner>(){

            public ProviderInner call(ServiceResponse<ProviderInner> response) {
                return (ProviderInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderInner>> getAtTenantScopeWithServiceResponseAsync(String resourceProviderNamespace) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String expand = null;
        return this.service.getAtTenantScope(resourceProviderNamespace, expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderInner>>>(){

            public Observable<ServiceResponse<ProviderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ProviderInner getAtTenantScope(String resourceProviderNamespace, String expand) {
        return (ProviderInner)((ServiceResponse)this.getAtTenantScopeWithServiceResponseAsync(resourceProviderNamespace, expand).toBlocking().single()).body();
    }

    public ServiceFuture<ProviderInner> getAtTenantScopeAsync(String resourceProviderNamespace, String expand, ServiceCallback<ProviderInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getAtTenantScopeWithServiceResponseAsync(resourceProviderNamespace, expand), serviceCallback);
    }

    public Observable<ProviderInner> getAtTenantScopeAsync(String resourceProviderNamespace, String expand) {
        return this.getAtTenantScopeWithServiceResponseAsync(resourceProviderNamespace, expand).map((Func1)new Func1<ServiceResponse<ProviderInner>, ProviderInner>(){

            public ProviderInner call(ServiceResponse<ProviderInner> response) {
                return (ProviderInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ProviderInner>> getAtTenantScopeWithServiceResponseAsync(String resourceProviderNamespace, String expand) {
        if (resourceProviderNamespace == null) {
            throw new IllegalArgumentException("Parameter resourceProviderNamespace is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getAtTenantScope(resourceProviderNamespace, expand, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ProviderInner>>>(){

            public Observable<ServiceResponse<ProviderInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ProvidersInner.this.getAtTenantScopeDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ProviderInner> getAtTenantScopeDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ProviderInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProviderInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProviderInner>((Page)response.body()){

            public Page<ProviderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ProviderInner>> serviceFuture, ListOperationCallback<ProviderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Page<ProviderInner>>(){

            public Page<ProviderInner> call(ServiceResponse<Page<ProviderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(ServiceResponse<Page<ProviderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProviderInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProviderInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ProviderInner> listAtTenantScopeNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ProviderInner>((Page)response.body()){

            public Page<ProviderInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ProvidersInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ProviderInner>> listAtTenantScopeNextAsync(String nextPageLink, ServiceFuture<List<ProviderInner>> serviceFuture, ListOperationCallback<ProviderInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listAtTenantScopeNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(String nextPageLink) {
                return ProvidersInner.this.listAtTenantScopeNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ProviderInner>> listAtTenantScopeNextAsync(String nextPageLink) {
        return this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Page<ProviderInner>>(){

            public Page<ProviderInner> call(ServiceResponse<Page<ProviderInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listAtTenantScopeNextWithServiceResponseAsync(String nextPageLink) {
        return this.listAtTenantScopeNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ProviderInner>>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(ServiceResponse<Page<ProviderInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ProvidersInner.this.listAtTenantScopeNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ProviderInner>>> listAtTenantScopeNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listAtTenantScopeNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ProviderInner>>>>(){

            public Observable<ServiceResponse<Page<ProviderInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ProvidersInner.this.listAtTenantScopeNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ProviderInner>> listAtTenantScopeNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ProviderInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ProvidersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers unregister"})
        @POST(value="subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/unregister")
        public Observable<Response<ResponseBody>> unregister(@Path(value="resourceProviderNamespace") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers register"})
        @POST(value="subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}/register")
        public Observable<Response<ResponseBody>> register(@Path(value="resourceProviderNamespace") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers list"})
        @GET(value="subscriptions/{subscriptionId}/providers")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$top") Integer var2, @Query(value="$expand") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers listAtTenantScope"})
        @GET(value="providers")
        public Observable<Response<ResponseBody>> listAtTenantScope(@Query(value="$top") Integer var1, @Query(value="$expand") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers get"})
        @GET(value="subscriptions/{subscriptionId}/providers/{resourceProviderNamespace}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceProviderNamespace") String var1, @Path(value="subscriptionId") String var2, @Query(value="$expand") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers getAtTenantScope"})
        @GET(value="providers/{resourceProviderNamespace}")
        public Observable<Response<ResponseBody>> getAtTenantScope(@Path(value="resourceProviderNamespace") String var1, @Query(value="$expand") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.Providers listAtTenantScopeNext"})
        @GET
        public Observable<Response<ResponseBody>> listAtTenantScopeNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

